/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jruby.RubyModule;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.Operation;
import org.jruby.ir.Tuple;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.Specializeable;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.operands.GlobalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.CFGLinearizer;
import org.jruby.ir.transformations.inlining.CFGInliner;
import org.jruby.parser.StaticScope;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IRScope {
    private static final Logger LOG = LoggerFactory.getLogger("IRScope");
    private static Integer globalScopeCount = 0;
    private int scopeId;
    private String name;
    private final String fileName;
    private final int lineNumber;
    private IRScope lexicalParent;
    private StaticScope staticScope;
    private RubyModule containerModule;
    private List<Instr> instrList;
    private CFG cfg;
    private List<IRClosure> nestedClosures;
    private Set<Variable> definedLocalVars;
    private Set<Variable> usedLocalVars;
    private boolean hasUnusedImplicitBlockArg;
    private TemporaryVariable currentModuleVar;
    private TemporaryVariable currentScopeVar;
    private Map<String, DataFlowProblem> dfProbs;
    private Instr[] linearizedInstrArray;
    private List<BasicBlock> linearizedBBList;
    protected int temporaryVariableIndex;
    private Map<String, Integer> nextVarIndex;
    private int nextClosureIndex;
    List<IRScope> lexicalChildren;
    LocalVariableAllocator localVars;
    LocalVariableAllocator evalScopeVars;
    private boolean canCaptureCallersBinding;
    private boolean canModifyCode;
    private boolean bindingHasEscaped;
    private boolean usesEval;
    private boolean usesBackrefOrLastline;
    private boolean usesZSuper;
    private boolean hasLoops;
    private int threadPollInstrsCount;
    private boolean hasExplicitCallProtocol;
    private boolean relinearizeCFG;
    private IRManager manager;

    protected IRScope(IRScope s2, IRScope lexicalParent) {
        this.lexicalParent = lexicalParent;
        this.manager = s2.manager;
        this.fileName = s2.fileName;
        this.lineNumber = s2.lineNumber;
        this.staticScope = s2.staticScope;
        this.threadPollInstrsCount = s2.threadPollInstrsCount;
        this.nextClosureIndex = s2.nextClosureIndex;
        this.temporaryVariableIndex = s2.temporaryVariableIndex;
        this.hasLoops = s2.hasLoops;
        this.hasUnusedImplicitBlockArg = s2.hasUnusedImplicitBlockArg;
        this.instrList = null;
        this.nestedClosures = new ArrayList<IRClosure>();
        this.dfProbs = new HashMap<String, DataFlowProblem>();
        this.nextVarIndex = new HashMap<String, Integer>();
        this.cfg = null;
        this.linearizedInstrArray = null;
        this.linearizedBBList = null;
        this.canModifyCode = s2.canModifyCode;
        this.canCaptureCallersBinding = s2.canCaptureCallersBinding;
        this.bindingHasEscaped = s2.bindingHasEscaped;
        this.usesEval = s2.usesEval;
        this.usesBackrefOrLastline = s2.usesBackrefOrLastline;
        this.usesZSuper = s2.usesZSuper;
        this.hasExplicitCallProtocol = s2.hasExplicitCallProtocol;
        this.localVars = new LocalVariableAllocator();
        this.localVars.nextSlot = s2.localVars.nextSlot;
        this.relinearizeCFG = false;
        this.setupLexicalContainment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRScope(IRManager manager, IRScope lexicalParent, String name2, String fileName, int lineNumber, StaticScope staticScope) {
        this.manager = manager;
        this.lexicalParent = lexicalParent;
        this.name = name2;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.staticScope = staticScope;
        this.threadPollInstrsCount = 0;
        this.nextClosureIndex = 0;
        this.temporaryVariableIndex = -1;
        this.instrList = new ArrayList<Instr>();
        this.nestedClosures = new ArrayList<IRClosure>();
        this.dfProbs = new HashMap<String, DataFlowProblem>();
        this.nextVarIndex = new HashMap<String, Integer>();
        this.cfg = null;
        this.linearizedInstrArray = null;
        this.linearizedBBList = null;
        this.hasLoops = false;
        this.hasUnusedImplicitBlockArg = false;
        this.canModifyCode = true;
        this.canCaptureCallersBinding = true;
        this.bindingHasEscaped = true;
        this.usesEval = true;
        this.usesBackrefOrLastline = true;
        this.usesZSuper = true;
        this.hasExplicitCallProtocol = false;
        this.localVars = new LocalVariableAllocator();
        Integer n = globalScopeCount;
        synchronized (n) {
            Integer n2 = globalScopeCount;
            Integer n3 = globalScopeCount = Integer.valueOf(globalScopeCount + 1);
            this.scopeId = n2;
        }
        this.relinearizeCFG = false;
        this.setupLexicalContainment();
    }

    private final void setupLexicalContainment() {
        if (this.manager.isDryRun()) {
            this.lexicalChildren = new ArrayList<IRScope>();
            if (this.lexicalParent != null) {
                this.lexicalParent.addChildScope(this);
            }
        }
    }

    public int hashCode() {
        return this.scopeId;
    }

    protected void addChildScope(IRScope scope) {
        this.lexicalChildren.add(scope);
    }

    public List<IRScope> getLexicalScopes() {
        return this.lexicalChildren;
    }

    public void addClosure(IRClosure c) {
        this.nestedClosures.add(c);
    }

    public Instr getLastInstr() {
        return this.instrList.get(this.instrList.size() - 1);
    }

    public void addInstr(Instr i2) {
        if (i2 instanceof ThreadPollInstr) {
            ++this.threadPollInstrsCount;
        }
        this.instrList.add(i2);
    }

    public LocalVariable getNewFlipStateVariable() {
        return this.getLocalVariable("%flip_" + this.allocateNextPrefixedName("%flip"), 0);
    }

    public void initFlipStateVariable(Variable v, Operand initState) {
        this.instrList.add(0, new CopyInstr(v, initState));
    }

    public boolean isForLoopBody() {
        return false;
    }

    public Label getNewLabel(String prefix) {
        return new Label(prefix + "_" + this.allocateNextPrefixedName(prefix));
    }

    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    public List<IRClosure> getClosures() {
        return this.nestedClosures;
    }

    public IRManager getManager() {
        return this.manager;
    }

    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public IRMethod getNearestMethod() {
        IRScope current2;
        for (current2 = this; current2 != null && !(current2 instanceof IRMethod); current2 = current2.getLexicalParent()) {
        }
        return (IRMethod)current2;
    }

    public IRScope getNearestFlipVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isFlipScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public IRScope getNearestTopLocalVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isTopLocalVariableScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public IRScope getNearestModuleReferencingScope() {
        IRScope current2 = this;
        while (!(current2 instanceof IRModuleBody)) {
            if (current2 == null || current2 instanceof IREvalScript) {
                return null;
            }
            current2 = current2.getLexicalParent();
        }
        return current2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IRScope getTopLevelScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isScriptScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isNestedInClosure(IRClosure closure) {
        for (IRScope s2 = this; s2 != null && !s2.isTopLocalVariableScope(); s2 = s2.getLexicalParent()) {
            if (s2 != closure) continue;
            return true;
        }
        return false;
    }

    public void setHasLoopsFlag(boolean f) {
        this.hasLoops = true;
    }

    public boolean hasLoops() {
        return this.hasLoops;
    }

    public boolean hasExplicitCallProtocol() {
        return this.hasExplicitCallProtocol;
    }

    public void setExplicitCallProtocolFlag(boolean flag) {
        this.hasExplicitCallProtocol = flag;
    }

    public void setCodeModificationFlag(boolean f) {
        this.canModifyCode = f;
    }

    public boolean modifiesCode() {
        return this.canModifyCode;
    }

    public boolean bindingHasEscaped() {
        return this.bindingHasEscaped;
    }

    public boolean usesBackrefOrLastline() {
        return this.usesBackrefOrLastline;
    }

    public boolean usesEval() {
        return this.usesEval;
    }

    public boolean usesZSuper() {
        return this.usesZSuper;
    }

    public boolean canCaptureCallersBinding() {
        return this.canCaptureCallersBinding;
    }

    public CFG buildCFG() {
        this.cfg = new CFG(this);
        this.cfg.build(this.instrList);
        this.instrList = null;
        return this.cfg;
    }

    protected void setCFG(CFG cfg) {
        this.cfg = cfg;
    }

    public CFG getCFG() {
        return this.cfg;
    }

    private void setupLabelPCs(HashMap<Label, Integer> labelIPCMap) {
        for (BasicBlock b : this.linearizedBBList) {
            Label l = b.getLabel();
            l.setTargetPC(labelIPCMap.get(l));
        }
    }

    private Instr[] prepareInstructionsForInterpretation() {
        this.checkRelinearization();
        if (this.linearizedInstrArray != null) {
            return this.linearizedInstrArray;
        }
        try {
            this.buildLinearization();
            this.depends(this.linearization());
        }
        catch (RuntimeException e) {
            LOG.error("Error linearizing cfg: ", e);
            CFG c = this.cfg();
            LOG.error("\nGraph:\n" + c.toStringGraph(), new Object[0]);
            LOG.error("\nInstructions:\n" + c.toStringInstrs(), new Object[0]);
            throw e;
        }
        HashMap<Label, Integer> labelIPCMap = new HashMap<Label, Integer>();
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        int ipc = 0;
        for (BasicBlock b : this.linearizedBBList) {
            labelIPCMap.put(b.getLabel(), ipc);
            List<Instr> bbInstrs = b.getInstrs();
            int bbInstrsLength = bbInstrs.size();
            for (int i2 = 0; i2 < bbInstrsLength; ++i2) {
                Instr instr = bbInstrs.get(i2);
                if (instr instanceof Specializeable) {
                    instr = ((Specializeable)((Object)instr)).specializeForInterpretation();
                    bbInstrs.set(i2, instr);
                }
                if (instr instanceof ReceiveSelfInstr) continue;
                newInstrs.add(instr);
                ++ipc;
            }
        }
        this.setupLabelPCs(labelIPCMap);
        this.cfg().getExitBB().getLabel().setTargetPC(ipc + 1);
        this.linearizedInstrArray = newInstrs.toArray(new Instr[newInstrs.size()]);
        return this.linearizedInstrArray;
    }

    private void runCompilerPasses() {
        this.initEvalScopeVariableAllocator(true);
        for (CompilerPass pass2 : this.getManager().getCompilerPasses(this)) {
            pass2.run(this);
        }
    }

    public synchronized Instr[] prepareForInterpretation() {
        this.checkRelinearization();
        if (this.linearizedInstrArray != null) {
            return this.linearizedInstrArray;
        }
        if (this.getCFG() == null) {
            this.runCompilerPasses();
        }
        return this.prepareInstructionsForInterpretation();
    }

    public Tuple<Instr[], Map<Integer, Label[]>> prepareForCompilation() {
        if (this.getCFG() == null) {
            this.runCompilerPasses();
        }
        try {
            this.buildLinearization();
            this.depends(this.linearization());
        }
        catch (RuntimeException e) {
            LOG.error("Error linearizing cfg: ", e);
            CFG c = this.cfg();
            LOG.error("\nGraph:\n" + c.toStringGraph(), new Object[0]);
            LOG.error("\nInstructions:\n" + c.toStringInstrs(), new Object[0]);
            throw e;
        }
        HashMap<Integer, Label[]> ipcLabelMap = new HashMap<Integer, Label[]>();
        HashMap<Label, Integer> labelIPCMap = new HashMap<Label, Integer>();
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        int ipc = 0;
        for (BasicBlock b : this.linearizedBBList) {
            Label l = b.getLabel();
            labelIPCMap.put(l, ipc);
            ipcLabelMap.put(ipc, IRScope.catLabels((Label[])ipcLabelMap.get(ipc), l));
            for (Instr i2 : b.getInstrs()) {
                if (i2 instanceof ReceiveSelfInstr) continue;
                newInstrs.add(i2);
                ++ipc;
            }
        }
        this.setupLabelPCs(labelIPCMap);
        return new Tuple<Instr[], Map<Integer, Label[]>>(newInstrs.toArray(new Instr[newInstrs.size()]), ipcLabelMap);
    }

    private List<Object[]> buildJVMExceptionTable() {
        ArrayList<Object[]> etEntries = new ArrayList<Object[]>();
        for (BasicBlock b : this.linearizedBBList) {
            int end2;
            int start2;
            BasicBlock rBB = this.cfg().getRescuerBBFor(b);
            BasicBlock eBB = this.cfg().getEnsurerBBFor(b);
            if (eBB != null && (rBB == eBB || rBB == null)) {
                start2 = b.getLabel().getTargetPC();
                end2 = start2 + b.instrCount();
                etEntries.add(new Object[]{start2, end2, eBB.getLabel().getTargetPC(), Throwable.class});
                continue;
            }
            if (rBB == null) continue;
            start2 = b.getLabel().getTargetPC();
            end2 = start2 + b.instrCount();
            if (eBB != null) {
                etEntries.add(new Object[]{start2, end2, eBB.getLabel().getTargetPC(), Unrescuable.class});
            }
            etEntries.add(new Object[]{start2, end2, rBB.getLabel().getTargetPC(), Throwable.class});
        }
        return etEntries;
    }

    private static Label[] catLabels(Label[] labels, Label cat) {
        if (labels == null) {
            return new Label[]{cat};
        }
        Label[] newLabels = new Label[labels.length + 1];
        System.arraycopy(labels, 0, newLabels, 0, labels.length);
        newLabels[labels.length] = cat;
        return newLabels;
    }

    private boolean computeScopeFlags(boolean receivesClosureArg, List<Instr> instrs) {
        for (Instr i2 : instrs) {
            String gvName;
            GlobalVariable gv;
            Operation op = i2.getOperation();
            if (op == Operation.RECV_CLOSURE) {
                receivesClosureArg = true;
                continue;
            }
            if (op == Operation.ZSUPER) {
                this.canCaptureCallersBinding = true;
                this.usesZSuper = true;
                continue;
            }
            if (i2 instanceof CallBase) {
                Operand o;
                CallBase call2 = (CallBase)i2;
                if (call2.targetRequiresCallersBinding()) {
                    this.bindingHasEscaped = true;
                }
                if ((o = ((CallBase)i2).getClosureArg(null)) != null && o instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    cl.computeScopeFlags();
                    if (cl.usesZSuper()) {
                        this.usesZSuper = true;
                    }
                }
                if (!call2.canBeEval()) continue;
                this.usesEval = true;
                if (!receivesClosureArg || call2.getCallArgs().length <= 1) continue;
                this.canCaptureCallersBinding = true;
                continue;
            }
            if (op == Operation.GET_GLOBAL_VAR) {
                gv = (GlobalVariable)((GetGlobalVariableInstr)i2).getSource();
                gvName = gv.getName();
                if (!gvName.equals("$_") && !gvName.equals("$~") && !gvName.equals("$`") && !gvName.equals("$'") && !gvName.equals("$+") && !gvName.equals("$LAST_READ_LINE") && !gvName.equals("$LAST_MATCH_INFO") && !gvName.equals("$PREMATCH") && !gvName.equals("$POSTMATCH") && !gvName.equals("$LAST_PAREN_MATCH")) continue;
                this.usesBackrefOrLastline = true;
                continue;
            }
            if (op == Operation.PUT_GLOBAL_VAR) {
                gv = (GlobalVariable)((PutGlobalVarInstr)i2).getTarget();
                gvName = gv.getName();
                if (!gvName.equals("$_") && !gvName.equals("$~")) continue;
                this.usesBackrefOrLastline = true;
                continue;
            }
            if (op != Operation.MATCH && op != Operation.MATCH2 && op != Operation.MATCH3) continue;
            this.usesBackrefOrLastline = true;
        }
        return receivesClosureArg;
    }

    public void computeScopeFlags() {
        this.canModifyCode = true;
        this.canCaptureCallersBinding = false;
        this.usesZSuper = false;
        this.usesEval = false;
        this.usesBackrefOrLastline = false;
        this.bindingHasEscaped = this instanceof IREvalScript;
        if (this.cfg == null) {
            this.computeScopeFlags(false, this.getInstrs());
        } else {
            boolean receivesClosureArg = false;
            for (BasicBlock b : this.cfg.getBasicBlocks()) {
                receivesClosureArg = this.computeScopeFlags(receivesClosureArg, b.getInstrs());
            }
        }
    }

    public abstract String getScopeName();

    public String toString() {
        return this.getScopeName() + " " + this.getName() + "[" + this.getFileName() + ":" + this.getLineNumber() + "]";
    }

    public String toStringInstrs() {
        StringBuilder b = new StringBuilder();
        int i2 = 0;
        for (Instr instr : this.instrList) {
            if (i2 > 0) {
                b.append("\n");
            }
            b.append("  ").append(i2).append('\t').append(instr);
            ++i2;
        }
        if (!this.nestedClosures.isEmpty()) {
            b.append("\n\n------ Closures encountered in this scope ------\n");
            for (IRClosure c : this.nestedClosures) {
                b.append(c.toStringBody());
            }
            b.append("------------------------------------------------\n");
        }
        return b.toString();
    }

    public String toPersistableString() {
        StringBuilder b = new StringBuilder();
        b.append("Scope:<");
        b.append(this.name);
        b.append(">");
        for (Instr instr : this.instrList) {
            b.append("\n");
            b.append(instr);
        }
        return b.toString();
    }

    public String toStringVariables() {
        HashMap<Variable, Integer> ends = new HashMap<Variable, Integer>();
        HashMap<Variable, Integer> starts = new HashMap<Variable, Integer>();
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (int i2 = this.instrList.size() - 1; i2 >= 0; --i2) {
            Instr instr = this.instrList.get(i2);
            if (instr instanceof ResultInstr) {
                Variable var = ((ResultInstr)((Object)instr)).getResult();
                variables.add(var);
                starts.put(var, i2);
            }
            for (Operand operand : instr.getOperands()) {
                if (operand == null || !(operand instanceof Variable) || ends.get((Variable)operand) != null) continue;
                ends.put((Variable)operand, i2);
                variables.add((Variable)operand);
            }
        }
        StringBuilder sb = new StringBuilder();
        int i3 = 0;
        for (Variable var : variables) {
            Integer end2 = (Integer)ends.get(var);
            if (end2 == null) continue;
            if (i3 > 0) {
                sb.append("\n");
            }
            ++i3;
            sb.append("    ").append(var).append(": ").append(starts.get(var)).append("-").append(end2);
        }
        return sb.toString();
    }

    public LocalVariable getSelf() {
        return Self.SELF;
    }

    public Variable getCurrentModuleVariable() {
        if (this.currentModuleVar == null) {
            this.currentModuleVar = this.getNewTemporaryVariable("%current_module");
        }
        return this.currentModuleVar;
    }

    public Variable getCurrentScopeVariable() {
        if (this.currentScopeVar == null) {
            this.currentScopeVar = this.getNewTemporaryVariable("%current_scope");
        }
        return this.currentScopeVar;
    }

    public abstract LocalVariable getImplicitBlockArg();

    public void markUnusedImplicitBlockArg() {
        this.hasUnusedImplicitBlockArg = true;
    }

    public LocalVariable findExistingLocalVariable(String name2, int depth) {
        return this.localVars.getVariable(name2);
    }

    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = new LocalVariable(name2, scopeDepth, this.localVars.nextSlot);
            this.localVars.putVariable(name2, lvar);
        }
        return lvar;
    }

    public LocalVariable getNewLocalVariable(String name2, int depth) {
        throw new RuntimeException("getNewLocalVariable should be called for: " + this.getClass().getName());
    }

    protected void initEvalScopeVariableAllocator(boolean reset2) {
        if (reset2 || this.evalScopeVars == null) {
            this.evalScopeVars = new LocalVariableAllocator();
        }
    }

    public TemporaryVariable getNewTemporaryVariable() {
        ++this.temporaryVariableIndex;
        return new TemporaryVariable(this.temporaryVariableIndex);
    }

    public TemporaryVariable getNewTemporaryVariable(String name2) {
        ++this.temporaryVariableIndex;
        return new TemporaryVariable(name2, this.temporaryVariableIndex);
    }

    public void resetTemporaryVariables() {
        this.temporaryVariableIndex = -1;
    }

    public int getTemporaryVariableSize() {
        return this.temporaryVariableIndex + 1;
    }

    public Variable getNewInlineVariable(String inlinePrefix, Variable v) {
        if (v instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)v;
            return this.getLocalVariable(inlinePrefix + lv.getName(), lv.getScopeDepth());
        }
        return this.getNewTemporaryVariable();
    }

    public int getThreadPollInstrsCount() {
        return this.threadPollInstrsCount;
    }

    public int getLocalVariablesCount() {
        return this.localVars.nextSlot;
    }

    public int getUsedVariablesCount() {
        return this.getLocalVariablesCount() + this.getPrefixCountSize("%flip");
    }

    public void setUpUseDefLocalVarMaps() {
        this.definedLocalVars = new HashSet<Variable>();
        this.usedLocalVars = new HashSet<Variable>();
        for (BasicBlock bb : this.cfg().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                Variable v;
                for (Variable v2 : i2.getUsedVariables()) {
                    if (!(v2 instanceof LocalVariable)) continue;
                    this.usedLocalVars.add(v2);
                }
                if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable)) continue;
                this.definedLocalVars.add(v);
            }
        }
        for (IRClosure cl : this.getClosures()) {
            cl.setUpUseDefLocalVarMaps();
        }
    }

    public boolean usesLocalVariable(Variable v) {
        if (this.usedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.usedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getClosures()) {
            if (!cl.usesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean definesLocalVariable(Variable v) {
        if (this.definedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.definedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getClosures()) {
            if (!cl.definesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public void setDataFlowSolution(String name2, DataFlowProblem p2) {
        this.dfProbs.put(name2, p2);
    }

    public DataFlowProblem getDataFlowSolution(String name2) {
        return this.dfProbs.get(name2);
    }

    public List<Instr> getInstrs() {
        if (this.cfg != null) {
            throw new RuntimeException("Please use the CFG to access this scope's instructions.");
        }
        return this.instrList;
    }

    public Instr[] getInstrsForInterpretation() {
        return this.linearizedInstrArray;
    }

    public void resetLinearizationData() {
        this.linearizedBBList = null;
        this.relinearizeCFG = false;
    }

    public void checkRelinearization() {
        if (this.relinearizeCFG) {
            this.resetLinearizationData();
        }
    }

    public List<BasicBlock> buildLinearization() {
        this.checkRelinearization();
        if (this.linearizedBBList != null) {
            return this.linearizedBBList;
        }
        this.linearizedBBList = CFGLinearizer.linearize(this.cfg);
        return this.linearizedBBList;
    }

    public int getRescuerPC(Instr excInstr) {
        this.depends(this.cfg());
        for (BasicBlock b : this.linearizedBBList) {
            for (Instr i2 : b.getInstrs()) {
                if (i2 != excInstr) continue;
                BasicBlock rescuerBB = this.cfg().getRescuerBBFor(b);
                return rescuerBB == null ? -1 : rescuerBB.getLabel().getTargetPC();
            }
        }
        LOG.error("Fell through looking for rescuer ipc for " + excInstr, new Object[0]);
        return -1;
    }

    public int getEnsurerPC(Instr excInstr) {
        this.depends(this.cfg());
        for (BasicBlock b : this.linearizedBBList) {
            for (Instr i2 : b.getInstrs()) {
                if (i2 != excInstr) continue;
                BasicBlock ensurerBB = this.cfg.getEnsurerBBFor(b);
                return ensurerBB == null ? -1 : ensurerBB.getLabel().getTargetPC();
            }
        }
        LOG.error("Fell through looking for ensurer ipc for " + excInstr, new Object[0]);
        return -1;
    }

    public List<BasicBlock> linearization() {
        this.depends(this.cfg());
        assert (this.linearizedBBList != null) : "You have not run linearization";
        return this.linearizedBBList;
    }

    protected void depends(Object obj) {
        assert (obj != null) : "Unsatisfied dependency and this depends() was set up wrong.  Use depends(build()) not depends(build).";
    }

    public CFG cfg() {
        assert (this.cfg != null) : "Trying to access build before build started";
        return this.cfg;
    }

    public void splitCalls() {
    }

    public void resetDFProblemsState() {
        this.dfProbs = new HashMap<String, DataFlowProblem>();
        for (IRClosure c : this.nestedClosures) {
            c.resetDFProblemsState();
        }
    }

    public void resetState() {
        this.relinearizeCFG = true;
        this.linearizedInstrArray = null;
        this.cfg.resetState();
        this.canModifyCode = true;
        this.canCaptureCallersBinding = true;
        this.bindingHasEscaped = true;
        this.usesEval = true;
        this.usesZSuper = true;
        this.resetDFProblemsState();
    }

    public void inlineMethod(IRScope method2, RubyModule implClass, int classToken, BasicBlock basicBlock, CallBase call2) {
        this.depends(this.cfg());
        new CFGInliner(this.cfg).inlineMethod(method2, implClass, classToken, basicBlock, call2);
        this.resetState();
        for (CompilerPass pass2 : this.getManager().getInliningCompilerPasses(this)) {
            pass2.run(this);
        }
    }

    public void buildCFG(List<Instr> instrList) {
        CFG newBuild = new CFG(this);
        newBuild.build(instrList);
        this.cfg = newBuild;
    }

    public void resetCFG() {
        this.cfg = null;
    }

    public void recordBeginBlock(IRClosure beginBlockClosure) {
        throw new RuntimeException("BEGIN blocks cannot be added to: " + this.getClass().getName());
    }

    public void recordEndBlock(IRClosure endBlockClosure) {
        throw new RuntimeException("END blocks cannot be added to: " + this.getClass().getName());
    }

    protected int allocateNextPrefixedName(String prefix) {
        int index2 = this.getPrefixCountSize(prefix);
        this.nextVarIndex.put(prefix, index2 + 1);
        return index2;
    }

    protected void resetVariableCounter(String prefix) {
        this.nextVarIndex.remove(prefix);
    }

    protected int getPrefixCountSize(String prefix) {
        Integer index2 = this.nextVarIndex.get(prefix);
        if (index2 == null) {
            return 0;
        }
        return index2;
    }

    public RubyModule getContainerModule() {
        return this.containerModule;
    }

    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public boolean isModuleBody() {
        return false;
    }

    public boolean isNonSingletonClassBody() {
        return false;
    }

    public boolean isFlipScope() {
        return true;
    }

    public boolean isTopLocalVariableScope() {
        return true;
    }

    public boolean isScriptScope() {
        return false;
    }

    protected static class LocalVariableAllocator {
        public int nextSlot = 0;
        public Map<String, LocalVariable> varMap = new HashMap<String, LocalVariable>();

        public final LocalVariable getVariable(String name2) {
            return this.varMap.get(name2);
        }

        public final void putVariable(String name2, LocalVariable var) {
            this.varMap.put(name2, var);
            ++this.nextSlot;
        }
    }
}

