/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.Mime;
import org.jruby.ext.openssl.impl.MimeHeader;
import org.jruby.ext.openssl.impl.MimeParam;
import org.jruby.ext.openssl.impl.PKCS7;
import org.jruby.ext.openssl.impl.PKCS7Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMIME {
    public static final int MAX_SMLEN = 1024;
    public static final byte[] NEWLINE = new byte[]{13, 10};
    private Mime mime;

    public SMIME() {
        this(Mime.DEFAULT);
    }

    public SMIME(Mime mime) {
        this.mime = mime;
    }

    private static boolean equals(byte[] first2, int firstIndex, byte[] second, int secondIndex, int length2) {
        int len = length2;
        int i2 = firstIndex;
        int flen = first2.length;
        int slen = second.length;
        for (int j = secondIndex; i2 < flen && j < slen && len > 0; ++i2, ++j, --len) {
            if (first2[i2] == second[j]) continue;
            return false;
        }
        return len == 0;
    }

    public static boolean stripEol(byte[] linebuf, int[] plen) {
        int len = plen[0];
        boolean isEol = false;
        int p2 = len - 1;
        while (len > 0) {
            byte c = linebuf[p2];
            if (c == 10) {
                isEol = true;
            } else if (c != 13) break;
            --len;
            --p2;
        }
        plen[0] = len;
        return isEol;
    }

    public void text(BIO input, BIO output) {
    }

    private int boundCheck(byte[] line, int linelen, byte[] bound, int blen) {
        if (linelen == -1) {
            linelen = line.length;
        }
        if (blen == -1) {
            blen = bound.length;
        }
        if (blen + 2 > linelen) {
            return 0;
        }
        if (line[0] == 45 && line[1] == 45 && SMIME.equals(line, 2, bound, 0, blen)) {
            if (line.length >= blen + 4 && line[2 + blen] == 45 && line[2 + blen + 1] == 45) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public PKCS7 readPKCS7Base64(BIO bio) throws IOException, PKCS7Exception {
        BIO bio64 = BIO.base64Filter(bio);
        return PKCS7.fromASN1(bio64);
    }

    private List<BIO> multiSplit(BIO bio, byte[] bound) throws IOException {
        ArrayList<BIO> parts = new ArrayList<BIO>();
        byte[] linebuf = new byte[1024];
        int blen = bound.length;
        boolean eol = false;
        int len = 0;
        int part = 0;
        int state2 = 0;
        boolean first2 = true;
        BIO bpart = null;
        while ((len = bio.gets(linebuf, 1024)) > 0) {
            state2 = this.boundCheck(linebuf, len, bound, blen);
            if (state2 == 1) {
                first2 = true;
                ++part;
                continue;
            }
            if (state2 == 2) {
                parts.add(bpart);
                return parts;
            }
            if (part == 0) continue;
            int[] tmp = new int[]{len};
            boolean nextEol = SMIME.stripEol(linebuf, tmp);
            len = tmp[0];
            if (first2) {
                first2 = false;
                if (bpart != null) {
                    parts.add(bpart);
                }
                bpart = BIO.mem();
                bpart.setMemEofReturn(0);
            } else if (eol) {
                bpart.write(NEWLINE, 0, 2);
            }
            eol = nextEol;
            if (len == 0) continue;
            bpart.write(linebuf, 0, len);
        }
        return parts;
    }

    public PKCS7 readPKCS7(BIO bio, BIO[] bcont) throws IOException, PKCS7Exception {
        List<MimeHeader> headers;
        if (bcont != null && bcont.length > 0) {
            bcont[0] = null;
        }
        if ((headers = this.mime.parseHeaders(bio)) == null) {
            throw new PKCS7Exception(122, 133);
        }
        MimeHeader hdr = this.mime.findHeader(headers, "content-type");
        if (hdr == null || hdr.getValue() == null) {
            throw new PKCS7Exception(122, 135);
        }
        if ("multipart/signed".equals(hdr.getValue())) {
            MimeParam prm = this.mime.findParam(hdr, "boundary");
            if (prm == null || prm.getParamValue() == null) {
                throw new PKCS7Exception(122, 137);
            }
            byte[] boundary = null;
            try {
                boundary = prm.getParamValue().getBytes("ISO8859-1");
            }
            catch (Exception e) {
                throw new PKCS7Exception(122, 137, e);
            }
            List<BIO> parts = this.multiSplit(bio, boundary);
            if (parts == null || parts.size() != 2) {
                throw new PKCS7Exception(122, 136);
            }
            BIO p7in = parts.get(1);
            headers = this.mime.parseHeaders(p7in);
            if (headers == null) {
                throw new PKCS7Exception(122, 134);
            }
            hdr = this.mime.findHeader(headers, "content-type");
            if (hdr == null || hdr.getValue() == null) {
                throw new PKCS7Exception(122, 138);
            }
            if (!("application/x-pkcs7-signature".equals(hdr.getValue()) || "application/pkcs7-signature".equals(hdr.getValue()) || "application/x-pkcs7-mime".equals(hdr.getValue()) || "application/pkcs7-mime".equals(hdr.getValue()))) {
                throw new PKCS7Exception(122, 141, "type: " + hdr.getValue());
            }
            PKCS7 p7 = this.readPKCS7Base64(p7in);
            if (bcont != null && bcont.length > 0) {
                bcont[0] = parts.get(0);
            }
            return p7;
        }
        if (!"application/x-pkcs7-mime".equals(hdr.getValue()) && !"application/pkcs7-mime".equals(hdr.getValue())) {
            throw new PKCS7Exception(122, 131, "type: " + hdr.getValue());
        }
        return this.readPKCS7Base64(bio);
    }
}

