/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.DERString;
import org.jruby.org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Name
extends RubyObject {
    private static final long serialVersionUID = -226196051911335103L;
    private static ObjectAllocator X509NAME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Name(runtime, klass);
        }
    };
    public static final int COMPAT = 0;
    public static final int RFC2253 = 17892119;
    public static final int ONELINE = 8520479;
    public static final int MULTILINE = 44302342;
    private List<Object> oids = new ArrayList<Object>();
    private List<Object> values = new ArrayList<Object>();
    private List<Object> types = new ArrayList<Object>();

    public static void createX509Name(Ruby runtime, RubyModule mX509) {
        RubyClass cX509Name = mX509.defineClassUnder("Name", runtime.getObject(), X509NAME_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("NameError", openSSLError, openSSLError.getAllocator());
        cX509Name.defineAnnotatedMethods(X509Name.class);
        cX509Name.setConstant("COMPAT", runtime.newFixnum(0));
        cX509Name.setConstant("RFC2253", runtime.newFixnum(17892119));
        cX509Name.setConstant("ONELINE", runtime.newFixnum(8520479));
        cX509Name.setConstant("MULTILINE", runtime.newFixnum(44302342));
        cX509Name.setConstant("DEFAULT_OBJECT_TYPE", runtime.newFixnum(12));
        RubyHash hash2 = new RubyHash(runtime, runtime.newFixnum(12));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("C"), runtime.newFixnum(19));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("countryName"), runtime.newFixnum(19));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("serialNumber"), runtime.newFixnum(19));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("dnQualifier"), runtime.newFixnum(19));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("DC"), runtime.newFixnum(22));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("domainComponent"), runtime.newFixnum(22));
        hash2.op_aset(runtime.getCurrentContext(), runtime.newString("emailAddress"), runtime.newFixnum(22));
        cX509Name.setConstant("OBJECT_TYPE_TEMPLATE", hash2);
    }

    public X509Name(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    void addEntry(Object oid2, Object value2, Object type2) {
        this.oids.add(oid2);
        this.values.add(value2);
        this.types.add(type2);
    }

    public static X509Name create(Ruby runtime, org.jruby.org.bouncycastle.asn1.x509.X509Name realName) {
        X509Name name2 = new X509Name(runtime, Utils.getClassFromPath(runtime, "OpenSSL::X509::Name"));
        name2.fromASN1Sequence((ASN1Sequence)realName.getDERObject());
        return name2;
    }

    void fromASN1Sequence(ASN1Sequence seq) {
        this.oids = new ArrayList<Object>();
        this.values = new ArrayList<Object>();
        this.types = new ArrayList<Object>();
        Enumeration enumRdn = seq.getObjects();
        while (enumRdn.hasMoreElements()) {
            ASN1Set rdn = (ASN1Set)enumRdn.nextElement();
            Enumeration enumTypeAndValue = rdn.getObjects();
            while (enumTypeAndValue.hasMoreElements()) {
                ASN1Sequence typeAndValue = (ASN1Sequence)enumTypeAndValue.nextElement();
                this.oids.add(typeAndValue.getObjectAt(0));
                if (typeAndValue.getObjectAt(1) instanceof DERString) {
                    this.values.add(((DERString)((Object)typeAndValue.getObjectAt(1))).getString());
                } else {
                    this.values.add(null);
                }
                this.types.add(this.getRuntime().newFixnum(ASN1.idForClass(typeAndValue.getObjectAt(1).getClass())));
            }
        }
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject str_or_dn) {
        return this.initialize(context, str_or_dn, context.nil);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject dn, IRubyObject template) {
        Ruby runtime = context.runtime;
        if (dn instanceof RubyArray) {
            RubyArray ary = (RubyArray)dn;
            if (template.isNil()) {
                template = runtime.getClassFromPath("OpenSSL::X509::Name").getConstant("OBJECT_TYPE_TEMPLATE");
            }
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                IRubyObject entry2;
                IRubyObject obj = ary.eltOk(i2);
                if (!(obj instanceof RubyArray)) {
                    throw runtime.newTypeError(obj, runtime.getArray());
                }
                RubyArray arr = (RubyArray)obj;
                IRubyObject entry0 = arr.size() > 0 ? arr.eltOk(0L) : context.nil;
                IRubyObject entry1 = arr.size() > 1 ? arr.eltOk(1L) : context.nil;
                IRubyObject iRubyObject = entry2 = arr.size() > 2 ? arr.eltOk(2L) : context.nil;
                if (entry2.isNil()) {
                    entry2 = template.callMethod(context, "[]", entry0);
                }
                if (entry2.isNil()) {
                    entry2 = runtime.getClassFromPath("OpenSSL::X509::Name").getConstant("DEFAULT_OBJECT_TYPE");
                }
                this.add_entry(context, entry0, entry1, entry2);
            }
        } else {
            try {
                byte[] bytes2 = OpenSSLImpl.to_der_if_possible(dn).convertToString().getBytes();
                ASN1InputStream asn1IS = new ASN1InputStream(bytes2);
                this.fromASN1Sequence((ASN1Sequence)asn1IS.readObject());
            }
            catch (Exception e) {
                throw X509Name.newX509NameError(runtime, e.getLocalizedMessage());
            }
        }
        return this;
    }

    private DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
        DERObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return val1;
        }
        DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
        return val2;
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context, IRubyObject oid2, IRubyObject value2) {
        return this.add_entry(context, oid2, value2, context.nil);
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context, IRubyObject _oid, IRubyObject _value, IRubyObject _type) {
        DERObjectIdentifier oid_v;
        Ruby runtime = context.runtime;
        String oid2 = _oid.convertToString().toString();
        String value2 = _value.convertToString().toString();
        IRubyObject type2 = !_type.isNil() ? _type : runtime.getClassFromPath("OpenSSL::X509::Name").getConstant("OBJECT_TYPE_TEMPLATE").callMethod(context, "[]", _oid);
        try {
            oid_v = this.getObjectIdentifier(oid2);
        }
        catch (IllegalArgumentException e) {
            throw X509Name.newX509NameError(this.getRuntime(), "invalid field name: " + e.getMessage());
        }
        if (null == oid_v) {
            throw X509Name.newX509NameError(this.getRuntime(), null);
        }
        this.oids.add(oid_v);
        this.values.add(value2);
        this.types.add(type2);
        return this;
    }

    @JRubyMethod(name={"to_s"}, rest=true)
    public IRubyObject _to_s(IRubyObject[] args2) {
        int flag = -1;
        if (args2.length > 0 && !args2[0].isNil()) {
            flag = RubyNumeric.fix2int(args2[0]);
        }
        StringBuffer sb = new StringBuffer();
        Map<DERObjectIdentifier, String> lookup = ASN1.getSymLookup(this.getRuntime());
        Iterator<Object> oiter = null;
        Iterator<Object> viter = null;
        if (flag == 17892119) {
            ArrayList<Object> ao = new ArrayList<Object>(this.oids);
            ArrayList<Object> av = new ArrayList<Object>(this.values);
            Collections.reverse(ao);
            Collections.reverse(av);
            oiter = ao.iterator();
            viter = av.iterator();
        } else {
            oiter = this.oids.iterator();
            viter = this.values.iterator();
        }
        String sep = "";
        while (oiter.hasNext()) {
            DERObjectIdentifier oid2 = (DERObjectIdentifier)oiter.next();
            String val = (String)viter.next();
            String outOid = lookup.get(oid2);
            if (null == outOid) {
                outOid = oid2.toString();
            }
            if (flag == 17892119) {
                sb.append(sep).append(outOid).append("=").append(val);
                sep = ",";
                continue;
            }
            sb.append("/").append(outOid).append("=").append(val);
        }
        return this.getRuntime().newString(sb.toString());
    }

    @JRubyMethod
    public RubyArray to_a() {
        ArrayList<IRubyObject> entries2 = new ArrayList<IRubyObject>();
        Map<DERObjectIdentifier, String> lookup = ASN1.getSymLookup(this.getRuntime());
        Iterator<Object> oiter = this.oids.iterator();
        Iterator<Object> viter = this.values.iterator();
        Iterator<Object> titer = this.types.iterator();
        while (oiter.hasNext()) {
            DERObjectIdentifier oid2 = (DERObjectIdentifier)oiter.next();
            String val = (String)viter.next();
            String outOid = lookup.get(oid2);
            if (null == outOid) {
                outOid = "UNDEF";
            }
            IRubyObject type2 = (IRubyObject)titer.next();
            entries2.add(this.getRuntime().newArrayNoCopy(this.getRuntime().newString(outOid), this.getRuntime().newString(val), type2));
        }
        return this.getRuntime().newArray(entries2);
    }

    @JRubyMethod(name={"cmp", "<=>"})
    public IRubyObject cmp(IRubyObject other) {
        if (this.eql_p(other).isTrue()) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.one(this.getRuntime());
    }

    org.jruby.org.bouncycastle.asn1.x509.X509Name getRealName() {
        return new org.jruby.org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(this.oids), new Vector<Object>(this.values));
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(IRubyObject other) {
        if (!(other instanceof X509Name)) {
            return this.getRuntime().getFalse();
        }
        X509Name o = (X509Name)other;
        org.jruby.org.bouncycastle.asn1.x509.X509Name nm = new org.jruby.org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(this.oids), new Vector<Object>(this.values));
        org.jruby.org.bouncycastle.asn1.x509.X509Name o_nm = new org.jruby.org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(o.oids), new Vector<Object>(o.values));
        return nm.equals(o_nm) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyFixnum hash() {
        Name name2 = new Name(new org.jruby.org.bouncycastle.asn1.x509.X509Name(new Vector<Object>(this.oids), new Vector<Object>(this.values)));
        return this.getRuntime().newFixnum(name2.hash());
    }

    @JRubyMethod
    public IRubyObject to_der() {
        DERSequence seq = null;
        if (this.oids.size() > 0) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            DERObjectIdentifier lstOid = null;
            for (int i2 = 0; i2 != this.oids.size(); ++i2) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObjectIdentifier oid2 = (DERObjectIdentifier)this.oids.get(i2);
                v.add(oid2);
                String str = (String)this.values.get(i2);
                v.add(this.convert(oid2, str, RubyNumeric.fix2int((RubyFixnum)this.types.get(i2))));
                if (lstOid == null) {
                    sVec.add(new DERSequence(v));
                } else {
                    vec.add(new DERSet(sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add(new DERSequence(v));
                }
                lstOid = oid2;
            }
            vec.add(new DERSet(sVec));
            seq = new DERSequence(vec);
        } else {
            seq = new DERSequence();
        }
        return RubyString.newString(this.getRuntime(), seq.getDEREncoded());
    }

    private DERObject convert(DERObjectIdentifier oid2, String value2, int type2) {
        try {
            Constructor<? extends ASN1Encodable> ctor;
            Class<? extends ASN1Encodable> clzz = ASN1.classForId(type2);
            if (clzz != null && null != (ctor = clzz.getConstructor(String.class))) {
                return (DERObject)ctor.newInstance(value2);
            }
            return new X509DefaultEntryConverter().getConvertedValue(oid2, value2);
        }
        catch (Exception e) {
            throw X509Name.newX509NameError(this.getRuntime(), e.getMessage());
        }
    }

    private static RaiseException newX509NameError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::X509::NameError", message2);
    }
}

