/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.security.auth.x500.X500Principal;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DEROutputStream;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.jruby.org.bouncycastle.asn1.x509.X509Name;
import org.jruby.org.bouncycastle.jce.PKCS10CertificationRequest;

public class PKCS10CertificationRequestExt
extends PKCS10CertificationRequest {
    public PKCS10CertificationRequestExt(byte[] bytes2) {
        super(bytes2);
    }

    public PKCS10CertificationRequestExt(ASN1Sequence sequence) {
        super(sequence);
    }

    public PKCS10CertificationRequestExt(String signatureAlgorithm, X509Name subject2, PublicKey key2, ASN1Set attributes2, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        super(signatureAlgorithm, subject2, key2, attributes2, signingKey);
    }

    public PKCS10CertificationRequestExt(String signatureAlgorithm, X500Principal subject2, PublicKey key2, ASN1Set attributes2, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        super(signatureAlgorithm, subject2, key2, attributes2, signingKey);
    }

    public PKCS10CertificationRequestExt(String signatureAlgorithm, X500Principal subject2, PublicKey key2, ASN1Set attributes2, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        super(signatureAlgorithm, subject2, key2, attributes2, signingKey, provider);
    }

    public PKCS10CertificationRequestExt(String signatureAlgorithm, X509Name subject2, PublicKey key2, ASN1Set attributes2, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        super(signatureAlgorithm, subject2, key2, attributes2, signingKey, provider);
    }

    public void setAttributes(DERSet attrs) {
        ASN1Sequence seq = (ASN1Sequence)this.reqInfo.toASN1Object();
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < seq.size() - 1; ++i2) {
            v1.add(seq.getObjectAt(i2));
        }
        v1.add(new DERTaggedObject(0, attrs));
        this.reqInfo = new CertificationRequestInfo(new DERSequence(v1));
    }

    public void setVersion(int v) {
        DERInteger nVersion = new DERInteger(v);
        ASN1Sequence seq = (ASN1Sequence)this.reqInfo.toASN1Object();
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add(nVersion);
        for (int i2 = 1; i2 < seq.size(); ++i2) {
            v1.add(seq.getObjectAt(i2));
        }
        this.reqInfo = new CertificationRequestInfo(new DERSequence(v1));
    }

    public int getVersion() {
        return this.getCertificationRequestInfo().getVersion().getValue().intValue();
    }

    public boolean verify(PublicKey pubkey) throws Exception {
        Signature sig = Signature.getInstance(this.sigAlgId.getObjectId().getId());
        sig.initVerify(pubkey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new SecurityException("exception encoding TBS cert request - " + e);
        }
        return sig.verify(this.sigBits.getBytes());
    }
}

