/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jffi.CachingNativeMemoryAllocator;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.JFFIInvoker;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.TransientNativeMemoryIO;
import org.jruby.ext.ffi.jffi.VariadicInvoker;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Factory
extends org.jruby.ext.ffi.Factory {
    public Factory() {
        if (!Platform.getPlatform().isSupported()) {
            throw new UnsatisfiedLinkError("JFFI backend not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime, RubyModule ffi2) {
        super.init(runtime, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.getClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime, ffi2);
            }
            if (ffi2.getClass("Invoker") == null) {
                JFFIInvoker.createInvokerClass(runtime, ffi2);
            }
            if (ffi2.getClass("VariadicInvoker") == null) {
                VariadicInvoker.createVariadicInvokerClass(runtime, ffi2);
            }
            if (ffi2.getClass("Callback") == null) {
                CallbackManager.createCallbackClass(runtime, ffi2);
            }
            if (ffi2.getClass("Function") == null) {
                Function.createFunctionClass(runtime, ffi2);
            }
            if (ffi2.getClass("LastError") == null) {
                ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(LastError.class);
            }
        }
        runtime.setFFI(new FFI(ffi2));
    }

    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime, int size2, boolean clear2) {
        return CachingNativeMemoryAllocator.allocateAligned(runtime, size2, 8, clear2);
    }

    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime, int size2, int align, boolean clear2) {
        return CachingNativeMemoryAllocator.allocateAligned(runtime, size2, align, clear2);
    }

    public DirectMemoryIO allocateTransientDirectMemory(Ruby runtime, int size2, int align, boolean clear2) {
        return TransientNativeMemoryIO.allocateAligned(runtime, size2, align, clear2);
    }

    public DirectMemoryIO wrapDirectMemory(Ruby runtime, long address2) {
        return NativeMemoryIO.wrap(runtime, address2);
    }

    public Function newFunction(Ruby runtime, Pointer address2, CallbackInfo cbInfo) {
        CodeMemoryIO mem = new CodeMemoryIO(runtime, address2);
        RubyClass klass = runtime.getModule("FFI").getClass("Function");
        return new Function(runtime, klass, mem, cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT, null, false);
    }

    public CallbackManager getCallbackManager() {
        return CallbackManager.getInstance();
    }

    private static final Type getType(NativeType type2) {
        Type jffiType = FFIUtil.getFFIType(type2);
        if (jffiType == null) {
            throw new UnsupportedOperationException("Cannot determine native type for " + (Object)((Object)type2));
        }
        return jffiType;
    }

    public int sizeOf(NativeType type2) {
        return Factory.getType(type2).size();
    }

    public int alignmentOf(NativeType type2) {
        return Factory.getType(type2).alignment();
    }

    public static final class LastError {
        @JRubyMethod(name={"error"}, module=true)
        public static final IRubyObject error(ThreadContext context, IRubyObject recv2) {
            return context.runtime.newFixnum(com.kenai.jffi.LastError.getInstance().get());
        }

        @JRubyMethod(name={"error="}, module=true)
        public static final IRubyObject error_set(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
            com.kenai.jffi.LastError.getInstance().set((int)value2.convertToInteger().getLongValue());
            return value2;
        }
    }
}

