/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import jnr.posix.LibC;
import org.jruby.Ruby;

public class FileDescriptorByteChannel
implements ByteChannel {
    private final LibC libc;
    private final int fd;
    private volatile boolean isOpen = true;

    private static LibC libc(Ruby runtime) {
        LibC libc = runtime.getPosix().libc();
        if (libc == null) {
            throw runtime.newNotImplementedError("native access not enabled");
        }
        return libc;
    }

    public FileDescriptorByteChannel(Ruby runtime, int fd) {
        this.fd = fd;
        this.libc = FileDescriptorByteChannel.libc(runtime);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Not open");
        }
        int n = this.libc.read(this.fd, dst, dst.remaining());
        if (n > 0) {
            dst.position(dst.position() + n);
        } else if (n == 0) {
            return -1;
        }
        return n;
    }

    public int write(ByteBuffer src) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Not open");
        }
        int n = this.libc.write(this.fd, src, src.remaining());
        if (n > 0) {
            src.position(src.position() + n);
        }
        return n;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            throw new IllegalStateException("file already closed");
        }
        this.isOpen = false;
        this.libc.close(this.fd);
    }
}

