/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowVar;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataFlowProblem {
    public final DF_Direction direction;
    protected List<FlowGraphNode> flowGraphNodes;
    protected IRScope scope;
    private int nextVariableId;
    private ArrayList<DataFlowVar> variables;
    private Map<Integer, FlowGraphNode> basicBlockToFlowGraph;

    public DataFlowProblem(DF_Direction d) {
        this.direction = d;
        this.variables = new ArrayList();
        this.nextVariableId = -1;
    }

    public abstract FlowGraphNode buildFlowGraphNode(BasicBlock var1);

    public abstract String getName();

    public boolean isEmpty() {
        return false;
    }

    public DF_Direction getFlowDirection() {
        return this.direction;
    }

    public void setup(IRScope scope) {
        this.scope = scope;
        this.buildFlowGraph();
    }

    public IRScope getScope() {
        return this.scope;
    }

    public void compute_MOP_Solution() {
        if (!this.isEmpty()) {
            LinkedList<FlowGraphNode> workList = this.getInitialWorkList();
            int numNodes = this.scope.cfg().getMaxNodeID();
            BitSet bbSet = new BitSet(1 + numNodes);
            bbSet.flip(0, numNodes);
            while (!workList.isEmpty()) {
                workList.removeFirst().computeDataFlowInfo(workList, bbSet);
            }
        }
    }

    private LinkedList<FlowGraphNode> getInitialWorkList() {
        LinkedList<FlowGraphNode> wl = new LinkedList<FlowGraphNode>();
        if (this.direction == DF_Direction.FORWARD) {
            ListIterator<BasicBlock> it = this.scope.cfg().getReversePostOrderTraverser();
            while (it.hasPrevious()) {
                wl.add(this.getFlowGraphNode(it.previous()));
            }
        } else {
            ListIterator<BasicBlock> it = this.scope.cfg().getPostOrderTraverser();
            while (it.hasNext()) {
                wl.add(this.getFlowGraphNode(it.next()));
            }
        }
        return wl;
    }

    public int getDFVarsCount() {
        return this.variables.size();
    }

    public Iterable<BasicBlock> getIncomingSourcesOf(BasicBlock bb) {
        return this.scope.cfg().getIncomingSources(bb);
    }

    public Iterable<BasicBlock> getOutgoingDestinationsOf(BasicBlock bb) {
        return this.scope.cfg().getOutgoingDestinations(bb);
    }

    public String getDataFlowVarsForOutput() {
        return "";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("----").append(this.getName()).append("----\n");
        buf.append("---- Data Flow Vars: ----\n");
        buf.append(this.getDataFlowVarsForOutput());
        buf.append("-------------------------\n");
        for (FlowGraphNode n : this.flowGraphNodes) {
            buf.append("DF State for BB ").append(n.basicBlock.getID()).append(":\n").append(n.toString());
        }
        return buf.toString();
    }

    int addDataFlowVar(DataFlowVar v) {
        ++this.nextVariableId;
        this.variables.add(this.nextVariableId, v);
        return this.nextVariableId;
    }

    protected FlowGraphNode getFlowGraphNode(BasicBlock b) {
        return this.basicBlockToFlowGraph.get(b.getID());
    }

    private void buildFlowGraph() {
        this.flowGraphNodes = new LinkedList<FlowGraphNode>();
        this.basicBlockToFlowGraph = new HashMap<Integer, FlowGraphNode>();
        for (BasicBlock bb : this.scope.cfg().getBasicBlocks()) {
            FlowGraphNode fgNode = this.buildFlowGraphNode(bb);
            fgNode.init();
            fgNode.buildDataFlowVars();
            this.flowGraphNodes.add(fgNode);
            this.basicBlockToFlowGraph.put(bb.getID(), fgNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DF_Direction {
        FORWARD,
        BACKWARD,
        BIDIRECTIONAL;

    }
}

