/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Closure;
import com.kenai.jffi.Function;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.jffi.CallbackMemoryIO;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;

@JRubyClass(name={"FFI::Callback"}, parent="FFI::Pointer")
class NativeCallbackPointer
extends AbstractInvoker {
    final CallbackInfo cbInfo;
    final NativeFunctionInfo closureInfo;

    NativeCallbackPointer(Ruby runtime, RubyClass klass, Closure.Handle handle, CallbackInfo cbInfo, NativeFunctionInfo closureInfo) {
        super(runtime, klass, cbInfo.getParameterTypes().length, new CallbackMemoryIO(runtime, handle));
        this.cbInfo = cbInfo;
        this.closureInfo = closureInfo;
    }

    void dispose() {
        MemoryIO mem = this.getMemoryIO();
        if (mem instanceof CallbackMemoryIO) {
            ((CallbackMemoryIO)mem).free();
        }
    }

    public DynamicMethod createDynamicMethod(RubyModule module) {
        Function function = new Function(((DirectMemoryIO)this.getMemoryIO()).getAddress(), this.closureInfo.jffiReturnType, this.closureInfo.jffiParameterTypes);
        return MethodFactory.createDynamicMethod(this.getRuntime(), module, function, this.closureInfo.returnType, this.closureInfo.parameterTypes, this.closureInfo.convention, this.getRuntime().getNil(), false);
    }
}

