/*
 * Decompiled with CFR 0.152.
 */
package jnr.enxio.example;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.util.Iterator;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.Sock;
import jnr.enxio.channels.NativeSelectableChannel;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.enxio.channels.NativeServerSocketChannel;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.ffi.LastError;
import jnr.ffi.Library;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;

public class TCPServer {
    static final String[] libnames;
    static final LibC libc;
    static final Runtime runtime;

    static short htons(short val) {
        return Short.reverseBytes(val);
    }

    static NativeServerSocketChannel serverSocket(int port) {
        SockAddr addr2;
        int fd = libc.socket(LibC.AF_INET, LibC.SOCK_STREAM, 0);
        System.out.println("fd=" + fd);
        if (Platform.getNativePlatform().isBSD()) {
            BSDSockAddrIN sin2 = new BSDSockAddrIN();
            sin2.sin_family.set((byte)LibC.AF_INET);
            sin2.sin_port.set(TCPServer.htons((short)port));
            addr2 = sin2;
        } else {
            SockAddrIN sin3 = new SockAddrIN();
            sin3.sin_family.set(TCPServer.htons((short)LibC.AF_INET));
            sin3.sin_port.set(TCPServer.htons((short)port));
            addr2 = sin3;
        }
        System.out.println("sizeof addr=" + Struct.size(addr2));
        if (libc.bind(fd, addr2, Struct.size(addr2)) < 0) {
            System.err.println("bind failed: " + libc.strerror(LastError.getLastError(runtime)));
            System.exit(1);
        }
        if (libc.listen(fd, 5) < 0) {
            System.err.println("listen failed: " + libc.strerror(LastError.getLastError(runtime)));
            System.exit(1);
        }
        System.out.println("bind+listen succeeded");
        return new NativeServerSocketChannel(fd);
    }

    public static void main(String[] args2) {
        int baseport = 2000;
        try {
            AbstractSelector selector = NativeSelectorProvider.getInstance().openSelector();
            for (int i2 = 0; i2 < 2; ++i2) {
                NativeServerSocketChannel ch = TCPServer.serverSocket(baseport + i2);
                ch.configureBlocking(false);
                ch.register(selector, 16, new Accepter((Selector)selector, ch));
            }
            block3: while (true) {
                selector.select();
                Iterator<SelectionKey> i$ = selector.selectedKeys().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block3;
                    SelectionKey k = i$.next();
                    if ((k.readyOps() & 0x11) != 0) {
                        ((IO)k.attachment()).read();
                    }
                    if ((k.readyOps() & 0xC) == 0) continue;
                    ((IO)k.attachment()).write();
                }
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    static {
        String[] stringArray;
        if (Platform.getNativePlatform().getOS() == Platform.OS.SOLARIS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "socket";
            stringArray2[1] = "nsl";
            stringArray = stringArray2;
            stringArray2[2] = "c";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "c";
        }
        libnames = stringArray;
        libc = Library.loadLibrary(LibC.class, libnames);
        runtime = Runtime.getSystemRuntime();
    }

    private static class Client
    extends IO {
        private final ByteBuffer buf = ByteBuffer.allocateDirect(1024);

        public Client(Selector selector, NativeSocketChannel ch) {
            super(selector, ch);
        }

        public void read() {
            int n = libc.read(((NativeSelectableChannel)((Object)this.channel)).getFD(), this.buf, this.buf.remaining());
            System.out.println("Read " + n + " bytes from client");
            if (n <= 0) {
                SelectionKey k = this.channel.keyFor(this.selector);
                k.cancel();
                libc.close(((NativeSelectableChannel)((Object)this.channel)).getFD());
                return;
            }
            this.buf.position(n);
            this.buf.flip();
            this.channel.keyFor(this.selector).interestOps(4);
        }

        public void write() {
            while (this.buf.hasRemaining()) {
                int n = libc.write(((NativeSelectableChannel)((Object)this.channel)).getFD(), this.buf, this.buf.remaining());
                System.out.println("write returned " + n);
                if (n > 0) {
                    this.buf.position(this.buf.position() + n);
                }
                if (n == 0) {
                    return;
                }
                if (n >= 0) continue;
                this.channel.keyFor(this.selector).cancel();
                libc.close(((NativeSelectableChannel)((Object)this.channel)).getFD());
                return;
            }
            System.out.println("outbuf empty");
            this.buf.clear();
            this.channel.keyFor(this.selector).interestOps(1);
        }
    }

    private static class Accepter
    extends IO {
        public Accepter(Selector selector, NativeServerSocketChannel ch) {
            super(selector, ch);
        }

        public void read() {
            SockAddrIN sin2 = new SockAddrIN();
            int[] addrSize = new int[]{Struct.size(sin2)};
            int clientfd = libc.accept(((NativeSelectableChannel)((Object)this.channel)).getFD(), sin2, addrSize);
            System.out.println("client fd = " + clientfd);
            NativeSocketChannel ch = new NativeSocketChannel(clientfd);
            try {
                ch.configureBlocking(false);
                ch.register(this.selector, 1, new Client(this.selector, ch));
                this.selector.wakeup();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }

        public void write() {
            SelectionKey k = this.channel.keyFor(this.selector);
            k.interestOps(16);
        }
    }

    private static abstract class IO {
        protected final SelectableChannel channel;
        protected final Selector selector;

        public IO(Selector selector, SelectableChannel ch) {
            this.selector = selector;
            this.channel = ch;
        }

        public abstract void read();

        public abstract void write();
    }

    public static interface LibC {
        public static final int AF_INET = AddressFamily.AF_INET.intValue();
        public static final int SOCK_STREAM = Sock.SOCK_STREAM.intValue();

        public int socket(int var1, int var2, int var3);

        public int close(int var1);

        public int listen(int var1, int var2);

        public int bind(int var1, SockAddr var2, int var3);

        public int accept(int var1, @Out SockAddr var2, int[] var3);

        public int read(int var1, @Out ByteBuffer var2, int var3);

        public int read(int var1, @Out byte[] var2, int var3);

        public int write(int var1, @In ByteBuffer var2, int var3);

        public String strerror(int var1);
    }

    static class SockAddrIN
    extends SockAddr {
        public final Struct.Unsigned16 sin_family = new Struct.Unsigned16(this);
        public final Struct.Unsigned16 sin_port = new Struct.Unsigned16(this);
        public final Struct.Unsigned32 sin_addr = new Struct.Unsigned32(this);
        public final Struct.Signed8[] sin_zero = this.array(new Struct.Signed8[8]);

        SockAddrIN() {
        }
    }

    static class BSDSockAddrIN
    extends SockAddr {
        public final Struct.Unsigned8 sin_len = new Struct.Unsigned8(this);
        public final Struct.Unsigned8 sin_family = new Struct.Unsigned8(this);
        public final Struct.Unsigned16 sin_port = new Struct.Unsigned16(this);
        public final Struct.Unsigned32 sin_addr = new Struct.Unsigned32(this);
        public final Struct.Signed8[] sin_zero = this.array(new Struct.Signed8[8]);

        BSDSockAddrIN() {
        }
    }

    public static class SockAddr
    extends Struct {
        public SockAddr() {
            super(runtime);
        }
    }
}

