/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyKernel;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowExceptionInstr
extends Instr {
    private Operand exceptionArg;

    public ThrowExceptionInstr(Operand exception2) {
        super(Operation.THROW);
        this.exceptionArg = exception2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.exceptionArg};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.exceptionArg = this.exceptionArg.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.exceptionArg + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new ThrowExceptionInstr(this.exceptionArg.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        if (this.exceptionArg instanceof IRException) {
            throw ((IRException)this.exceptionArg).getException(context.getRuntime());
        }
        Object excObj = this.exceptionArg.retrieve(context, self, currDynScope, temp);
        if (excObj instanceof IRubyObject) {
            RubyKernel.raise(context, context.getRuntime().getKernel(), new IRubyObject[]{(IRubyObject)excObj}, Block.NULL_BLOCK);
        } else if (excObj instanceof Throwable) {
            UnsafeFactory.getUnsafe().throwException((Throwable)excObj);
        }
        throw new RuntimeException("Control shouldn't have reached here in ThrowExceptionInstr.  excObj is: " + excObj);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ThrowExceptionInstr(this);
    }
}

