/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class CheckArityInstr
extends Instr {
    public final int required;
    public final int opt;
    public final int rest;

    public CheckArityInstr(int required, int opt, int rest2) {
        super(Operation.CHECK_ARITY);
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
    }

    public Operand[] getOperands() {
        return EMPTY_OPERANDS;
    }

    public String toString() {
        return super.toString() + "(" + this.required + ", " + this.opt + ", " + this.rest + ")";
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (ii.canMapArgsStatically()) {
            int numArgs = ii.getArgsCount();
            if (numArgs < this.required || this.rest == -1 && numArgs > this.required + this.opt) {
                return new RaiseArgumentErrorInstr(this.required, this.opt, this.rest, this.rest);
            }
            return null;
        }
        return new CheckArgsArrayArityInstr(ii.getArgs(), this.required, this.opt, this.rest);
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new CheckArityInstr(this.required, this.opt, this.rest);
    }

    public void visit(IRVisitor visitor) {
        visitor.CheckArityInstr(this);
    }
}

