/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.hidden.jline.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.hidden.jline.internal.Configuration;
import org.jruby.hidden.jline.internal.Log;
import org.jruby.hidden.jline.internal.Preconditions;

public final class TerminalLineSettings {
    public static final String JLINE_STTY = "org.jruby.hidden.jline.stty";
    public static final String DEFAULT_STTY = "stty";
    public static final String JLINE_SH = "org.jruby.hidden.jline.sh";
    public static final String DEFAULT_SH = "sh";
    private String sttyCommand = Configuration.getString("org.jruby.hidden.jline.stty", "stty");
    private String shCommand = Configuration.getString("org.jruby.hidden.jline.sh", "sh");
    private String config = this.get("-a");
    private long configLastFetched = System.currentTimeMillis();

    public TerminalLineSettings() throws IOException, InterruptedException {
        Log.debug("Config: ", this.config);
        if (this.config.length() == 0) {
            throw new IOException(MessageFormat.format("Unrecognized stty code: {0}", this.config));
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void restore() throws IOException, InterruptedException {
        this.set("sane");
    }

    public String get(String args2) throws IOException, InterruptedException {
        return this.stty(args2);
    }

    public void set(String args2) throws IOException, InterruptedException {
        this.stty(args2);
    }

    public int getProperty(String name2) {
        Preconditions.checkNotNull(name2);
        try {
            if (this.config == null || System.currentTimeMillis() - this.configLastFetched > 1000L) {
                this.config = this.get("-a");
                this.configLastFetched = System.currentTimeMillis();
            }
            return TerminalLineSettings.getProperty(name2, this.config);
        }
        catch (Exception e) {
            Log.warn("Failed to query stty ", name2, e);
            return -1;
        }
    }

    protected static int getProperty(String name2, String stty) {
        Pattern pattern = Pattern.compile(name2 + "\\s+=\\s+([^;]*)[;\\n\\r]");
        Matcher matcher = pattern.matcher(stty);
        if (!(matcher.find() || (matcher = (pattern = Pattern.compile(name2 + "\\s+([^;]*)[;\\n\\r]")).matcher(stty)).find() || (matcher = (pattern = Pattern.compile("(\\S*)\\s+" + name2)).matcher(stty)).find())) {
            return -1;
        }
        return TerminalLineSettings.parseControlChar(matcher.group(1));
    }

    private static int parseControlChar(String str) {
        if ("<undef>".equals(str)) {
            return -1;
        }
        if (str.charAt(0) == '0') {
            return Integer.parseInt(str, 8);
        }
        if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            return Integer.parseInt(str, 10);
        }
        if (str.charAt(0) == '^') {
            if (str.charAt(1) == '?') {
                return 127;
            }
            return str.charAt(1) - 64;
        }
        if (str.charAt(0) == 'M' && str.charAt(1) == '-') {
            if (str.charAt(2) == '^') {
                if (str.charAt(3) == '?') {
                    return 255;
                }
                return str.charAt(3) - 64 + 128;
            }
            return str.charAt(2) + 128;
        }
        return str.charAt(0);
    }

    private String stty(String args2) throws IOException, InterruptedException {
        Preconditions.checkNotNull(args2);
        return this.exec(String.format("%s %s < /dev/tty", this.sttyCommand, args2));
    }

    private String exec(String cmd) throws IOException, InterruptedException {
        Preconditions.checkNotNull(cmd);
        return this.exec(this.shCommand, "-c", cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exec(String ... cmd) throws IOException, InterruptedException {
        Preconditions.checkNotNull(cmd);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Log.trace("Running: ", cmd);
        Process p2 = Runtime.getRuntime().exec(cmd);
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p2.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p2.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p2.getOutputStream();
            p2.waitFor();
        }
        catch (Throwable throwable) {
            TerminalLineSettings.close(in, out, err);
            throw throwable;
        }
        TerminalLineSettings.close(in, out, err);
        String result2 = bout.toString();
        Log.trace("Result: ", result2);
        return result2;
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

