/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.hidden.jline.internal;

import java.io.PrintStream;
import jline.internal.TestAccessible;
import org.jruby.hidden.jline.internal.Preconditions;

public final class Log {
    public static final boolean TRACE = Boolean.getBoolean(Log.class.getName() + ".trace");
    public static final boolean DEBUG = TRACE || Boolean.getBoolean(Log.class.getName() + ".debug");
    private static PrintStream output = System.err;

    public static PrintStream getOutput() {
        return output;
    }

    public static void setOutput(PrintStream out) {
        output = Preconditions.checkNotNull(out);
    }

    @TestAccessible
    static void render(PrintStream out, Object message2) {
        if (message2.getClass().isArray()) {
            Object[] array = (Object[])message2;
            out.print("[");
            for (int i2 = 0; i2 < array.length; ++i2) {
                out.print(array[i2]);
                if (i2 + 1 >= array.length) continue;
                out.print(",");
            }
            out.print("]");
        } else {
            out.print(message2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestAccessible
    static void log(Level level2, Object ... messages) {
        PrintStream printStream = output;
        synchronized (printStream) {
            output.format("[%s] ", new Object[]{level2});
            for (int i2 = 0; i2 < messages.length; ++i2) {
                if (i2 + 1 == messages.length && messages[i2] instanceof Throwable) {
                    output.println();
                    ((Throwable)messages[i2]).printStackTrace(output);
                    continue;
                }
                Log.render(output, messages[i2]);
            }
            output.println();
            output.flush();
        }
    }

    public static void trace(Object ... messages) {
        if (TRACE) {
            Log.log(Level.TRACE, messages);
        }
    }

    public static void debug(Object ... messages) {
        if (TRACE || DEBUG) {
            Log.log(Level.DEBUG, messages);
        }
    }

    public static void info(Object ... messages) {
        Log.log(Level.INFO, messages);
    }

    public static void warn(Object ... messages) {
        Log.log(Level.WARN, messages);
    }

    public static void error(Object ... messages) {
        Log.log(Level.ERROR, messages);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

