/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import java.util.HashSet;
import java.util.Set;
import org.joni.WarnCallback;
import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyWarnings
implements IRubyWarnings,
WarnCallback {
    private final Ruby runtime;
    private final Set<IRubyWarnings.ID> oncelers = new HashSet<IRubyWarnings.ID>();

    public RubyWarnings(Ruby runtime) {
        this.runtime = runtime;
    }

    public void warn(String message2) {
        this.warn(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public boolean isVerbose() {
        return this.runtime.isVerbose();
    }

    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2) {
        this.warn(id2, position.getFile(), position.getStartLine(), message2);
    }

    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(':').append(lineNumber + 1).append(' ');
        buffer.append("warning: ").append(message2).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    public void warn(IRubyWarnings.ID id2, String message2) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warn(id2, context.getFile(), context.getLine(), message2);
    }

    public void warnOnce(IRubyWarnings.ID id2, String message2) {
        if (this.oncelers.contains((Object)id2)) {
            return;
        }
        this.oncelers.add(id2);
        this.warn(id2, message2);
    }

    public void warning(String message2) {
        this.warning(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    public void warning(IRubyWarnings.ID id2, String message2) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warning(id2, context.getFile(), context.getLine(), message2);
    }

    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2) {
        this.warning(id2, position.getFile(), position.getStartLine(), message2);
    }

    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        assert (this.isVerbose());
        this.warn(id2, fileName, lineNumber, message2);
    }

    @Deprecated
    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data2) {
        this.warn(id2, position.getFile(), position.getStartLine(), message2, data2);
    }

    @Deprecated
    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2, Object ... data2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(':').append(lineNumber + 1).append(' ');
        buffer.append("warning: ").append(message2).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    @Deprecated
    public void warn(IRubyWarnings.ID id2, String message2, Object ... data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warn(id2, context.getFile(), context.getLine(), message2, data2);
    }

    @Deprecated
    public void warning(String message2, Object ... data2) {
        this.warning(IRubyWarnings.ID.MISCELLANEOUS, message2, data2);
    }

    @Deprecated
    public void warning(IRubyWarnings.ID id2, String message2, Object ... data2) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warning(id2, context.getFile(), context.getLine(), message2, data2);
    }

    @Deprecated
    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data2) {
        this.warning(id2, position.getFile(), position.getStartLine(), message2, data2);
    }

    @Deprecated
    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2, Object ... data2) {
        assert (this.isVerbose());
        this.warn(id2, fileName, lineNumber, message2, data2);
    }
}

