/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBinder
implements AnnotationProcessorFactory {
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    private static final Logger LOG = LoggerFactory.getLogger("AnnotationBinder");
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("org.jruby.anno.JRubyMethod", "org.jruby.anno.JRubyClass"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new AnnotationBindingProcessor(env);
    }

    private static class AnnotationBindingProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;
        private final List<String> classNames = new ArrayList<String>();

        AnnotationBindingProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
                typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new RubyClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }
            try {
                FileWriter fw = new FileWriter("src_gen/annotated_classes.txt");
                for (String name2 : this.classNames) {
                    fw.write(name2);
                    fw.write(10);
                }
                fw.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static int getArityValue(JRubyMethod anno, int actualRequired) {
            if (anno.optional() > 0 || anno.rest()) {
                return -(actualRequired + 1);
            }
            return actualRequired;
        }

        public static String getCallConfigNameByAnno(JRubyMethod anno) {
            return AnnotationBindingProcessor.getCallConfigName(anno.frame(), anno.scope());
        }

        public static String getCallConfigName(boolean frame, boolean scope) {
            if (frame) {
                if (scope) {
                    return "FrameFullScopeFull";
                }
                return "FrameFullScopeNone";
            }
            if (scope) {
                return "FrameNoneScopeFull";
            }
            return "FrameNoneScopeNone";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RubyClassVisitor
        extends SimpleDeclarationVisitor {
            private PrintStream out;
            private static final boolean DEBUG = false;

            private RubyClassVisitor() {
            }

            public void visitClassDeclaration(ClassDeclaration cd) {
                try {
                    MethodDeclaration decl;
                    String qualifiedName = cd.getQualifiedName().replace('.', '$');
                    if (!qualifiedName.contains("org$jruby")) {
                        return;
                    }
                    ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(1024);
                    this.out = new PrintStream(bytes2);
                    this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
                    this.out.println("package org.jruby.gen;");
                    this.out.println("import org.jruby.Ruby;");
                    this.out.println("import org.jruby.RubyModule;");
                    this.out.println("import org.jruby.RubyClass;");
                    this.out.println("import org.jruby.CompatVersion;");
                    this.out.println("import org.jruby.anno.TypePopulator;");
                    this.out.println("import org.jruby.internal.runtime.methods.CallConfiguration;");
                    this.out.println("import org.jruby.internal.runtime.methods.JavaMethod;");
                    this.out.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
                    this.out.println("import org.jruby.runtime.Arity;");
                    this.out.println("import org.jruby.runtime.Visibility;");
                    this.out.println("import org.jruby.compiler.ASTInspector;");
                    this.out.println("import java.util.Arrays;");
                    this.out.println("import java.util.List;");
                    this.out.println("public class " + qualifiedName + AnnotationBinder.POPULATOR_SUFFIX + " extends TypePopulator {");
                    this.out.println("    public void populate(RubyModule cls, Class clazz) {");
                    boolean hasMeta = false;
                    boolean hasModule = false;
                    boolean hasCompat = false;
                    for (MethodDeclaration md : cd.getMethods()) {
                        JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                        if (anno == null) continue;
                        hasMeta |= anno.meta();
                        hasModule |= anno.module();
                        hasCompat |= anno.compat() != CompatVersion.BOTH;
                    }
                    this.out.println("        JavaMethod javaMethod;");
                    this.out.println("        DynamicMethod moduleMethod;");
                    if (hasMeta || hasModule) {
                        this.out.println("        RubyClass singletonClass = cls.getSingletonClass();");
                    }
                    if (hasCompat) {
                        this.out.println("        CompatVersion compatVersion = cls.getRuntime().getInstanceConfig().getCompatVersion();");
                    }
                    this.out.println("        Ruby runtime = cls.getRuntime();");
                    HashMap<String, List<MethodDeclaration>> annotatedMethods = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods1_8 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods1_8 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods1_9 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods1_9 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods2_0 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods2_0 = new HashMap<String, List<MethodDeclaration>>();
                    HashSet<String> frameAwareMethods = new HashSet<String>();
                    HashSet<String> scopeAwareMethods = new HashSet<String>();
                    int methodCount = 0;
                    for (MethodDeclaration methodDeclaration : cd.getMethods()) {
                        JRubyMethod anno = (JRubyMethod)methodDeclaration.getAnnotation(JRubyMethod.class);
                        if (anno == null) continue;
                        ++methodCount;
                        if (methodDeclaration.getThrownTypes().size() != 0) {
                            System.err.print("Method " + cd.toString() + "." + methodDeclaration.toString() + " should not throw exceptions: ");
                            boolean comma = false;
                            for (ReferenceType thrownType : methodDeclaration.getThrownTypes()) {
                                if (comma) {
                                    System.err.print(", ");
                                }
                                System.err.print(thrownType);
                                comma = true;
                            }
                            System.err.print("\n");
                        }
                        String name2 = anno.name().length == 0 ? methodDeclaration.getSimpleName() : anno.name()[0];
                        HashMap<String, List<Object>> methodsHash = null;
                        methodsHash = methodDeclaration.getModifiers().contains(Modifier.STATIC) ? (anno.compat() == CompatVersion.RUBY1_8 ? staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? staticAnnotatedMethods1_9 : (anno.compat() == CompatVersion.RUBY2_0 ? staticAnnotatedMethods2_0 : staticAnnotatedMethods))) : (anno.compat() == CompatVersion.RUBY1_8 ? annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? annotatedMethods1_9 : (anno.compat() == CompatVersion.RUBY2_0 ? annotatedMethods2_0 : annotatedMethods)));
                        ArrayList<MethodDeclaration> methodDescs = (ArrayList<MethodDeclaration>)methodsHash.get(name2);
                        if (methodDescs == null) {
                            methodDescs = new ArrayList<MethodDeclaration>();
                            methodsHash.put(name2, methodDescs);
                        }
                        methodDescs.add(methodDeclaration);
                        boolean frame = false;
                        boolean scope = false;
                        if (anno.frame()) {
                            frame = true;
                        }
                        if (anno.reads() != null) {
                            block11: for (FrameField read2 : anno.reads()) {
                                switch (read2) {
                                    case BACKREF: 
                                    case LASTLINE: {
                                        scope = true;
                                        continue block11;
                                    }
                                    default: {
                                        frame = true;
                                    }
                                }
                            }
                        }
                        if (anno.writes() != null) {
                            block12: for (FrameField write2 : anno.writes()) {
                                switch (write2) {
                                    case BACKREF: 
                                    case LASTLINE: {
                                        scope = true;
                                        continue block12;
                                    }
                                    default: {
                                        frame = true;
                                    }
                                }
                            }
                        }
                        if (frame) {
                            frameAwareMethods.addAll(Arrays.asList(anno.name()));
                        }
                        if (!scope) continue;
                        scopeAwareMethods.addAll(Arrays.asList(anno.name()));
                    }
                    if (methodCount == 0) {
                        return;
                    }
                    AnnotationBindingProcessor.this.classNames.add(this.getActualQualifiedName((TypeDeclaration)cd));
                    this.processMethodDeclarations(staticAnnotatedMethods);
                    for (Map.Entry entry : staticAnnotatedMethods.entrySet()) {
                        decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                        if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                        this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                    }
                    if (!staticAnnotatedMethods1_8.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(staticAnnotatedMethods1_8);
                        for (Map.Entry entry : staticAnnotatedMethods1_8.entrySet()) {
                            decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                            if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                            this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                        }
                        this.out.println("        }");
                    }
                    if (!staticAnnotatedMethods1_9.isEmpty()) {
                        this.out.println("        if (compatVersion.is1_9() || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(staticAnnotatedMethods1_9);
                        for (Map.Entry entry : staticAnnotatedMethods1_9.entrySet()) {
                            decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                            if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                            this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                        }
                        this.out.println("        }");
                    }
                    if (!staticAnnotatedMethods2_0.isEmpty()) {
                        this.out.println("        if (compatVersion.is2_0() || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(staticAnnotatedMethods2_0);
                        for (Map.Entry entry : staticAnnotatedMethods2_0.entrySet()) {
                            decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                            if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                            this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                        }
                        this.out.println("        }");
                    }
                    this.processMethodDeclarations(annotatedMethods);
                    for (Map.Entry entry : annotatedMethods.entrySet()) {
                        decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                        if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                        this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                    }
                    if (!annotatedMethods1_8.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(annotatedMethods1_8);
                        for (Map.Entry entry : annotatedMethods1_8.entrySet()) {
                            decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                            if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                            this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                        }
                        this.out.println("        }");
                    }
                    if (!annotatedMethods1_9.isEmpty()) {
                        this.out.println("        if (compatVersion.is1_9() || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(annotatedMethods1_9);
                        for (Map.Entry entry : annotatedMethods1_9.entrySet()) {
                            decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                            if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                            this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                        }
                        this.out.println("        }");
                    }
                    if (!annotatedMethods2_0.isEmpty()) {
                        this.out.println("        if (compatVersion.is2_0() || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(annotatedMethods2_0);
                        for (Map.Entry entry : annotatedMethods2_0.entrySet()) {
                            decl = (MethodDeclaration)((List)entry.getValue()).get(0);
                            if (((JRubyMethod)decl.getAnnotation(JRubyMethod.class)).omit()) continue;
                            this.addCoreMethodMapping((String)entry.getKey(), decl, this.out);
                        }
                        this.out.println("        }");
                    }
                    this.out.println("    }");
                    this.out.println("    static {");
                    if (!frameAwareMethods.isEmpty()) {
                        StringBuffer frameMethodsString = new StringBuffer();
                        boolean bl = true;
                        for (String name2 : frameAwareMethods) {
                            boolean bl2;
                            if (!bl2) {
                                frameMethodsString.append(',');
                            }
                            bl2 = false;
                            frameMethodsString.append('\"').append(name2).append('\"');
                        }
                        this.out.println("        ASTInspector.addFrameAwareMethods(" + frameMethodsString + ");");
                    }
                    if (!scopeAwareMethods.isEmpty()) {
                        StringBuffer scopeMethodsString = new StringBuffer();
                        boolean bl = true;
                        for (String name2 : scopeAwareMethods) {
                            boolean bl3;
                            if (!bl3) {
                                scopeMethodsString.append(',');
                            }
                            bl3 = false;
                            scopeMethodsString.append('\"').append(name2).append('\"');
                        }
                        this.out.println("        ASTInspector.addScopeAwareMethods(" + scopeMethodsString + ");");
                    }
                    this.out.println("     }");
                    this.out.println("}");
                    this.out.close();
                    this.out = null;
                    FileOutputStream fos = new FileOutputStream("src_gen/" + qualifiedName + AnnotationBinder.POPULATOR_SUFFIX + ".java");
                    fos.write(bytes2.toByteArray());
                    fos.close();
                }
                catch (IOException ioe) {
                    LOG.error("FAILED TO GENERATE:", ioe);
                    System.exit(1);
                }
            }

            public void processMethodDeclarations(Map<String, List<MethodDeclaration>> declarations) {
                for (Map.Entry<String, List<MethodDeclaration>> entry : declarations.entrySet()) {
                    List<MethodDeclaration> list2 = entry.getValue();
                    if (list2.size() == 1) {
                        this.processMethodDeclaration(list2.get(0));
                        continue;
                    }
                    this.processMethodDeclarationMulti(list2.get(0));
                }
            }

            public void processMethodDeclaration(MethodDeclaration md) {
                JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                if (anno != null && this.out != null) {
                    boolean isStatic = md.getModifiers().contains(Modifier.STATIC);
                    String qualifiedName = this.getActualQualifiedName(md.getDeclaringType());
                    boolean hasContext = false;
                    boolean hasBlock = false;
                    StringBuffer buffer = new StringBuffer();
                    boolean first2 = true;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        if (!first2) {
                            buffer.append(", ");
                        }
                        first2 = false;
                        buffer.append(pd.getType().toString());
                        buffer.append(".class");
                        hasContext |= pd.getType().toString().equals("org.jruby.runtime.ThreadContext");
                        hasBlock |= pd.getType().toString().equals("org.jruby.runtime.Block");
                    }
                    int actualRequired = this.calculateActualRequired(md, md.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
                    String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(md.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), false, anno.frame());
                    String implClass = anno.meta() ? "singletonClass" : "cls";
                    this.out.println("        javaMethod = new " + annotatedBindingName + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
                    this.out.println("        populateMethod(javaMethod, " + AnnotationBindingProcessor.getArityValue(anno, actualRequired) + ", \"" + md.getSimpleName() + "\", " + isStatic + ", " + "CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(anno) + ", " + anno.notImplemented() + ", " + md.getDeclaringType().getQualifiedName() + ".class, " + "\"" + md.getSimpleName() + "\", " + md.getReturnType().toString() + ".class, " + "new Class[] {" + buffer.toString() + "});");
                    this.generateMethodAddCalls(md, anno);
                }
            }

            public void processMethodDeclarationMulti(MethodDeclaration md) {
                JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                if (anno != null && this.out != null) {
                    boolean isStatic = md.getModifiers().contains(Modifier.STATIC);
                    String qualifiedName = this.getActualQualifiedName(md.getDeclaringType());
                    boolean hasContext = false;
                    boolean hasBlock = false;
                    StringBuffer buffer = new StringBuffer();
                    boolean first2 = true;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        if (!first2) {
                            buffer.append(", ");
                        }
                        first2 = false;
                        buffer.append(pd.getType().toString());
                        buffer.append(".class");
                        hasContext |= pd.getType().toString().equals("org.jruby.runtime.ThreadContext");
                        hasBlock |= pd.getType().toString().equals("org.jruby.runtime.Block");
                    }
                    int actualRequired = this.calculateActualRequired(md, md.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
                    String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(md.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), true, anno.frame());
                    String implClass = anno.meta() ? "singletonClass" : "cls";
                    this.out.println("        javaMethod = new " + annotatedBindingName + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
                    this.out.println("        populateMethod(javaMethod, -1, \"" + md.getSimpleName() + "\", " + isStatic + ", " + "CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(anno) + ", " + anno.notImplemented() + ", " + md.getDeclaringType().getQualifiedName() + ".class, " + "\"" + md.getSimpleName() + "\", " + md.getReturnType().toString() + ".class, " + "new Class[] {" + buffer.toString() + "});");
                    this.generateMethodAddCalls(md, anno);
                }
            }

            private void addCoreMethodMapping(String rubyName, MethodDeclaration decl, PrintStream out) {
                out.println(new StringBuilder(50).append("        runtime.addBoundMethod(").append('\"').append(decl.getDeclaringType().getQualifiedName()).append('\"').append(',').append('\"').append(decl.getSimpleName()).append('\"').append(',').append('\"').append(rubyName).append('\"').append(");").toString());
            }

            private String getActualQualifiedName(TypeDeclaration td) {
                String qualifiedName = td.getDeclaringType() != null ? (td.getDeclaringType().getDeclaringType() != null ? td.getDeclaringType().getDeclaringType().getQualifiedName() + "$" + td.getDeclaringType().getSimpleName() + "$" + td.getSimpleName() : td.getDeclaringType().getQualifiedName() + "$" + td.getSimpleName()) : td.getQualifiedName();
                return qualifiedName;
            }

            private int calculateActualRequired(MethodDeclaration md, int paramsLength, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
                int actualRequired;
                if (optional == 0 && !rest2) {
                    int args2 = paramsLength;
                    if (args2 == 0) {
                        actualRequired = 0;
                    } else {
                        if (isStatic) {
                            --args2;
                        }
                        if (hasContext) {
                            --args2;
                        }
                        if (hasBlock) {
                            --args2;
                        }
                        actualRequired = args2;
                    }
                } else {
                    int args3 = paramsLength;
                    if (args3 == 0) {
                        actualRequired = 0;
                    } else {
                        if (isStatic) {
                            --args3;
                        }
                        if (hasContext) {
                            --args3;
                        }
                        if (hasBlock) {
                            --args3;
                        }
                        actualRequired = --args3;
                    }
                    if (actualRequired != 0) {
                        throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + md.getDeclaringType().getQualifiedName() + "." + md.toString());
                    }
                }
                return actualRequired;
            }

            public void generateMethodAddCalls(MethodDeclaration md, JRubyMethod jrubyMethod) {
                if (jrubyMethod.meta()) {
                    this.defineMethodOnClass("javaMethod", "singletonClass", jrubyMethod, md);
                } else {
                    this.defineMethodOnClass("javaMethod", "cls", jrubyMethod, md);
                    if (jrubyMethod.module()) {
                        this.out.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                        this.defineMethodOnClass("moduleMethod", "singletonClass", jrubyMethod, md);
                    }
                }
            }

            private void defineMethodOnClass(String methodVar, String classVar, JRubyMethod jrubyMethod, MethodDeclaration md) {
                String baseName;
                if (jrubyMethod.name().length == 0) {
                    baseName = md.getSimpleName();
                    this.out.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + baseName + "\", " + methodVar + ");");
                } else {
                    baseName = jrubyMethod.name()[0];
                    for (String name2 : jrubyMethod.name()) {
                        this.out.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + name2 + "\", " + methodVar + ");");
                    }
                }
                if (jrubyMethod.alias().length > 0) {
                    for (String alias2 : jrubyMethod.alias()) {
                        this.out.println("        " + classVar + ".defineAlias(\"" + alias2 + "\", \"" + baseName + "\");");
                    }
                }
            }
        }
    }
}

