/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERBoolean
extends ASN1Object {
    byte value;
    public static final DERBoolean FALSE = new DERBoolean(false);
    public static final DERBoolean TRUE = new DERBoolean(true);

    public static DERBoolean getInstance(Object object) {
        if (object == null || object instanceof DERBoolean) {
            return (DERBoolean)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBoolean getInstance(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static DERBoolean getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERBoolean) {
            return DERBoolean.getInstance(dERObject);
        }
        return new DERBoolean(((ASN1OctetString)dERObject).getOctets());
    }

    public DERBoolean(byte[] byArray) {
        if (byArray.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        this.value = byArray[0];
    }

    public DERBoolean(boolean bl) {
        this.value = (byte)(bl ? -1 : 0);
    }

    public boolean isTrue() {
        return this.value != 0;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[]{this.value};
        dEROutputStream.writeEncoded(1, byArray);
    }

    protected boolean asn1Equals(DERObject dERObject) {
        if (dERObject == null || !(dERObject instanceof DERBoolean)) {
            return false;
        }
        return this.value == ((DERBoolean)dERObject).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.value != 0 ? "TRUE" : "FALSE";
    }
}

