/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby19;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceivePostReqdArgInstr
extends ReceiveArgBase {
    public final int preReqdArgsCount;
    public final int postReqdArgsCount;

    public ReceivePostReqdArgInstr(Variable result2, int index2, int preReqdArgsCount, int postReqdArgsCount) {
        super(Operation.RECV_POST_REQD_ARG, result2, index2);
        this.preReqdArgsCount = preReqdArgsCount;
        this.postReqdArgsCount = postReqdArgsCount;
    }

    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.argIndex + ", " + this.preReqdArgsCount + ", " + this.postReqdArgsCount + ")";
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (ii.canMapArgsStatically()) {
            int n = ii.getArgsCount();
            int remaining = n - this.preReqdArgsCount;
            Operand argVal = remaining <= this.argIndex ? ii.getInlineHostScope().getManager().getNil() : (remaining > this.postReqdArgsCount ? ii.getArg(n - this.postReqdArgsCount + this.argIndex) : ii.getArg(this.preReqdArgsCount + this.argIndex));
            return new CopyInstr(ii.getRenamedVariable(this.result), argVal);
        }
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.preReqdArgsCount, this.postReqdArgsCount, this.argIndex);
    }

    public Instr cloneForBlockCloning(InlinerInfo ii) {
        return new ReceivePostReqdArgInstr(ii.getRenamedVariable(this.result), this.argIndex, this.preReqdArgsCount, this.postReqdArgsCount);
    }

    public IRubyObject receivePostReqdArg(IRubyObject[] args2) {
        int n = args2.length;
        int remaining = n - this.preReqdArgsCount;
        if (remaining <= this.argIndex) {
            return null;
        }
        return remaining > this.postReqdArgsCount ? args2[n - this.postReqdArgsCount + this.argIndex] : args2[this.preReqdArgsCount + this.argIndex];
    }

    public void visit(IRVisitor visitor) {
        visitor.ReceivePostReqdArgInstr(this);
    }
}

