/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;

public class InheritedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    int scopeCount = 0;
    int callSiteCount = 0;
    List<String> callSiteList = new ArrayList<String>();
    List<CallType> callTypeList = new ArrayList<CallType>();
    Map<String, String> stringEncToString = new HashMap<String, String>();
    Map<String, Integer> stringIndices = new HashMap<String, Integer>();
    Map<String, Integer> encodingIndices = new HashMap<String, Integer>();
    Map<String, Integer> stringEncodings = new HashMap<String, Integer>();
    Map<String, Integer> symbolIndices = new HashMap<String, Integer>();
    Map<Long, Integer> fixnumIndices = new HashMap<Long, Integer>();
    Map<Double, Integer> floatIndices = new HashMap<Double, Integer>();
    int inheritedSymbolCount = 0;
    int inheritedStringCount = 0;
    int inheritedEncodingCount = 0;
    int inheritedRegexpCount = 0;
    int inheritedBigIntegerCount = 0;
    int inheritedVariableReaderCount = 0;
    int inheritedVariableWriterCount = 0;
    int inheritedFixnumCount = 0;
    int inheritedFloatCount = 0;
    int inheritedConstantCount = 0;
    int inheritedBlockBodyCount = 0;
    int inheritedBlockCallbackCount = 0;
    int inheritedMethodCount = 0;
    boolean runtimeCacheInited = false;

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        this.scriptCompiler = scriptCompiler;
    }

    public int cacheStaticScope(BaseBodyCompiler method2, StaticScope scope) {
        String scopeString = RuntimeHelpers.encodeScope(scope);
        int index2 = this.scopeCount++;
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.ldc(scopeString);
        if (index2 < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getScope" + index2, CodegenUtils.sig(StaticScope.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getScope", CodegenUtils.sig(StaticScope.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        return index2;
    }

    public void loadStaticScope(BaseBodyCompiler method2, int index2) {
        if (this.scopeCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getScope" + index2, CodegenUtils.sig(StaticScope.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getScope", CodegenUtils.sig(StaticScope.class, ThreadContext.class, String.class, Integer.TYPE));
        }
    }

    public void cacheCallSite(BaseBodyCompiler method2, String name2, CallType callType) {
        method2.loadThis();
        if (this.callSiteCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getCallSite" + this.callSiteCount, CodegenUtils.sig(CallSite.class, new Class[0]));
        } else {
            method2.method.pushInt(this.callSiteCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getCallSite", CodegenUtils.sig(CallSite.class, Integer.TYPE));
        }
        this.callSiteList.add(name2);
        this.callTypeList.add(callType);
        ++this.callSiteCount;
    }

    public void cacheSymbol(BaseBodyCompiler method2, String symbol) {
        Integer index2 = this.symbolIndices.get(symbol);
        if (index2 == null) {
            index2 = this.inheritedSymbolCount++;
            this.symbolIndices.put(symbol, index2);
        }
        method2.loadThis();
        method2.loadThreadContext();
        if (index2 < 10) {
            method2.method.ldc(symbol);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getSymbol" + index2, CodegenUtils.sig(RubySymbol.class, ThreadContext.class, String.class));
        } else {
            method2.method.ldc((int)index2);
            method2.method.ldc(symbol);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getSymbol", CodegenUtils.sig(RubySymbol.class, ThreadContext.class, Integer.TYPE, String.class));
        }
    }

    public void cacheRegexp(BaseBodyCompiler method2, ByteList pattern, int options2) {
        method2.loadThis();
        method2.loadThreadContext();
        int index2 = this.inheritedRegexpCount++;
        if (index2 < 10) {
            this.cacheByteList(method2, pattern);
            method2.method.ldc(options2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getRegexp" + index2, CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, ByteList.class, Integer.TYPE));
        } else {
            method2.method.pushInt(index2);
            this.cacheByteList(method2, pattern);
            method2.method.ldc(options2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getRegexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class, Integer.TYPE, ByteList.class, Integer.TYPE));
        }
    }

    public void cacheDRegexp(BaseBodyCompiler method2, CompilerCallback createStringCallback, int options2) {
        int index2 = this.inheritedRegexpCount++;
        Label alreadyCompiled = new Label();
        method2.loadThis();
        method2.method.getfield(this.scriptCompiler.getClassname(), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        method2.method.pushInt(index2);
        method2.method.invokevirtual(CodegenUtils.p(RuntimeCache.class), "getRegexp", CodegenUtils.sig(RubyRegexp.class, Integer.TYPE));
        method2.method.dup();
        method2.ifNotNull(alreadyCompiled);
        method2.method.pop();
        method2.loadThis();
        method2.method.getfield(this.scriptCompiler.getClassname(), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        method2.method.pushInt(index2);
        createStringCallback.call(method2);
        method2.method.ldc(options2);
        method2.method.invokevirtual(CodegenUtils.p(RuntimeCache.class), "cacheRegexp", CodegenUtils.sig(RubyRegexp.class, Integer.TYPE, RubyString.class, Integer.TYPE));
        method2.method.label(alreadyCompiled);
    }

    public void cacheDRegexp19(BaseBodyCompiler method2, ArrayCallback arrayCallback, Object[] sourceArray, int options2) {
        int index2 = this.inheritedRegexpCount++;
        Label alreadyCompiled = new Label();
        method2.loadThis();
        method2.method.getfield(this.scriptCompiler.getClassname(), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        method2.method.pushInt(index2);
        method2.method.invokevirtual(CodegenUtils.p(RuntimeCache.class), "getRegexp", CodegenUtils.sig(RubyRegexp.class, Integer.TYPE));
        method2.method.dup();
        method2.ifNotNull(alreadyCompiled);
        method2.method.pop();
        method2.loadThis();
        method2.method.getfield(this.scriptCompiler.getClassname(), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        method2.method.pushInt(index2);
        method2.loadRuntime();
        method2.createObjectArray(sourceArray, arrayCallback);
        method2.method.ldc(options2);
        method2.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newDRegexpEmbedded19", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, IRubyObject[].class, Integer.TYPE)));
        method2.method.invokevirtual(CodegenUtils.p(RuntimeCache.class), "cacheRegexp", CodegenUtils.sig(RubyRegexp.class, Integer.TYPE, RubyRegexp.class));
        method2.method.label(alreadyCompiled);
    }

    public void cacheFixnum(BaseBodyCompiler method2, long value2) {
        block15: {
            block14: {
                if (value2 > 5L || value2 < -1L) break block14;
                method2.loadRuntime();
                switch ((int)value2) {
                    case -1: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "minus_one", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 0: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "zero", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 1: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "one", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 2: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "two", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 3: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "three", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 4: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "four", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 5: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "five", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("wtf?");
                    }
                }
            }
            Integer index2 = this.fixnumIndices.get(value2);
            if (index2 == null) {
                index2 = this.inheritedFixnumCount++;
                this.fixnumIndices.put(value2, index2);
            }
            method2.loadThis();
            method2.loadThreadContext();
            if (value2 <= Integer.MAX_VALUE && value2 >= Integer.MIN_VALUE) {
                if (index2 < 10) {
                    method2.method.pushInt((int)value2);
                    method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum" + index2, CodegenUtils.sig(RubyFixnum.class, ThreadContext.class, Integer.TYPE));
                } else {
                    method2.method.pushInt(index2);
                    method2.method.pushInt((int)value2);
                    method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum", CodegenUtils.sig(RubyFixnum.class, ThreadContext.class, Integer.TYPE, Integer.TYPE));
                }
            } else {
                method2.method.pushInt(index2);
                method2.method.ldc(value2);
                method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum", CodegenUtils.sig(RubyFixnum.class, ThreadContext.class, Integer.TYPE, Long.TYPE));
            }
        }
    }

    public void cacheFloat(BaseBodyCompiler method2, double value2) {
        Integer index2 = this.inheritedFloatCount++;
        this.floatIndices.put(value2, index2);
        method2.loadThis();
        method2.loadThreadContext();
        if (index2 < 10) {
            method2.method.ldc(value2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFloat" + index2, CodegenUtils.sig(RubyFloat.class, ThreadContext.class, Double.TYPE));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(value2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFloat", CodegenUtils.sig(RubyFloat.class, ThreadContext.class, Integer.TYPE, Double.TYPE));
        }
    }

    public void cacheConstant(BaseBodyCompiler method2, String constantName) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.ldc(constantName);
        if (this.inheritedConstantCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstant" + this.inheritedConstantCount, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedConstantCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstant", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        ++this.inheritedConstantCount;
    }

    public void cacheConstantDefined(BaseBodyCompiler method2, String constantName) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.ldc(constantName);
        if (this.inheritedConstantCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstantDefined" + this.inheritedConstantCount, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedConstantCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstantDefined", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        ++this.inheritedConstantCount;
    }

    public void cacheConstantFrom(BaseBodyCompiler method2, String constantName) {
        method2.loadThis();
        method2.method.swap();
        method2.loadThreadContext();
        method2.method.ldc(constantName);
        if (this.inheritedConstantCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstantFrom" + this.inheritedConstantCount, CodegenUtils.sig(IRubyObject.class, RubyModule.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedConstantCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstantFrom", CodegenUtils.sig(IRubyObject.class, RubyModule.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        ++this.inheritedConstantCount;
    }

    public void cacheString(BaseBodyCompiler method2, ByteList contents, int codeRange) {
        String asString = RuntimeHelpers.rawBytesToString(contents.bytes());
        String key2 = asString + contents.getEncoding();
        Integer index2 = this.stringIndices.get(key2);
        if (index2 == null) {
            index2 = this.inheritedStringCount++;
            this.stringEncToString.put(key2, asString);
            this.stringIndices.put(key2, index2);
            this.stringEncodings.put(key2, this.cacheEncodingInternal(contents.getEncoding()));
        }
        method2.loadThis();
        method2.loadThreadContext();
        if (index2 < 10) {
            method2.method.pushInt(codeRange);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getString" + index2, CodegenUtils.sig(RubyString.class, ThreadContext.class, Integer.TYPE));
        } else {
            method2.method.pushInt(index2);
            method2.method.pushInt(codeRange);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getString", CodegenUtils.sig(RubyString.class, ThreadContext.class, Integer.TYPE, Integer.TYPE));
        }
    }

    public void cacheByteList(BaseBodyCompiler method2, ByteList contents) {
        String asString = RuntimeHelpers.rawBytesToString(contents.bytes());
        String key2 = asString + contents.getEncoding();
        Integer index2 = this.stringIndices.get(key2);
        if (index2 == null) {
            index2 = this.inheritedStringCount++;
            this.stringEncToString.put(key2, asString);
            this.stringIndices.put(key2, index2);
            this.stringEncodings.put(key2, this.cacheEncodingInternal(contents.getEncoding()));
        }
        method2.loadThis();
        if (index2 < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getByteList" + index2, CodegenUtils.sig(ByteList.class, new Class[0]));
        } else {
            method2.method.pushInt(index2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getByteList", CodegenUtils.sig(ByteList.class, Integer.TYPE));
        }
    }

    public void cacheRubyEncoding(BaseBodyCompiler method2, Encoding encoding2) {
        this.cacheEncoding(method2, encoding2);
        this.createRubyEncoding(method2);
    }

    public int cacheEncoding(BaseBodyCompiler method2, Encoding encoding2) {
        int index2 = this.cacheEncodingInternal(encoding2);
        this.loadEncoding(method2.method, index2);
        return index2;
    }

    private int cacheEncodingInternal(Encoding encoding2) {
        String encodingName = new String(encoding2.getName());
        Integer index2 = this.encodingIndices.get(encodingName);
        if (index2 == null) {
            index2 = this.inheritedEncodingCount++;
            this.encodingIndices.put(encodingName, index2);
        }
        return index2;
    }

    private void loadEncoding(SkinnyMethodAdapter method2, int encodingIndex) {
        method2.aload(0);
        if (encodingIndex < 10) {
            method2.invokevirtual(this.scriptCompiler.getClassname(), "getEncoding" + encodingIndex, CodegenUtils.sig(Encoding.class, new Class[0]));
        } else {
            method2.pushInt(encodingIndex);
            method2.invokevirtual(this.scriptCompiler.getClassname(), "getEncoding", CodegenUtils.sig(Encoding.class, Integer.TYPE));
        }
    }

    private void createRubyEncoding(BaseBodyCompiler method2) {
        method2.loadRuntime();
        method2.invokeRuby("getEncodingService", CodegenUtils.sig(EncodingService.class, new Class[0]));
        method2.method.swap();
        method2.method.invokevirtual(CodegenUtils.p(EncodingService.class), "getEncoding", CodegenUtils.sig(RubyEncoding.class, Encoding.class));
    }

    public void cacheBigInteger(BaseBodyCompiler method2, BigInteger bigint) {
        method2.loadThis();
        int index2 = this.inheritedBigIntegerCount++;
        if (index2 < 10) {
            method2.method.ldc(bigint.toString(16));
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBigInteger" + index2, CodegenUtils.sig(BigInteger.class, String.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(bigint.toString(16));
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBigInteger", CodegenUtils.sig(BigInteger.class, Integer.TYPE, String.class));
        }
    }

    public void cachedGetVariable(BaseBodyCompiler method2, String name2) {
        method2.loadThis();
        method2.loadThreadContext();
        int index2 = this.inheritedVariableReaderCount++;
        if (index2 < 10) {
            method2.method.ldc(name2);
            method2.loadSelf();
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getVariable" + index2, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, IRubyObject.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(name2);
            method2.loadSelf();
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getVariable", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE, String.class, IRubyObject.class));
        }
    }

    public void cachedGetVariableDefined(BaseBodyCompiler method2, String name2) {
        method2.loadThis();
        method2.loadThreadContext();
        int index2 = this.inheritedVariableReaderCount++;
        if (index2 < 10) {
            method2.method.ldc(name2);
            method2.loadSelf();
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getVariableDefined" + index2, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, IRubyObject.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(name2);
            method2.loadSelf();
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getVariableDefined", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE, String.class, IRubyObject.class));
        }
    }

    public void cachedSetVariable(BaseBodyCompiler method2, String name2, CompilerCallback valueCallback) {
        method2.loadThis();
        int index2 = this.inheritedVariableWriterCount++;
        if (index2 < 10) {
            method2.method.ldc(name2);
            method2.loadSelf();
            valueCallback.call(method2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "setVariable" + index2, CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(name2);
            method2.loadSelf();
            valueCallback.call(method2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "setVariable", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, String.class, IRubyObject.class, IRubyObject.class));
        }
    }

    public void cacheClosure(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String descriptor = RuntimeHelpers.buildBlockDescriptor(closureMethod, arity2, scope, file2, line, hasMultipleArgsHead, argsNodeId, inspector);
        method2.loadThis();
        method2.loadThreadContext();
        if (this.inheritedBlockBodyCount < 10) {
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody" + this.inheritedBlockBodyCount, CodegenUtils.sig(BlockBody.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedBlockBodyCount);
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Integer.TYPE, String.class));
        }
        ++this.inheritedBlockBodyCount;
    }

    public void cacheClosure19(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, String file2, int line, boolean hasMultipleArgsHead, NodeType argsNodeId, String parameterList, ASTInspector inspector) {
        String descriptor = RuntimeHelpers.buildBlockDescriptor19(closureMethod, arity2, scope, file2, line, hasMultipleArgsHead, argsNodeId, parameterList, inspector);
        method2.loadThis();
        method2.loadThreadContext();
        if (this.inheritedBlockBodyCount < 10) {
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody19" + this.inheritedBlockBodyCount, CodegenUtils.sig(BlockBody.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedBlockBodyCount);
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody19", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Integer.TYPE, String.class));
        }
        ++this.inheritedBlockBodyCount;
    }

    public void cacheSpecialClosure(BaseBodyCompiler method2, String closureMethod) {
        method2.loadThis();
        if (this.inheritedBlockCallbackCount < 10) {
            method2.method.ldc(closureMethod);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockCallback" + this.inheritedBlockCallbackCount, CodegenUtils.sig(CompiledBlockCallback.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedBlockCallbackCount);
            method2.method.ldc(closureMethod);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, Integer.TYPE, String.class));
        }
        ++this.inheritedBlockCallbackCount;
    }

    public void cacheMethod(BaseBodyCompiler method2, String methodName) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.loadSelf();
        if (this.inheritedMethodCount < 10) {
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod" + this.inheritedMethodCount, CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedMethodCount);
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, Integer.TYPE, String.class));
        }
        ++this.inheritedMethodCount;
    }

    public void cacheMethod(BaseBodyCompiler method2, String methodName, int receiverLocal) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.aload(receiverLocal);
        if (this.inheritedMethodCount < 10) {
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod" + this.inheritedMethodCount, CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedMethodCount);
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, Integer.TYPE, String.class));
        }
        ++this.inheritedMethodCount;
    }

    public void finish() {
        int otherCount;
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        int callSiteListSize = this.callSiteList.size();
        if (callSiteListSize + (otherCount = this.scopeCount + this.inheritedSymbolCount + this.inheritedFixnumCount + this.inheritedFloatCount + this.inheritedConstantCount + this.inheritedRegexpCount + this.inheritedBigIntegerCount + this.inheritedVariableReaderCount + this.inheritedVariableWriterCount + this.inheritedBlockBodyCount + this.inheritedBlockCallbackCount + this.inheritedMethodCount + this.inheritedStringCount + this.inheritedEncodingCount) != 0) {
            this.ensureRuntimeCacheInited(initMethod);
            StringBuffer descriptor = new StringBuffer(callSiteListSize * 5 + 12);
            for (int i2 = 0; i2 < callSiteListSize; ++i2) {
                String name2 = this.callSiteList.get(i2);
                CallType callType = this.callTypeList.get(i2);
                if (i2 > 0) {
                    descriptor.append('\uffff');
                }
                if (callType.equals((Object)CallType.NORMAL)) {
                    descriptor.append(name2).append("\uffffN");
                    continue;
                }
                if (callType.equals((Object)CallType.FUNCTIONAL)) {
                    descriptor.append(name2).append("\uffffF");
                    continue;
                }
                if (callType.equals((Object)CallType.VARIABLE)) {
                    descriptor.append(name2).append("\uffffV");
                    continue;
                }
                if (!callType.equals((Object)CallType.SUPER)) continue;
                descriptor.append("super").append("\uffffS");
            }
            descriptor.append('\uffff');
            descriptor.append((char)this.scopeCount);
            descriptor.append((char)this.inheritedSymbolCount);
            descriptor.append((char)this.inheritedFixnumCount);
            descriptor.append((char)this.inheritedFloatCount);
            descriptor.append((char)this.inheritedConstantCount);
            descriptor.append((char)this.inheritedRegexpCount);
            descriptor.append((char)this.inheritedBigIntegerCount);
            descriptor.append((char)this.inheritedVariableReaderCount);
            descriptor.append((char)this.inheritedVariableWriterCount);
            descriptor.append((char)this.inheritedBlockBodyCount);
            descriptor.append((char)this.inheritedBlockCallbackCount);
            descriptor.append((char)this.inheritedMethodCount);
            descriptor.append((char)this.inheritedStringCount);
            descriptor.append((char)this.inheritedEncodingCount);
            initMethod.aload(0);
            initMethod.ldc(descriptor.toString());
            initMethod.invokevirtual(CodegenUtils.p(AbstractScript.class), "initFromDescriptor", CodegenUtils.sig(Void.TYPE, String.class));
            if (this.inheritedEncodingCount > 0) {
                for (Map.Entry<String, Integer> entry : this.encodingIndices.entrySet()) {
                    initMethod.aload(0);
                    initMethod.ldc(entry.getValue());
                    initMethod.ldc(entry.getKey());
                    initMethod.invokevirtual(CodegenUtils.p(AbstractScript.class), "setEncoding", CodegenUtils.sig(Void.TYPE, Integer.TYPE, String.class));
                }
            }
            if (this.inheritedStringCount > 0) {
                for (Map.Entry<String, Integer> entry : this.stringIndices.entrySet()) {
                    initMethod.aload(0);
                    initMethod.ldc(entry.getValue());
                    String key2 = entry.getKey();
                    initMethod.ldc(this.stringEncToString.get(key2));
                    this.loadEncoding(initMethod, this.stringEncodings.get(entry.getKey()));
                    initMethod.invokevirtual(CodegenUtils.p(AbstractScript.class), "setByteList", CodegenUtils.sig(Void.TYPE, Integer.TYPE, String.class, Encoding.class));
                }
            }
        }
    }

    private void ensureRuntimeCacheInited(SkinnyMethodAdapter initMethod) {
        if (!this.runtimeCacheInited) {
            initMethod.aload(0);
            initMethod.newobj(CodegenUtils.p(RuntimeCache.class));
            initMethod.dup();
            initMethod.invokespecial(CodegenUtils.p(RuntimeCache.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            initMethod.putfield(CodegenUtils.p(AbstractScript.class), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
            this.runtimeCacheInited = true;
        }
    }
}

