/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import com.kenai.jaffl.LastError;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.cext.GC;
import org.jruby.cext.GIL;
import org.jruby.cext.Handle;
import org.jruby.cext.Native;
import org.jruby.cext.NativeMethod;
import org.jruby.cext.NativeMethod0;
import org.jruby.cext.NativeMethod1;
import org.jruby.cext.NativeMethod2;
import org.jruby.cext.NativeMethod3;
import org.jruby.cext.NativeProcMethod;
import org.jruby.cext.RArray;
import org.jruby.cext.RString;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRuby {
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    public static long callRubyMethod(IRubyObject recv2, Object methodName, IRubyObject[] args2) {
        IRubyObject retval = recv2.callMethod(recv2.getRuntime().getCurrentContext(), methodName.toString(), args2);
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod0(IRubyObject recv2, Object methodName) {
        IRubyObject retval = RuntimeHelpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString());
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod1(IRubyObject recv2, Object methodName, IRubyObject arg1) {
        IRubyObject retval = RuntimeHelpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString(), arg1);
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod2(IRubyObject recv2, Object methodName, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject retval = RuntimeHelpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString(), arg1, arg2);
        return Handle.nativeHandle(retval);
    }

    public static long callRubyMethod3(IRubyObject recv2, Object methodName, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        IRubyObject retval = RuntimeHelpers.invoke(recv2.getRuntime().getCurrentContext(), recv2, methodName.toString(), arg1, arg2, arg3);
        return Handle.nativeHandle(retval);
    }

    public static long callSuperMethod(Ruby runtime2, IRubyObject[] args2) {
        ThreadContext currentContext = runtime2.getCurrentContext();
        IRubyObject retval = RuntimeHelpers.invokeSuper(currentContext, runtime2.getCurrentContext().getFrameSelf(), args2, Block.NULL_BLOCK);
        return Handle.nativeHandle(retval);
    }

    public static long instanceEval(IRubyObject self, IRubyObject[] args2) {
        Ruby runtime2 = self.getRuntime();
        ThreadContext ctxt = runtime2.getCurrentContext();
        Block block = ctxt.getFrameBlock();
        IRubyObject retval = self.callMethod(ctxt, "instance_eval", args2, block);
        return Handle.nativeHandle(retval);
    }

    public static long newString(Ruby runtime2, byte[] bytes2, int length2, boolean tainted) {
        RubyString retval = RubyString.newStringNoCopy(runtime2, bytes2);
        if (tainted) {
            retval.setTaint(tainted);
        }
        retval.getByteList().setRealSize(length2);
        return Handle.nativeHandle(retval);
    }

    public static DynamicMethod newMethod(RubyModule module, long fn, int arity2) {
        switch (arity2) {
            case 0: {
                return new NativeMethod0(module, arity2, fn);
            }
            case 1: {
                return new NativeMethod1(module, arity2, fn);
            }
            case 2: {
                return new NativeMethod2(module, arity2, fn);
            }
            case 3: {
                return new NativeMethod3(module, arity2, fn);
            }
        }
        return new NativeMethod(module, arity2, fn);
    }

    public static RubyFloat newFloat(Ruby runtime2, long handle, double value2) {
        RubyFloat f = RubyFloat.newFloat(runtime2, value2);
        GC.register(f, Handle.newHandle(runtime2, f, handle));
        return f;
    }

    public static IRubyObject newThread(Ruby runtime2, long fn, IRubyObject args_ary) {
        IRubyObject[] iRubyObjectArray;
        RubyProc proc2 = (RubyProc)JRuby.newProc(runtime2, fn);
        if (args_ary instanceof RubyArray) {
            iRubyObjectArray = ((RubyArray)args_ary).toJavaArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args_ary;
        }
        IRubyObject[] args2 = iRubyObjectArray;
        return RubyThread.newInstance(runtime2.getThread(), args2, proc2.getBlock());
    }

    public static IRubyObject newProc(Ruby runtime2, long fn) {
        String name2 = System.currentTimeMillis() + "$block_jruby-cext";
        IRubyObject recv2 = runtime2.getCurrentContext().getFrameSelf();
        RubyMethod method2 = RubyMethod.newMethod(recv2.getMetaClass(), name2, recv2.getMetaClass(), name2, new NativeProcMethod(recv2.getMetaClass(), fn), recv2);
        IRubyObject proc2 = method2.to_proc(runtime2.getCurrentContext(), Block.NULL_BLOCK);
        return proc2;
    }

    public static long getRString(RubyString str) {
        return RString.valueOf(str).address();
    }

    public static long getRArray(RubyArray ary) {
        return RArray.valueOf(ary).address();
    }

    public static IRubyObject yield(Ruby runtime2, RubyArray args2) {
        return runtime2.getCurrentContext().getFrameBlock().call(runtime2.getCurrentContext(), args2.toJavaArray());
    }

    public static int blockGiven(Ruby runtime2) {
        return runtime2.getCurrentContext().getFrameBlock().isGiven() ? 1 : 0;
    }

    public static RubyProc getBlockProc(Ruby runtime2) {
        Block block = runtime2.getCurrentContext().getFrameBlock();
        RubyProc p2 = RubyProc.newProc(runtime2, block, block.type);
        return p2;
    }

    public static long ll2inum(Ruby runtime2, long l) {
        RubyFixnum n = RubyFixnum.newFixnum(runtime2, l);
        Handle h = GC.lookup(n);
        if (h != null) {
            return h.getAddress();
        }
        h = Handle.newHandle(runtime2, n, Native.getInstance(runtime2).newFixnumHandle(n, l));
        GC.register(n, h);
        return h.getAddress();
    }

    public static long ull2inum(Ruby runtime2, long l) {
        RubyInteger n = l < 0L ? RubyBignum.newBignum(runtime2, BigInteger.valueOf(l & Long.MAX_VALUE).add(UINT64_BASE)) : runtime2.newFixnum(l);
        Handle h = GC.lookup(n);
        if (h != null) {
            return h.getAddress();
        }
        h = Handle.newHandle(runtime2, n, Native.getInstance(runtime2).newFixnumHandle(n, l));
        GC.register(n, h);
        return h.getAddress();
    }

    public static long int2big(Ruby runtime2, long l) {
        return Handle.nativeHandle(RubyBignum.newBignum(runtime2, l));
    }

    public static long uint2big(Ruby runtime2, long l) {
        RubyBignum retval = l < 0L ? RubyBignum.newBignum(runtime2, BigInteger.valueOf(l & Long.MAX_VALUE).add(UINT64_BASE)) : RubyBignum.newBignum(runtime2, l);
        return Handle.nativeHandle(retval);
    }

    public static long gv_set(Ruby runtime2, String name2, IRubyObject value2) {
        return Handle.nativeHandle(runtime2.getGlobalVariables().set(name2, value2));
    }

    public static long gv_get(Ruby runtime2, String name2) {
        return Handle.nativeHandle(runtime2.getGlobalVariables().get(name2));
    }

    public static void clearErrorInfo(Ruby runtime2) {
        runtime2.getCurrentContext().setErrorInfo(runtime2.getNil());
    }

    public static void sysFail(Ruby runtime2, String message2) {
        int n = LastError.getLastError();
        JRuby.sysFail(runtime2, message2, n);
    }

    public static void sysFail(Ruby runtime2, String message2, int n) {
        IRubyObject arg2 = message2 != null ? runtime2.newString(message2) : runtime2.getNil();
        RubyClass instance = runtime2.getErrno(n);
        if (instance == null) {
            instance = runtime2.getSystemCallError();
            throw new RaiseException((RubyException)instance.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{arg2, runtime2.newFixnum(n)}, Block.NULL_BLOCK));
        }
        throw new RaiseException((RubyException)instance.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{arg2}, Block.NULL_BLOCK));
    }

    public static void threadSleep(Ruby runtime2, int interval) {
        try {
            runtime2.getCurrentContext().getThread().sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long nativeBlockingRegion(Ruby runtime2, long blocking_func, long blocking_data, long unblocking_func, long unblocking_data) {
        RubyThread thread = runtime2.getCurrentContext().getThread();
        NativeFunctionTask task = new NativeFunctionTask(Native.getInstance(runtime2), blocking_func, blocking_data, unblocking_func, unblocking_data);
        GC.disable();
        int lockCount = GIL.releaseAllLocks();
        try {
            try {
                thread.executeBlockingTask(task);
            }
            catch (InterruptedException e) {
                Object var14_9 = null;
                GIL.acquire(lockCount);
                GC.enable();
                return task.retval;
            }
            Object var14_8 = null;
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            GIL.acquire(lockCount);
            GC.enable();
            throw throwable;
        }
        GIL.acquire(lockCount);
        GC.enable();
        return task.retval;
    }

    public static final class NativeFunctionTask
    implements RubyThread.BlockingTask {
        private Native nativeInstance;
        private long run;
        private long run_data;
        private long wakeup;
        private long wakeup_data = 0L;
        public long retval = 4L;

        public NativeFunctionTask(Native nativeInstance, long run2, long run_data, long wakeup2, long wakeup_data) {
            this.nativeInstance = nativeInstance;
            this.run = run2;
            this.run_data = run_data;
            this.wakeup = wakeup2;
            this.wakeup_data = wakeup_data;
        }

        public void run() throws InterruptedException {
            this.retval = this.nativeInstance.callFunction(this.run, this.run_data);
        }

        public void wakeup() {
            this.nativeInstance.callFunction(this.wakeup, this.wakeup_data);
        }
    }
}

