/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.io;

import java.nio.channels.Channel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.io.FileDescriptorByteChannel;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public FileDescriptorIO(Ruby runtime2, IRubyObject fd) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME));
        try {
            ModeFlags modes = new ModeFlags(ModeFlags.RDWR);
            this.openFile.setMainStream(ChannelStream.open(this.getRuntime(), new ChannelDescriptor((Channel)new FileDescriptorByteChannel(this.getRuntime(), RubyNumeric.fix2int(fd)), modes)));
            this.openFile.setPipeStream(this.openFile.getMainStreamSafe());
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.getMainStreamSafe().setSync(true);
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RubyClass createFileDescriptorIOClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.fastGetClass("IO"), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(FileDescriptorIO.class);
        result.defineAnnotatedConstants(FileDescriptorIO.class);
        return result;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.getRuntime(), fd);
    }

    @JRubyMethod(name={"wrap"}, required=1, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv2, IRubyObject fd) {
        return new FileDescriptorIO(context.getRuntime(), fd);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new FileDescriptorIO(runtime2, klass);
        }
    }
}

