/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.NormalizedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Dir"}, include={"Enumerable"})
public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static final ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyDir(runtime2, klass);
        }
    };

    public RubyDir(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static RubyClass createDirClass(Ruby runtime2) {
        RubyClass dirClass = runtime2.defineClass("Dir", runtime2.getObject(), DIR_ALLOCATOR);
        runtime2.setDir(dirClass);
        dirClass.index = 35;
        dirClass.setReifiedClass(RubyDir.class);
        dirClass.includeModule(runtime2.getEnumerable());
        dirClass.defineAnnotatedMethods(RubyDir.class);
        return dirClass;
    }

    private final void checkDir() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: operation on untainted Dir");
        }
        this.testFrozen("Dir");
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject arg2) {
        RubyString newPath;
        this.path = newPath = arg2.convertToString();
        this.pos = 0;
        this.getRuntime().checkSafeString(newPath);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(this.getRuntime(), newPath.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(this.getRuntime(), adjustedPath);
        List<String> snapshotList = RubyDir.getEntries(this.getRuntime(), adjustedPath);
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject arg2) {
        if (arg2.respondsTo("to_path")) {
            arg2 = arg2.callMethod(this.getRuntime().getCurrentContext(), "to_path");
        }
        return this.initialize(arg2);
    }

    private static List<ByteList> dirGlobs(String cwd, IRubyObject[] args2, int flags) {
        ArrayList<ByteList> dirs = new ArrayList<ByteList>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ByteList globPattern = args2[i2].convertToString().getByteList();
            dirs.addAll(Dir.push_glob(cwd, globPattern, flags));
        }
        return dirs;
    }

    private static IRubyObject asRubyStringList(Ruby runtime2, List<ByteList> dirs) {
        ArrayList<RubyString> allFiles = new ArrayList<RubyString>();
        for (ByteList dir : dirs) {
            allFiles.add(RubyString.newString(runtime2, dir));
        }
        IRubyObject[] tempFileList = new IRubyObject[allFiles.size()];
        allFiles.toArray(tempFileList);
        return runtime2.newArrayNoCopy(tempFileList);
    }

    private static String getCWD(Ruby runtime2) {
        try {
            return new NormalizedFile(runtime2.getCurrentDirectory()).getCanonicalPath();
        }
        catch (Exception e) {
            return runtime2.getCurrentDirectory();
        }
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, meta=true)
    public static IRubyObject aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        List<ByteList> dirs;
        Ruby runtime2 = context.getRuntime();
        if (args2.length == 1) {
            ByteList globPattern = null;
            globPattern = runtime2.is1_9() && args2[0].respondsTo("to_path") ? args2[0].callMethod(context, "to_path").convertToString().getByteList() : args2[0].convertToString().getByteList();
            dirs = Dir.push_glob(RubyDir.getCWD(runtime2), globPattern, 0);
        } else {
            dirs = RubyDir.dirGlobs(RubyDir.getCWD(runtime2), args2, 0);
        }
        return RubyDir.asRubyStringList(runtime2, dirs);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        List<ByteList> dirs;
        Ruby runtime2 = context.getRuntime();
        int flags = args2.length == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject tmp = args2[0].checkArrayType();
        if (tmp.isNil()) {
            ByteList globPattern = null;
            globPattern = runtime2.is1_9() && args2[0].respondsTo("to_path") ? args2[0].callMethod(context, "to_path").convertToString().getByteList() : args2[0].convertToString().getByteList();
            dirs = Dir.push_glob(runtime2.getCurrentDirectory(), globPattern, flags);
        } else {
            dirs = RubyDir.dirGlobs(RubyDir.getCWD(runtime2), ((RubyArray)tmp).toJavaArray(), flags);
        }
        if (block.isGiven()) {
            for (int i2 = 0; i2 < dirs.size(); ++i2) {
                block.yield(context, RubyString.newString(runtime2, dirs.get(i2)));
            }
            return runtime2.getNil();
        }
        return RubyDir.asRubyStringList(runtime2, dirs);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    @JRubyMethod(name={"entries"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static RubyArray entries(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.entriesCommon(recv2.getRuntime(), path2.convertToString().getUnicodeValue());
    }

    @JRubyMethod(name={"entries"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static RubyArray entries19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyDir.entriesCommon(context.getRuntime(), RubyDir.getPath19(context, arg2));
    }

    @JRubyMethod(name={"entries"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static RubyArray entries19(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        return RubyDir.entriesCommon(context.getRuntime(), RubyDir.getPath19(context, arg2));
    }

    private static RubyArray entriesCommon(Ruby runtime2, String path2) {
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, path2, null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
        Object[] files = RubyDir.getEntries(runtime2, adjustedPath).toArray();
        return runtime2.newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(runtime2, files));
    }

    private static List<String> getEntries(Ruby runtime2, String path2) {
        if (!RubyFileTest.directory_p(runtime2, (IRubyObject)RubyString.newString(runtime2, path2)).isTrue()) {
            throw runtime2.newErrnoENOENTError("No such directory");
        }
        if (path2.startsWith("file:")) {
            return RubyDir.entriesIntoAJarFile(runtime2, path2);
        }
        return RubyDir.entriesIntoADirectory(runtime2, path2);
    }

    private static List<String> entriesIntoADirectory(Ruby runtime2, String path2) {
        JRubyFile directory = JRubyFile.create(runtime2.getCurrentDirectory(), path2);
        List<String> fileList = RubyDir.getContents(directory);
        fileList.add(0, ".");
        fileList.add(1, "..");
        return fileList;
    }

    private static List<String> entriesIntoAJarFile(Ruby runtime2, String path2) {
        List<ByteList> dirs = Dir.push_glob(runtime2.getCurrentDirectory(), RubyString.newString(runtime2, path2 + "/*").getByteList(), 4);
        ArrayList<String> fileList = new ArrayList<String>();
        for (ByteList file2 : dirs) {
            String[] split2 = file2.toString().split("/");
            fileList.add(split2[split2.length - 1]);
        }
        return fileList;
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby runtime2, String path2) {
        if (Platform.IS_WINDOWS && ("//".equals(path2) || "\\\\".equals(path2))) {
            throw runtime2.newErrnoEINVALError("Invalid argument - " + path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=1, meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject result;
        block5: {
            Ruby runtime2 = context.getRuntime();
            RubyString path2 = args2.length == 1 ? RubyFile.get_path(context, args2[0]) : RubyDir.getHomeDirectoryPath(context);
            String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime2, path2.getUnicodeValue(), null);
            RubyDir.checkDirIsTwoSlashesOnWindows(runtime2, adjustedPath);
            JRubyFile dir = RubyDir.getDir(runtime2, adjustedPath, true);
            String realPath = null;
            String oldCwd = runtime2.getCurrentDirectory();
            try {
                realPath = dir.getCanonicalPath();
            }
            catch (IOException e) {
                realPath = dir.getAbsolutePath();
            }
            result = null;
            if (block.isGiven()) {
                runtime2.setCurrentDirectory(realPath);
                try {
                    result = block.yield(context, path2);
                    Object var12_12 = null;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    dir = RubyDir.getDir(runtime2, oldCwd, true);
                    runtime2.setCurrentDirectory(oldCwd);
                    throw throwable;
                }
                dir = RubyDir.getDir(runtime2, oldCwd, true);
                runtime2.setCurrentDirectory(oldCwd);
                {
                    break block5;
                }
            }
            runtime2.setCurrentDirectory(realPath);
            result = runtime2.newFixnum(0);
        }
        return result;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject recv2, IRubyObject path2) {
        throw recv2.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject rmdir(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdirCommon(recv2.getRuntime(), path2.convertToString().getUnicodeValue());
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rmdir19(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdirCommon(context.getRuntime(), RubyDir.getPath19(context, path2));
    }

    private static IRubyObject rmdirCommon(Ruby runtime2, String path2) {
        JRubyFile directory = RubyDir.getDir(runtime2, path2, true);
        if (!directory.delete()) {
            throw runtime2.newSystemCallError("No such directory");
        }
        return runtime2.newFixnum(0);
    }

    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject _path, Block block) {
        RubyString pathString = _path.convertToString();
        return RubyDir.foreachCommon(context, recv2, context.getRuntime(), pathString, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        RubyString pathString = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.callMethod(context, "to_path").convertToString();
        return RubyDir.foreachCommon(context, recv2, context.getRuntime(), pathString, block);
    }

    private static IRubyObject foreachCommon(ThreadContext context, IRubyObject recv2, Ruby runtime2, RubyString _path, Block block) {
        if (block.isGiven()) {
            runtime2.checkSafeString(_path);
            RubyClass dirClass = runtime2.getDir();
            RubyDir dir = (RubyDir)dirClass.newInstance(context, new IRubyObject[]{_path}, block);
            dir.each(context, block);
            return runtime2.getNil();
        }
        return RubyEnumerator.enumeratorize(runtime2, recv2, "foreach", _path);
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject recv2) {
        Ruby ruby2 = recv2.getRuntime();
        RubyString pwd = RubyString.newUnicodeString(ruby2, RubyDir.getCWD(ruby2));
        pwd.setTaint(true);
        return pwd;
    }

    @JRubyMethod(name={"home"}, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject home(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length > 0) {
            return RubyDir.getHomeDirectoryPath(context, args2[0].toString());
        }
        return RubyDir.getHomeDirectoryPath(context);
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject mkdir(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = recv2.getRuntime();
        RubyString stringArg = args2[0].convertToString();
        runtime2.checkSafeString(stringArg);
        return RubyDir.mkdirCommon(runtime2, stringArg.getUnicodeValue(), args2);
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject mkdir19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyDir.mkdirCommon(context.getRuntime(), RubyDir.getPath19(context, args2[0]), args2);
    }

    private static IRubyObject mkdirCommon(Ruby runtime2, String path2, IRubyObject[] args2) {
        int mode2;
        File newDir = RubyDir.getDir(runtime2, path2, false);
        if (File.separatorChar == '\\') {
            newDir = new File(newDir.getPath());
        }
        int n = mode2 = args2.length == 2 ? (int)args2[1].convertToInteger().getLongValue() : 511;
        if (runtime2.getPosix().mkdir(newDir.getAbsolutePath(), mode2) < 0) {
            throw runtime2.newSystemCallError("mkdir failed");
        }
        return RubyFixnum.zero(runtime2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        IRubyObject iRubyObject;
        RubyDir directory = (RubyDir)context.getRuntime().getDir().newInstance(context, new IRubyObject[]{path2}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            iRubyObject = block.yield(context, directory);
            Object var7_6 = null;
            directory.close();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            directory.close();
            throw throwable;
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"open"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        RubyString pathString = path2 instanceof RubyString ? (RubyString)path2 : path2.callMethod(context, "to_path").convertToString();
        return RubyDir.open(context, recv2, pathString, block);
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.checkDir();
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    public IRubyObject each(ThreadContext context, Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        this.pos = 0;
        while (this.pos < contents.length) {
            block.yield(context, this.getRuntime().newString(contents[this.pos]));
            ++this.pos;
        }
        return this;
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each");
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":").append(this.path.asJavaString()).append(">");
        return runtime2.newString(part.toString());
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject newPos) {
        this.checkDir();
        this.set_pos(newPos);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject newPos) {
        this.pos = RubyNumeric.fix2int(newPos);
        return newPos;
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path(ThreadContext context) {
        return this.path.strDup(context.getRuntime());
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.checkDir();
        this.pos = 0;
        return this;
    }

    @JRubyMethod(name={"exists?", "exist?"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject exist(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        try {
            return context.getRuntime().newFileStat(RubyDir.getPath19(context, arg2), false).directory_p();
        }
        catch (Exception e) {
            return context.getRuntime().newBoolean(false);
        }
    }

    protected static String getPath19(ThreadContext context, IRubyObject arg2) {
        RubyString pathObject = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.callMethod(context, "to_path").convertToString();
        return pathObject.getUnicodeValue();
    }

    protected static JRubyFile getDir(Ruby runtime2, String path2, boolean mustExist) {
        String dir = path2;
        String[] pathParts = RubyFile.splitURI(path2);
        if (pathParts != null) {
            if (pathParts[0].equals("file:") && pathParts[1].length() > 0 && pathParts[1].indexOf("!/") == -1) {
                dir = pathParts[1];
            } else {
                throw runtime2.newErrnoENOTDIRError(dir + " is not a directory");
            }
        }
        JRubyFile result = JRubyFile.create(runtime2.getCurrentDirectory(), dir);
        if (mustExist && !result.exists()) {
            throw runtime2.newErrnoENOENTError("No such file or directory - " + dir);
        }
        boolean isDirectory = result.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime2.newErrnoENOTDIRError(path2 + " is not a directory");
        }
        if (!mustExist && isDirectory) {
            throw runtime2.newErrnoEEXISTError("File exists - " + dir);
        }
        return result;
    }

    protected static List<String> getContents(File directory) {
        String[] contents = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        if (contents != null) {
            for (int i2 = 0; i2 < contents.length; ++i2) {
                result.add(contents[i2]);
            }
        }
        return result;
    }

    protected static List<RubyString> getContents(File directory, Ruby runtime2) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        for (int i2 = 0; i2 < contents.length; ++i2) {
            result.add(runtime2.newString(contents[i2]));
        }
        return result;
    }

    public static IRubyObject getHomeDirectoryPath(ThreadContext context, String user) {
        Ruby runtime2 = context.getRuntime();
        try {
            return runtime2.newString(runtime2.getPosix().getpwnam(user).getHome());
        }
        catch (Exception e) {
            String passwd2 = null;
            try {
                FileInputStream stream = new FileInputStream("/etc/passwd");
                int totalBytes = stream.available();
                byte[] bytes2 = new byte[totalBytes];
                stream.read(bytes2);
                stream.close();
                passwd2 = new String(bytes2);
            }
            catch (IOException ioe) {
                return runtime2.getNil();
            }
            String[] rows = passwd2.split("\n");
            int rowCount = rows.length;
            for (int i2 = 0; i2 < rowCount; ++i2) {
                String[] fields2 = rows[i2].split(":");
                if (!fields2[0].equals(user)) continue;
                return runtime2.newString(fields2[5]);
            }
            throw runtime2.newArgumentError("user " + user + " doesn't exist");
        }
    }

    public static RubyString getHomeDirectoryPath(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyHash systemHash = (RubyHash)runtime2.getObject().fastGetConstant("ENV_JAVA");
        RubyHash envHash = (RubyHash)runtime2.getObject().fastGetConstant("ENV");
        IRubyObject home2 = envHash.op_aref(context, runtime2.newString("HOME"));
        if (home2 == null || home2.isNil()) {
            home2 = systemHash.op_aref(context, runtime2.newString("user.home"));
        }
        if (home2 == null || home2.isNil()) {
            home2 = envHash.op_aref(context, runtime2.newString("LOGDIR"));
        }
        if (home2 == null || home2.isNil()) {
            throw runtime2.newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home2;
    }
}

