/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Properties;

final class Init {
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", Foreign.VERSION_MAJOR, Foreign.VERSION_MINOR);
    private static volatile boolean loaded = false;

    private Init() {
    }

    static final void load() {
        if (loaded) {
            return;
        }
        String libName = Init.getStubLibraryName();
        String bootPath = Init.getBootPath();
        if (bootPath != null && Init.loadFromBootPath(libName, bootPath)) {
            return;
        }
        try {
            System.loadLibrary(libName);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Init.loadFromJar();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getBootPath() {
        String bootPath = System.getProperty(bootLibraryPropertyName);
        if (bootPath != null) {
            return bootPath;
        }
        InputStream is = Init.class.getResourceAsStream(bootPropertyFilename);
        if (is != null) {
            Properties p2 = new Properties();
            try {
                p2.load(is);
                String string2 = p2.getProperty(bootLibraryPropertyName);
                return string2;
            }
            catch (IOException ex) {
                try {
                    is.close();
                }
                catch (IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }

    private static final boolean loadFromBootPath(String libName, String bootPath) {
        String[] dirs = bootPath.split(File.pathSeparator);
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            String path2 = new File(new File(dirs[i2]), System.mapLibraryName(libName)).getAbsolutePath();
            try {
                System.load(path2);
                return true;
            }
            catch (UnsatisfiedLinkError ex) {
                String ext2;
                String orig;
                if (Platform.getPlatform().getOS() != Platform.OS.DARWIN) continue;
                if (path2.endsWith("dylib")) {
                    orig = "dylib";
                    ext2 = "jnilib";
                } else {
                    orig = "jnilib";
                    ext2 = "dylib";
                }
                try {
                    System.load(path2.substring(0, path2.lastIndexOf(orig)) + ext2);
                    return true;
                }
                catch (UnsatisfiedLinkError ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    private static final void loadFromJar() {
        InputStream is = Init.getStubLibraryStream();
        File dstFile = null;
        FileOutputStream os = null;
        try {
            dstFile = File.createTempFile("jffi", null);
            dstFile.deleteOnExit();
            os = new FileOutputStream(dstFile);
            ReadableByteChannel srcChannel = Channels.newChannel(is);
            long pos2 = 0L;
            while (is.available() > 0) {
                pos2 += os.getChannel().transferFrom(srcChannel, pos2, Math.max(4096, is.available()));
            }
        }
        catch (IOException ex) {
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        System.load(dstFile.getAbsolutePath());
    }

    private static final InputStream getStubLibraryStream() {
        Object[] paths;
        String stubPath = Init.getStubLibraryPath();
        ClassLoader cl = Init.class.getClassLoader();
        InputStream is = null;
        for (String string2 : paths = new String[]{stubPath, "/" + stubPath}) {
            is = cl.getResourceAsStream(string2);
            if (is == null && Platform.getPlatform().getOS() == Platform.OS.DARWIN) {
                is = cl.getResourceAsStream(string2.replaceAll("dylib", "jnilib"));
            }
            if (is != null) break;
        }
        if (is == null) {
            throw new UnsatisfiedLinkError("Could not locate stub library in jar file.  Tried " + Arrays.deepToString(paths));
        }
        return is;
    }

    private static final String getStubLibraryName() {
        return stubLibraryName;
    }

    private static final String getStubLibraryPath() {
        return "jni/" + Platform.getPlatform().getName() + "/" + System.mapLibraryName(stubLibraryName);
    }
}

