/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.CopyInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.JumpInstr;
import org.jruby.compiler.ir.instructions.TwoOperandInstr;
import org.jruby.compiler.ir.operands.ArgIndex;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveOptionalArgumentInstr
extends TwoOperandInstr {
    public ReceiveOptionalArgumentInstr(Variable dest, int index2, Label nullLabel) {
        super(Operation.RECV_OPT_ARG, dest, new ArgIndex(index2), nullLabel);
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        Operand callArg = ii.getCallArg(((ArgIndex)this.operand1).index);
        if (callArg == null) {
            return new JumpInstr(ii.getRenamedLabel((Label)this.operand2));
        }
        return new CopyInstr(ii.getRenamedVariable(this.result), callArg);
    }

    public Label interpret(InterpreterContext interp, IRubyObject self) {
        Object value2;
        int index2 = ((ArgIndex)this.getOperand1()).getIndex();
        Object object = value2 = interp.getParameterCount() > index2 - 1 ? interp.getParameter(index2) : null;
        if (value2 != null) {
            this.getResult().store(interp, value2);
            return (Label)this.getOperand2();
        }
        return null;
    }
}

