/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Arrays;
import java.util.Map;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiOperandInstr
extends Instr {
    public Operand[] _args;
    private boolean constArgs = false;
    private IRubyObject[] preparedArgs = null;

    public MultiOperandInstr(Operation opType, Variable result, Operand[] args2) {
        super(opType, result);
        this._args = args2;
    }

    @Override
    public String toString() {
        return super.toString() + Arrays.toString(this._args);
    }

    @Override
    public Operand[] getOperands() {
        return this._args;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        for (int i = 0; i < this._args.length; ++i) {
            this._args[i] = this._args[i].getSimplifiedOperand(valueMap);
        }
    }

    public Operand[] cloneOperandsForInlining(InlinerInfo ii) {
        Operand[] newArgs = new Operand[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            newArgs[i] = this._args[i].cloneForInlining(ii);
        }
        return newArgs;
    }

    protected IRubyObject[] prepareArguments(Operand[] args2, InterpreterContext interp) {
        int i;
        if (this.preparedArgs == null) {
            this.preparedArgs = new IRubyObject[args2.length];
            this.constArgs = true;
            for (i = 0; i < args2.length; ++i) {
                if (!args2[i].isConstant()) {
                    this.constArgs = false;
                    break;
                }
                this.preparedArgs[i] = (IRubyObject)args2[i].retrieve(interp);
            }
        }
        if (!this.constArgs) {
            for (i = 0; i < args2.length; ++i) {
                this.preparedArgs[i] = (IRubyObject)args2[i].retrieve(interp);
            }
        }
        return this.preparedArgs;
    }
}

