/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import com.kenai.jffi.Library;
import com.kenai.jffi.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.jruby.Ruby;
import org.jruby.cext.GC;
import org.jruby.cext.Handle;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class Native {
    private static Native INSTANCE;
    private static Library shim;
    private static final String libName = "jruby-cext";
    private static final String jrubyHome;
    private final Ruby runtime;

    static Native getInstance(Ruby runtime2) {
        if (INSTANCE == null) {
            INSTANCE = new Native(runtime2);
            INSTANCE.load(runtime2);
            GC.init(INSTANCE);
        } else if (Native.INSTANCE.runtime != runtime2) {
            throw runtime2.newRuntimeError("invalid runtime");
        }
        return INSTANCE;
    }

    private Native(Ruby runtime2) {
        this.runtime = runtime2;
    }

    private void load(Ruby runtime2) {
        if (shim != null) {
            return;
        }
        shim = Library.openLibrary(System.mapLibraryName(libName), 10);
        if (shim == null) {
            File libFile = this.loadFromJrubyHome();
            if (libFile != null) {
                shim = Library.openLibrary(libFile.getAbsolutePath(), 10);
            }
            if (shim == null) {
                throw new UnsatisfiedLinkError("failed to load shim library, error: " + Library.getLastError());
            }
            System.load(libFile.getAbsolutePath());
        } else {
            System.loadLibrary(libName);
        }
        GC.register(runtime2.getFalse(), Handle.newHandle(runtime2, runtime2.getFalse(), this.getFalse()));
        GC.register(runtime2.getTrue(), Handle.newHandle(runtime2, runtime2.getTrue(), this.getTrue()));
        GC.register(runtime2.getNil(), Handle.newHandle(runtime2, runtime2.getNil(), this.getNil()));
        this.initNative(runtime2);
    }

    private File loadFromJrubyHome() {
        URL fileUrl = Native.class.getResource(Native.getCextLibraryPath());
        if (fileUrl == null) {
            return new File(jrubyHome + Native.getCextLibraryPath());
        }
        if (fileUrl.getProtocol().equals("file")) {
            try {
                return new File(fileUrl.toURI());
            }
            catch (URISyntaxException e) {
                return new File(fileUrl.getPath());
            }
        }
        if (fileUrl.getProtocol().equals("jar")) {
            return this.loadFromJar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File loadFromJar() {
        InputStream is = Native.getCextLibraryStream();
        File dstFile = null;
        FileOutputStream os = null;
        try {
            try {
                dstFile = File.createTempFile(libName, null);
                dstFile.deleteOnExit();
                os = new FileOutputStream(dstFile);
                ReadableByteChannel srcChannel = Channels.newChannel(is);
                long pos2 = 0L;
                while (is.available() > 0) {
                    pos2 += os.getChannel().transferFrom(srcChannel, pos2, Math.max(4096, is.available()));
                }
                Object var8_7 = null;
            }
            catch (IOException ex) {
                throw new UnsatisfiedLinkError(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (os != null) {
                    os.close();
                }
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (os != null) {
            os.close();
        }
        is.close();
        return dstFile;
    }

    private static final InputStream getCextLibraryStream() {
        String path2 = Native.getCextLibraryPath();
        InputStream is = Native.class.getResourceAsStream(path2);
        if (is == null) {
            throw new UnsatisfiedLinkError("Could not locate jruby-cext (" + path2 + ") in jar file");
        }
        return is;
    }

    private static final String getCextLibraryPath() {
        String prefix = Platform.getPlatform().getName() + "/";
        prefix = jrubyHome.startsWith("file:") ? jrubyHome.substring(jrubyHome.indexOf("jar!") + "jar!".length()) + prefix : "/lib/native/" + prefix;
        return prefix + System.mapLibraryName(libName);
    }

    public final IRubyObject callMethod(ThreadContext ctx, long fn, IRubyObject recv2, int arity2, IRubyObject[] args2) {
        long[] largs = new long[args2.length];
        for (int i = 0; i < largs.length; ++i) {
            largs[i] = Handle.nativeHandle(args2[i]);
        }
        return this.callMethod(ctx, fn, Handle.nativeHandle(recv2), arity2, largs);
    }

    public final native long callInit(ThreadContext var1, long var2);

    private final native void initNative(Ruby var1);

    final native IRubyObject callMethod(ThreadContext var1, long var2, long var4, int var6, long[] var7);

    final native IRubyObject callMethod0(long var1, long var3);

    final native IRubyObject callMethod1(long var1, long var3, long var5);

    final native IRubyObject callMethod2(long var1, long var3, long var5, long var7);

    final native IRubyObject callMethod3(long var1, long var3, long var5, long var7, long var9);

    final native long callFunction(long var1, long var3);

    final native IRubyObject callProcMethod(long var1, long var3);

    final native long newHandle(IRubyObject var1, int var2);

    final native long newFixnumHandle(IRubyObject var1, long var2);

    final native long newFloatHandle(IRubyObject var1, double var2);

    final native long newIOHandle(IRubyObject var1, int var2, int var3);

    final native void gc();

    final native Object pollGC();

    final native long getNil();

    final native long getTrue();

    final native long getFalse();

    static native void freeHandle(long var0);

    static native long newRString();

    static native void freeRString(long var0);

    static native long newRArray();

    static native void freeRArray(long var0);

    static {
        shim = null;
        jrubyHome = Ruby.getGlobalRuntime().getJRubyHome();
    }
}

