/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import org.jruby.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation {
    private final int methodSerialNumber;
    private final int recursiveDepth;
    private final Invocation parent;
    private final IntHashMap<Invocation> children = new IntHashMap();
    private long duration = 0L;
    private int count = 0;

    public Invocation(int serial) {
        this(null, serial, 1);
    }

    public Invocation(Invocation parent, int serial, int recursiveDepth) {
        this.parent = parent;
        this.methodSerialNumber = serial;
        this.recursiveDepth = recursiveDepth;
    }

    public int getMethodSerialNumber() {
        return this.methodSerialNumber;
    }

    public int getRecursiveDepth() {
        return this.recursiveDepth;
    }

    public Invocation getParent() {
        return this.parent;
    }

    public IntHashMap<Invocation> getChildren() {
        return this.children;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long d) {
        this.duration = d;
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void addDuration(long d) {
        this.duration += d;
    }

    public Invocation childInvocationFor(int serial, int recursiveDepth) {
        Invocation child = this.children.get(serial);
        if (child == null) {
            child = new Invocation(this, serial, recursiveDepth);
            this.children.put(serial, child);
        }
        return child;
    }

    public long childTime() {
        long t = 0L;
        for (Invocation inv : this.children.values()) {
            t += inv.duration;
        }
        return t;
    }

    public long selfTime() {
        return this.duration - this.childTime();
    }
}

