/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.exceptions.JumpException;
import org.jruby.interpreter.Interpreter;
import org.jruby.interpreter.NaiveInterpreterContext;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRBlockBody
extends ContextAwareBlockBody {
    private final IRClosure closure;
    private final boolean hasMultipleArgsHead;

    public InterpretedIRBlockBody(IRClosure closure, Arity arity2, int argumentType) {
        super(closure.getStaticScope(), arity2, argumentType);
        this.closure = closure;
        this.hasMultipleArgsHead = false;
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{value2}, binding2, type2);
    }

    private IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        IRubyObject self = context.getFrameSelf();
        if (this.scope.getNumberOfVariables() > 1 && args2.length == 1 && args2[0] instanceof RubyArray) {
            int i;
            System.out.println("ARRAY to multi");
            RubyArray array = (RubyArray)args2[0];
            int size2 = array.getLength();
            System.out.println("Creating n variables: " + this.scope.getNumberOfVariables());
            args2 = new IRubyObject[this.scope.getNumberOfVariables()];
            for (i = 0; i < this.scope.getNumberOfVariables() && i < size2; ++i) {
                args2[i] = array.eltInternal(i);
            }
            while (i < size2) {
                args2[i] = context.getRuntime().getNil();
                ++i;
            }
        }
        NaiveInterpreterContext interp = new NaiveInterpreterContext(context, self, this.closure.getLocalVariablesCount(), this.closure.getTemporaryVariableSize(), this.closure.getRenamedVariableSize(), args2, Block.NULL_BLOCK);
        interp.setDynamicScope(binding2.getDynamicScope());
        return Interpreter.interpret(context, this.closure.getCFG(), interp);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        if (self == null) {
            self = value2;
        }
        IRubyObject[] args2 = new IRubyObject[]{value2};
        NaiveInterpreterContext interp = new NaiveInterpreterContext(context, self, this.closure.getLocalVariablesCount(), this.closure.getTemporaryVariableSize(), this.closure.getRenamedVariableSize(), args2, Block.NULL_BLOCK);
        interp.setDynamicScope(binding2.getDynamicScope());
        return Interpreter.interpret(context, this.closure.getCFG(), interp);
    }

    private IRubyObject handleNextJump(ThreadContext context, JumpException.NextJump nj, Block.Type type2) {
        return nj.getValue() == null ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
    }

    protected IRubyObject setupBlockArgs(ThreadContext context, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return value2;
            }
        }
        return this.defaultArgsLogic(context.getRuntime(), value2);
    }

    private IRubyObject defaultArgsLogic(Ruby ruby2, IRubyObject value2) {
        int length2 = ArgsUtil.arrayLength(value2);
        switch (length2) {
            case 0: {
                return ruby2.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby2, length2);
        return value2;
    }

    private IRubyObject warnMultiReturnNil(Ruby ruby2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
        return ruby2.getNil();
    }

    private void blockArgWarning(Ruby ruby2, int length2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)", new Object[0]);
    }

    protected IRubyObject setupBlockArg(Ruby ruby2, IRubyObject value2, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return null;
            }
            case 1: 
            case 3: {
                return ArgsUtil.convertToRubyArray(ruby2, value2, this.hasMultipleArgsHead);
            }
        }
        return this.defaultArgLogic(ruby2, value2);
    }

    private IRubyObject defaultArgLogic(Ruby ruby2, IRubyObject value2) {
        if (value2 == null) {
            return this.warnMultiReturnNil(ruby2);
        }
        return value2;
    }

    public String getFile() {
        return "(unknown)";
    }

    public int getLine() {
        return -1;
    }
}

