/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ASTInspector;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedMethod
extends DynamicMethod
implements MethodArgs,
PositionAware {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private ISourcePosition position;
    private boolean needsScope;

    public InterpretedMethod(RubyModule implementationClass, StaticScope staticScope, Node body, String name2, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull, name2);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.position = position;
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(body);
        inspector.inspect(argsNode);
        this.needsScope = true;
        assert (argsNode != null);
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, args2.length);
                this.argsNode.prepare(context, runtime2, self, args2, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var12_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var12_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var12_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var12_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 0);
                this.argsNode.prepare(context, runtime2, self, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var10_11 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var10_12 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var10_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var10_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 0);
                this.argsNode.prepare(context, runtime2, self, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var11_12 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var11_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var11_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var11_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 1);
                this.argsNode.prepare(context, runtime2, self, arg0, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var11_12 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var11_13 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var11_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var11_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 1);
                this.argsNode.prepare(context, runtime2, self, arg0, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var12_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var12_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var12_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var12_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 2);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var12_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var12_14 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var12_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var12_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 2);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var13_14 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var13_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var13_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var13_17 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 3);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var13_14 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var13_15 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var13_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var13_17 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 3);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var14_15 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var14_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var14_17 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var14_18 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 4);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var14_15 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var14_16 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var14_17 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var14_18 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 4);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var15_16 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var15_17 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var15_18 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var15_19 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 5);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var15_16 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var15_17 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var15_18 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var15_19 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 5);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var16_17 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var16_18 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var16_19 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var16_20 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 6);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var16_17 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var16_18 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var16_19 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var16_20 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 6);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var17_18 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var17_19 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var17_20 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var17_21 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 7);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var17_18 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var17_19 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var17_20 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var17_21 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 7);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var18_19 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var18_20 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var18_21 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var18_22 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 8);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var18_19 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var18_20 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var18_21 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var18_22 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 8);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var19_20 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var19_21 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var19_22 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var19_23 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 9);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var19_20 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var19_21 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var19_22 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var19_23 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 9);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var20_21 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var20_22 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var20_23 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var20_24 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
                this.argsNode.checkArgCount(runtime2, 10);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK);
                Object var20_21 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var20_22 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var20_23 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var20_24 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9, Block block) {
        Ruby runtime2 = context.getRuntime();
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime2);
                this.argsNode.checkArgCount(runtime2, 10);
                this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime2, context, this.position, this.getImplementationClass(), this.body, name2, self, block);
                Object var21_22 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var21_23 = null;
                this.post(runtime2, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime2);
                Object var21_24 = null;
                this.post(runtime2, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime2, bj, callNumber);
                Object var21_25 = null;
                this.post(runtime2, context, name2);
                return iRubyObject4;
            }
            this.post(runtime2, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            this.post(runtime2, context, name2);
            throw throwable;
        }
    }

    protected void pre(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime2) {
        if (this.needsScope) {
            context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        } else {
            context.preMethodFrameAndDummyScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        }
    }

    protected void post(Ruby runtime2, ThreadContext context, String name2) {
        context.postMethodFrameAndScope();
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public int getLine() {
        return this.position.getLine();
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new InterpretedMethod(this.getImplementationClass(), this.staticScope, this.body, this.name, this.argsNode, this.getVisibility(), this.position);
    }
}

