/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.FFIUtil;

class NativeMemoryIO
implements MemoryIO,
DirectMemoryIO {
    protected static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
    final NativeMemoryIO parent;
    final long address;
    private final Ruby runtime;

    static final DirectMemoryIO wrap(Ruby runtime2, long address2) {
        return address2 != 0L ? new NativeMemoryIO(runtime2, address2) : new NullMemoryIO(runtime2);
    }

    NativeMemoryIO(Ruby runtime2, long address2) {
        this.runtime = runtime2;
        this.address = address2;
        this.parent = null;
    }

    private NativeMemoryIO(NativeMemoryIO parent, long offset2) {
        this.parent = parent;
        this.address = parent.address + offset2;
        this.runtime = parent.runtime;
    }

    public final long getAddress() {
        return this.address;
    }

    public NativeMemoryIO slice(long offset2) {
        return offset2 == 0L ? this : new NativeMemoryIO(this, offset2);
    }

    public DirectMemoryIO slice(long offset2, long size2) {
        return new BoundedNativeMemoryIO(this.runtime, this, offset2, size2);
    }

    public final ByteBuffer asByteBuffer() {
        return IO.newDirectByteBuffer(this.address, Integer.MAX_VALUE);
    }

    public final boolean equals(Object obj) {
        return obj instanceof DirectMemoryIO && ((DirectMemoryIO)obj).getAddress() == this.address;
    }

    public final int hashCode() {
        int hash2 = 5;
        hash2 = 53 * hash2 + (int)(this.address ^ this.address >>> 32);
        return hash2;
    }

    public final boolean isNull() {
        return this.address == 0L;
    }

    public final boolean isDirect() {
        return true;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public final byte getByte(long offset2) {
        return IO.getByte(this.address + offset2);
    }

    public final short getShort(long offset2) {
        return IO.getShort(this.address + offset2);
    }

    public final int getInt(long offset2) {
        return IO.getInt(this.address + offset2);
    }

    public final long getLong(long offset2) {
        return IO.getLong(this.address + offset2);
    }

    public final long getNativeLong(long offset2) {
        return Platform.getPlatform().longSize() == 32 ? (long)IO.getInt(this.address + offset2) : IO.getLong(this.address + offset2);
    }

    public final float getFloat(long offset2) {
        return IO.getFloat(this.address + offset2);
    }

    public final double getDouble(long offset2) {
        return IO.getDouble(this.address + offset2);
    }

    public final long getAddress(long offset2) {
        return IO.getAddress(this.address + offset2);
    }

    public final DirectMemoryIO getMemoryIO(long offset2) {
        return NativeMemoryIO.wrap(this.runtime, IO.getAddress(this.address + offset2));
    }

    public final void putByte(long offset2, byte value2) {
        IO.putByte(this.address + offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        IO.putShort(this.address + offset2, value2);
    }

    public final void putInt(long offset2, int value2) {
        IO.putInt(this.address + offset2, value2);
    }

    public final void putLong(long offset2, long value2) {
        IO.putLong(this.address + offset2, value2);
    }

    public final void putNativeLong(long offset2, long value2) {
        if (Platform.getPlatform().longSize() == 32) {
            IO.putInt(this.address + offset2, (int)value2);
        } else {
            IO.putLong(this.address + offset2, value2);
        }
    }

    public final void putAddress(long offset2, long value2) {
        IO.putAddress(this.address + offset2, value2);
    }

    public final void putFloat(long offset2, float value2) {
        IO.putFloat(this.address + offset2, value2);
    }

    public final void putDouble(long offset2, double value2) {
        IO.putDouble(this.address + offset2, value2);
    }

    public final void putMemoryIO(long offset2, MemoryIO value2) {
        IO.putAddress(this.address + offset2, ((DirectMemoryIO)value2).getAddress());
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        IO.getByteArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] src, int off, int len) {
        IO.putByteArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        IO.getShortArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, short[] src, int off, int len) {
        IO.putShortArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        IO.getIntArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, int[] src, int off, int len) {
        IO.putIntArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        IO.getLongArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, long[] src, int off, int len) {
        IO.putLongArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        IO.getFloatArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, float[] src, int off, int len) {
        IO.putFloatArray(this.address + offset2, src, off, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        IO.getDoubleArray(this.address + offset2, dst, off, len);
    }

    public final void put(long offset2, double[] src, int off, int len) {
        IO.putDoubleArray(this.address + offset2, src, off, len);
    }

    public final int indexOf(long offset2, byte value2) {
        return value2 == 0 ? (int)IO.getStringLength(this.address + offset2) : (int)IO.indexOf(this.address + offset2, value2);
    }

    public final int indexOf(long offset2, byte value2, int maxlen) {
        return (int)IO.indexOf(this.address, value2, maxlen);
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        IO.setMemory(this.address + offset2, size2, value2);
    }

    public final byte[] getZeroTerminatedByteArray(long offset2) {
        return FFIUtil.getZeroTerminatedByteArray(this.address + offset2);
    }

    public final byte[] getZeroTerminatedByteArray(long offset2, int maxlen) {
        return FFIUtil.getZeroTerminatedByteArray(this.address + offset2, maxlen);
    }

    public void putZeroTerminatedByteArray(long offset2, byte[] bytes2, int off, int len) {
        FFIUtil.putZeroTerminatedByteArray(this.address + offset2, bytes2, off, len);
    }
}

