/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jruby.RubyNil;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyContext;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.jsr223.Utils;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyCompiledScript
extends CompiledScript {
    private ScriptingContainer container;
    private JRubyEngine engine;
    private final EmbedEvalUnit unit;

    JRubyCompiledScript(ScriptingContainer container, JRubyEngine engine, String script) {
        this.container = container;
        this.engine = engine;
        Utils.preEval(container, (JRubyContext)engine.getContext());
        this.unit = container.parse(script, new int[0]);
    }

    JRubyCompiledScript(ScriptingContainer container, JRubyEngine engine, Reader reader) {
        this.container = container;
        this.engine = engine;
        String filename2 = System.getProperty("javax.script.filename");
        Utils.preEval(container, (JRubyContext)engine.getContext());
        this.unit = container.parse(reader, filename2, Utils.getLineNumber(engine.getContext()));
    }

    public Object eval(Bindings bindings) throws ScriptException {
        if (bindings == null) {
            throw new NullPointerException("bindings is null");
        }
        JRubyContext context = this.engine.getScriptContext(bindings);
        return this.eval(context);
    }

    public Object eval(ScriptContext context) throws ScriptException {
        Object var4_6;
        JRubyContext tmpContext;
        block10: {
            tmpContext = JRubyContext.convert(this.container, context);
            Utils.preEval(this.container, tmpContext);
            IRubyObject ret = this.unit.run();
            if (ret instanceof RubyNil) break block10;
            Object object = JavaEmbedUtils.rubyToJava(ret);
            Object var6_7 = null;
            if (Utils.isTerminationOn(tmpContext)) {
                this.container.terminate();
            }
            Utils.postEval(this.container, tmpContext);
            if (tmpContext != context) {
                JRubyContext.update(tmpContext, context);
            }
            return object;
        }
        try {
            var4_6 = null;
            Object var6_8 = null;
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                block11: {
                    Object var6_9 = null;
                    if (Utils.isTerminationOn(tmpContext)) {
                        this.container.terminate();
                    }
                    Utils.postEval(this.container, tmpContext);
                    if (tmpContext == context) break block11;
                    JRubyContext.update(tmpContext, context);
                }
                throw throwable;
            }
        }
        if (Utils.isTerminationOn(tmpContext)) {
            this.container.terminate();
        }
        Utils.postEval(this.container, tmpContext);
        if (tmpContext != context) {
            JRubyContext.update(tmpContext, context);
        }
        return var4_6;
    }

    private ScriptException wrapException(Exception e) throws ScriptException {
        Writer w = this.container.getErrorWriter();
        if (w instanceof PrintWriter) {
            e.printStackTrace((PrintWriter)w);
        } else {
            try {
                w.write(e.getMessage());
            }
            catch (IOException ex) {
                return new ScriptException(ex);
            }
        }
        if (e.getCause() instanceof Exception) {
            return new ScriptException((Exception)e.getCause());
        }
        return new ScriptException(e);
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }
}

