/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTInspector;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.EvalStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyRuntimeAdapterImpl
implements EmbedRubyRuntimeAdapter {
    private RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
    private ScriptingContainer container;

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    public EmbedEvalUnit parse(String script, int ... lines2) {
        if (script == null) {
            return null;
        }
        boolean unicode_escape = false;
        Object obj = this.container.getAttribute((Object)AttributeName.UNICODE_ESCAPE);
        if (obj != null && obj instanceof Boolean) {
            unicode_escape = (Boolean)obj;
        }
        if (unicode_escape) {
            ReaderInputStream istream = new ReaderInputStream(new StringReader(script));
            return this.runParser(istream, null, lines2);
        }
        return this.runParser(script, null, lines2);
    }

    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        if (reader != null) {
            ReaderInputStream istream = new ReaderInputStream(reader);
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        Object basedir;
        if (filename2 == null) {
            return null;
        }
        if (type2 == null) {
            type2 = PathType.ABSOLUTE;
        }
        InputStream istream = null;
        try {
            try {
                switch (type2) {
                    case ABSOLUTE: {
                        istream = new FileInputStream(filename2);
                        break;
                    }
                    case RELATIVE: {
                        basedir = (String)this.container.getAttribute((Object)AttributeName.BASE_DIR);
                        if (basedir == null) {
                            basedir = SystemPropertyCatcher.getBaseDir();
                        }
                        String absolutePath = (String)basedir + File.separator + filename2;
                        istream = new FileInputStream(absolutePath);
                        break;
                    }
                    case CLASSPATH: {
                        istream = this.container.getProvider().getRuntime().getJRubyClassLoader().getResourceAsStream(filename2);
                        break;
                    }
                }
                basedir = this.parse(istream, filename2, lines2);
                Object var9_9 = null;
                if (istream == null) return basedir;
            }
            catch (FileNotFoundException e) {
                Writer w = this.container.getErrorWriter();
                if (w instanceof PrintWriter) {
                    e.printStackTrace((PrintWriter)w);
                    throw new ParseFailedException(e);
                }
                try {
                    w.write(e.getMessage());
                    throw new ParseFailedException(e);
                }
                catch (IOException ex) {
                    throw new ParseFailedException(ex);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return basedir;
        }
        istream.close();
        return basedir;
    }

    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        if (istream != null) {
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EmbedEvalUnit runParser(Object input, String filename2, int ... lines2) {
        EmbedEvalUnitImpl embedEvalUnitImpl;
        block22: {
            EmbedEvalUnitImpl embedEvalUnitImpl2;
            block21: {
                EmbedEvalUnitImpl embedEvalUnitImpl3;
                block20: {
                    if (input == null) {
                        return null;
                    }
                    if (filename2 == null || filename2.length() == 0) {
                        filename2 = this.container.getScriptFilename();
                    }
                    Ruby runtime2 = this.container.getProvider().getRuntime();
                    ValueAccessor d = new ValueAccessor(RubyString.newString(runtime2, filename2));
                    runtime2.getGlobalVariables().define("$PROGRAM_NAME", d);
                    runtime2.getGlobalVariables().define("$0", d);
                    int line = 0;
                    if (lines2 != null && lines2.length > 0) {
                        line = lines2[0];
                    }
                    try {
                        try {
                            ManyVarsDynamicScope scope = null;
                            boolean sharing_variables = true;
                            Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
                            if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                                sharing_variables = false;
                            }
                            if (sharing_variables) {
                                scope = this.getManyVarsDynamicScope(runtime2, 0);
                            }
                            Node node = null;
                            node = input instanceof String ? runtime2.parseEval((String)input, filename2, (DynamicScope)scope, line) : runtime2.parseFile((InputStream)input, filename2, scope, line);
                            RubyInstanceConfig.CompileMode compileMode = runtime2.getInstanceConfig().getCompileMode();
                            if (compileMode == RubyInstanceConfig.CompileMode.FORCE) {
                                ASTInspector inspector = new ASTInspector();
                                inspector.setFlag(32768);
                                Script script = runtime2.tryCompile(node, inspector);
                                if (script != null) {
                                    embedEvalUnitImpl3 = new EmbedEvalUnitImpl(this.container, node, scope, script);
                                    Object var16_21 = null;
                                    break block20;
                                }
                                embedEvalUnitImpl2 = new EmbedEvalUnitImpl(this.container, node, scope);
                                break block21;
                            }
                            embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope);
                            break block22;
                        }
                        catch (RaiseException e) {
                            runtime2.printError(e.getException());
                            throw new ParseFailedException(e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            Writer w = this.container.getErrorWriter();
                            if (w instanceof PrintWriter) {
                                e.printStackTrace((PrintWriter)w);
                                throw new ParseFailedException(e);
                            }
                            try {
                                w.write(e.getMessage());
                                throw new ParseFailedException(e);
                            }
                            catch (IOException ex) {
                                throw new ParseFailedException(ex);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_24 = null;
                        try {
                            if (!(input instanceof InputStream)) throw throwable;
                            ((InputStream)input).close();
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new ParseFailedException(ex);
                        }
                    }
                }
                try {}
                catch (IOException ex) {
                    throw new ParseFailedException(ex);
                }
                if (!(input instanceof InputStream)) return embedEvalUnitImpl3;
                ((InputStream)input).close();
                return embedEvalUnitImpl3;
            }
            Object var16_22 = null;
            try {}
            catch (IOException ex) {
                throw new ParseFailedException(ex);
            }
            if (!(input instanceof InputStream)) return embedEvalUnitImpl2;
            ((InputStream)input).close();
            return embedEvalUnitImpl2;
        }
        Object var16_23 = null;
        try {}
        catch (IOException ex) {
            throw new ParseFailedException(ex);
        }
        if (!(input instanceof InputStream)) return embedEvalUnitImpl;
        ((InputStream)input).close();
        return embedEvalUnitImpl;
    }

    ManyVarsDynamicScope getManyVarsDynamicScope(Ruby runtime2, int depth) {
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        topStaticScope.setModule(runtime2.getObject());
        ManyVarsDynamicScope currentScope = new ManyVarsDynamicScope(topStaticScope, null);
        String[] names4Injection = this.container.getVarMap().getLocalVarNames();
        ManyVarsDynamicScope scope = names4Injection == null || names4Injection.length == 0 ? new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope()), currentScope) : new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope(), names4Injection), currentScope);
        return scope;
    }

    public IRubyObject eval(Ruby runtime2, String script) {
        return this.adapter.eval(runtime2, script);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime2, String script, String filename2, int lineNumber) {
        return this.adapter.parse(runtime2, script, filename2, lineNumber);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime2, InputStream istream, String filename2, int lineNumber) {
        return this.adapter.parse(runtime2, istream, filename2, lineNumber);
    }
}

