/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Interp;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.GetInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LoadFromBindingInstr
extends GetInstr {
    private int bindingSlot;

    public LoadFromBindingInstr(Variable v, IRExecutionScope scope, String slotName) {
        super(Operation.BINDING_LOAD, v, MetaObject.create(scope.getClosestMethodAncestor()), slotName);
        MetaObject mo = (MetaObject)this.getSource();
        IRMethod m = (IRMethod)mo.scope;
        this.bindingSlot = m.assignBindingSlot(slotName);
    }

    public String toString() {
        return "\t" + this.result + " = BINDING(" + this.getSource() + ")." + this.getName();
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new LoadFromBindingInstr(ii.getRenamedVariable(this.result), (IRExecutionScope)((MetaObject)this.getSource()).scope, this.getName());
    }

    private IRScope getIRScope(Operand scopeHolder) {
        assert (scopeHolder instanceof MetaObject) : "Target should be a MetaObject";
        return ((MetaObject)scopeHolder).getScope();
    }

    @Interp
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        IRMethod m = (IRMethod)this.getIRScope(this.getSource());
        LocalVariable v = (LocalVariable)this.getResult();
        if (this.bindingSlot == -1) {
            this.bindingSlot = m.getBindingSlot(v.getName());
        }
        interp.setLocalVariable(v.getLocation(), interp.getSharedBindingVariable(this.bindingSlot));
        return null;
    }
}

