/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.MultiOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.MethodHandle;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.StringLiteral;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InlineMethodHint;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallInstr
extends MultiOperandInstr {
    private Operand receiver;
    private Operand[] arguments;
    Operand _methAddr;
    Operand _closure;
    private boolean _flagsComputed;
    private boolean _canBeEval;
    private boolean _requiresBinding;
    public HashMap<DynamicMethod, Integer> _profile;

    public CallInstr(Variable result, Operand methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(Operation.CALL, result, CallInstr.buildAllArgs(methAddr, receiver2, args2, closure));
        this.receiver = receiver2;
        this.arguments = args2;
        this._methAddr = methAddr;
        this._closure = closure;
        this._flagsComputed = false;
        this._canBeEval = true;
        this._requiresBinding = true;
    }

    public CallInstr(Operation op, Variable result, Operand methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(op, result, CallInstr.buildAllArgs(methAddr, receiver2, args2, closure));
        this.receiver = receiver2;
        this.arguments = args2;
        this._methAddr = methAddr;
        this._closure = closure;
        this._flagsComputed = false;
        this._canBeEval = true;
        this._requiresBinding = true;
    }

    public void setMethodAddr(Operand mh) {
        this._methAddr = mh;
    }

    public Operand getMethodAddr() {
        return this._methAddr;
    }

    public Operand getClosureArg() {
        return this._closure;
    }

    public Operand getReceiver() {
        return this.receiver;
    }

    public Operand[] getCallArgs() {
        return this.arguments;
    }

    public Operand[] cloneCallArgs(InlinerInfo ii) {
        int length2 = this.arguments.length;
        Operand[] clonedArgs = new Operand[length2];
        for (int i = 0; i < length2; ++i) {
            clonedArgs[i] = this.arguments[i].cloneForInlining(ii);
        }
        return clonedArgs;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        super.simplifyOperands(valueMap);
        this._methAddr = this._args[0];
        this._closure = this._closure == null ? null : this._args[this._args.length - 1];
        this._flagsComputed = false;
    }

    public boolean isRubyInternalsCall() {
        return false;
    }

    public boolean isStaticCallTarget() {
        return this.getTargetMethod() != null;
    }

    public IRMethod getTargetMethodWithReceiver(Operand receiver2) {
        if (!(this._methAddr instanceof MethAddr)) {
            return null;
        }
        String mname = ((MethAddr)this._methAddr).getName();
        if (receiver2 instanceof MetaObject) {
            IRModule m = (IRModule)((MetaObject)receiver2).scope;
            return m.getClassMethod(mname);
        }
        if (receiver2 instanceof LocalVariable && ((LocalVariable)receiver2).isSelf()) {
            return null;
        }
        IRClass c = receiver2.getTargetClass();
        return c == null ? null : c.getInstanceMethod(mname);
    }

    public IRMethod getTargetMethod() {
        return this.getTargetMethodWithReceiver(this.getReceiver());
    }

    public boolean canModifyCode() {
        IRMethod method2 = this.getTargetMethod();
        return method2 == null ? true : method2.modifiesCode();
    }

    private boolean getEvalFlag() {
        Operand ma = this.getMethodAddr();
        if (ma instanceof MethAddr) {
            Operand[] args2;
            String mname = ((MethAddr)ma).getName();
            if (mname.equals("call") || mname.equals("eval")) {
                return true;
            }
            if (mname.equals("send") && (args2 = this.getCallArgs()).length >= 2) {
                Operand meth = args2[0];
                if (!(meth instanceof StringLiteral)) {
                    return true;
                }
                String name2 = ((StringLiteral)meth)._str_value;
                if (name2.equals("call") || name2.equals("eval") || name2.equals("send")) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean getRequiresBindingFlag() {
        Operand ma;
        if (this.canBeEval()) {
            return true;
        }
        if (this._closure != null) {
            if (!(this._closure instanceof MetaObject)) {
                return false;
            }
            IRClosure cl = (IRClosure)((MetaObject)this._closure).scope;
            if (cl.requiresBinding()) {
                return true;
            }
        }
        if (!((ma = this.getMethodAddr()) instanceof MethAddr)) {
            return true;
        }
        String mname = ((MethAddr)ma).getName();
        if (mname.equals("lambda")) {
            return true;
        }
        if (mname.equals("new")) {
            Operand object = this.getReceiver();
            if (!(object instanceof MetaObject)) {
                return true;
            }
            IRScope c = ((MetaObject)object).scope;
            if (c instanceof IRClass && c.getName().equals("Proc")) {
                return true;
            }
        }
        return false;
    }

    private void computeFlags() {
        this._flagsComputed = true;
        this._canBeEval = this.getEvalFlag();
        this._requiresBinding = this._canBeEval ? true : this.getRequiresBindingFlag();
    }

    public boolean canBeEval() {
        if (!this._flagsComputed) {
            this.computeFlags();
        }
        return this._canBeEval;
    }

    public boolean requiresBinding() {
        if (!this._flagsComputed) {
            this.computeFlags();
        }
        return this._requiresBinding;
    }

    public boolean canCaptureCallersBinding() {
        Operand r = this.getReceiver();
        IRMethod rm = this.getTargetMethodWithReceiver(r);
        return rm == null || rm.canCaptureCallersBinding();
    }

    public boolean isLVADataflowBarrier() {
        return this.canBeEval() || this.getClosureArg() != null && this.canCaptureCallersBinding();
    }

    @Override
    public String toString() {
        return "\t" + (this.result == null ? "" : this.result + " = ") + (Object)((Object)this.operation) + "(" + this._methAddr + ", " + this.receiver + ", " + Arrays.toString(this.getCallArgs()) + (this._closure == null ? "" : ", &" + this._closure) + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new CallInstr(ii.getRenamedVariable(this.result), this._methAddr.cloneForInlining(ii), this.receiver.cloneForInlining(ii), this.cloneCallArgs(ii), this._closure == null ? null : this._closure.cloneForInlining(ii));
    }

    private static Operand[] buildAllArgs(Operand methAddr, Operand receiver2, Operand[] callArgs, Operand closure) {
        Operand[] allArgs = new Operand[callArgs.length + 2 + (closure != null ? 1 : 0)];
        assert (methAddr != null) : "METHADDR is null";
        assert (receiver2 != null) : "RECEIVER is null";
        allArgs[0] = methAddr;
        allArgs[1] = receiver2;
        for (int i = 0; i < callArgs.length; ++i) {
            assert (callArgs[i] != null) : "ARG " + i + " is null";
            allArgs[i + 2] = callArgs[i];
        }
        if (closure != null) {
            allArgs[callArgs.length + 2] = closure;
        }
        return allArgs;
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        IRubyObject resultValue;
        Block block;
        Object ma = this._methAddr.retrieve(interp);
        IRubyObject[] args2 = this.prepareArguments(this.getCallArgs(), interp);
        Block block2 = block = this._closure == null ? null : this.prepareBlock(interp);
        if (ma instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)ma;
            assert (mh.getMethodNameOperand() == this.getReceiver());
            DynamicMethod m = mh.getResolvedMethod();
            String mn = mh.getResolvedMethodName();
            IRubyObject ro = mh.getReceiverObj();
            if (m.isUndefined()) {
                resultValue = RuntimeHelpers.callMethodMissing(interp.getContext(), ro, m.getVisibility(), mn, CallType.FUNCTIONAL, args2, block == null ? Block.NULL_BLOCK : block);
            } else {
                ThreadContext tc = interp.getContext();
                RubyClass rc = ro.getMetaClass();
                resultValue = block == null ? m.call(tc, ro, (RubyModule)rc, mn, args2) : m.call(tc, ro, (RubyModule)rc, mn, args2, block);
            }
        } else {
            IRubyObject object = (IRubyObject)this.getReceiver().retrieve(interp);
            String name2 = ma.toString();
            resultValue = block == null ? object.callMethod(interp.getContext(), name2, args2) : object.callMethod(interp.getContext(), name2, args2, block);
        }
        this.getResult().store(interp, resultValue);
        return null;
    }

    public Label interpret_with_inline(InterpreterContext interp, IRubyObject self) {
        IRubyObject resultValue;
        Block block;
        Object ma = this._methAddr.retrieve(interp);
        IRubyObject[] args2 = this.prepareArguments(this.getCallArgs(), interp);
        Block block2 = block = this._closure == null ? null : this.prepareBlock(interp);
        if (ma instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)ma;
            assert (mh.getMethodNameOperand() == this.getReceiver());
            DynamicMethod m = mh.getResolvedMethod();
            String mn = mh.getResolvedMethodName();
            IRubyObject ro = mh.getReceiverObj();
            if (m.isUndefined()) {
                resultValue = RuntimeHelpers.callMethodMissing(interp.getContext(), ro, m.getVisibility(), mn, CallType.FUNCTIONAL, args2, block == null ? Block.NULL_BLOCK : block);
            } else {
                Integer count2;
                ThreadContext tc = interp.getContext();
                RubyClass rc = ro.getMetaClass();
                if (this._profile == null) {
                    this._profile = new HashMap();
                }
                if ((count2 = this._profile.get(m)) == null) {
                    count2 = new Integer(1);
                } else if ((count2 = new Integer(count2 + 1)) > 50 && m instanceof InterpretedIRMethod && this._profile.size() == 1) {
                    IRMethod inlineableMethod = ((InterpretedIRMethod)m).method;
                    this._profile.remove(m);
                    throw new InlineMethodHint(inlineableMethod);
                }
                this._profile.put(m, count2);
                resultValue = block == null ? m.call(tc, ro, (RubyModule)rc, mn, args2) : m.call(tc, ro, (RubyModule)rc, mn, args2, block);
            }
        } else {
            IRubyObject object = (IRubyObject)this.getReceiver().retrieve(interp);
            String name2 = ma.toString();
            resultValue = block == null ? object.callMethod(interp.getContext(), name2, args2) : object.callMethod(interp.getContext(), name2, args2, block);
        }
        this.getResult().store(interp, resultValue);
        return null;
    }

    private Block prepareBlock(InterpreterContext interp) {
        Object value2 = this._closure.retrieve(interp);
        return value2 instanceof RubyProc ? ((RubyProc)value2).getBlock() : (Block)value2;
    }
}

