/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.compiler_pass.opts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.CopyInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.JumpInstr;
import org.jruby.compiler.ir.instructions.METHOD_VERSION_GUARD_Instr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.BreakResult;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalOptimizationPass
implements CompilerPass {
    @Override
    public boolean isPreOrder() {
        return false;
    }

    @Override
    public void run(IRScope s) {
        if (s instanceof IRExecutionScope) {
            IRExecutionScope es = (IRExecutionScope)s;
            List<IRClosure> closures = es.getClosures();
            for (IRClosure c : closures) {
                this.run(c);
            }
            LocalOptimizationPass.runLocalOpts(es);
            es.computeExecutionScopeFlags();
        }
    }

    private static void recordSimplification(Variable res, Operand val, Map<Operand, Operand> valueMap, Map<Variable, List<Variable>> simplificationMap) {
        valueMap.put(res, val);
        if (val instanceof Variable) {
            Variable v = (Variable)val;
            List<Variable> x = simplificationMap.get(val);
            if (x == null) {
                x = new ArrayList<Variable>();
                simplificationMap.put(v, x);
            }
            x.add(res);
        }
    }

    private static void runLocalOpts(IRExecutionScope s) {
        Label deoptLabel = s.getNewLabel();
        HashMap<Operand, Operand> valueMap = new HashMap<Operand, Operand>();
        HashMap<Variable, List<Variable>> simplificationMap = new HashMap<Variable, List<Variable>>();
        HashMap<String, CodeVersion> versionMap = new HashMap<String, CodeVersion>();
        ListIterator<Instr> instrs = s.getInstrs().listIterator();
        while (instrs.hasNext()) {
            List simplifiedVars;
            Instr i = instrs.next();
            Operation iop = i.operation;
            if (iop.startsBasicBlock()) {
                valueMap = new HashMap();
                simplificationMap = new HashMap();
                versionMap = new HashMap();
            }
            Operand val = i.simplifyAndGetResult(valueMap);
            Variable res = i.getResult();
            if (val != null && res != null && res != val) {
                LocalOptimizationPass.recordSimplification(res, val, valueMap, simplificationMap);
                if (val instanceof BreakResult) {
                    BreakResult br = (BreakResult)val;
                    i.markDead();
                    instrs.add(new CopyInstr(res, br._result));
                    instrs.add(new JumpInstr(br._jumpTarget));
                }
            } else if (iop.isCall()) {
                val = null;
                CallInstr call2 = (CallInstr)i;
                Operand r = call2.getReceiver();
                if (r != null) {
                    IRMethod rm;
                    Operand v;
                    if (!r.isConstant() && (v = (Operand)valueMap.get(r)) != null) {
                        r = v;
                    }
                    if ((rm = call2.getTargetMethodWithReceiver(r)) != null) {
                        IRModule rc = rm.getDefiningIRModule();
                        if (rc != null) {
                            Operand[] args2;
                            if (rc.isCoreClass("Fixnum")) {
                                args2 = call2.getOperands();
                                if (args2[2].isConstant()) {
                                    LocalOptimizationPass.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                                    val = ((Fixnum)r).computeValue(rm.getName(), (Constant)args2[2]);
                                }
                            } else if (rc.isCoreClass("Float")) {
                                args2 = call2.getOperands();
                                if (args2[2].isConstant()) {
                                    LocalOptimizationPass.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                                    val = ((Float)r).computeValue(rm.getName(), (Constant)args2[2]);
                                }
                            } else if (rc.isCoreClass("Array") && (args2 = call2.getOperands())[2] instanceof Fixnum && rm.getName() == "[]") {
                                LocalOptimizationPass.addMethodGuard(rm, deoptLabel, versionMap, instrs);
                                val = ((Array)r).fetchCompileTimeArrayElement(((Fixnum)args2[2]).value.intValue(), false);
                            }
                        }
                        if (val != null) {
                            i.markDead();
                            instrs.add(new CopyInstr(res, val));
                            LocalOptimizationPass.recordSimplification(res, val, valueMap, simplificationMap);
                        }
                    }
                }
            }
            if (res != null && (simplifiedVars = (List)simplificationMap.get(res)) != null) {
                for (Operand v : simplifiedVars) {
                    valueMap.remove(v);
                }
                simplificationMap.remove(res);
            }
            if (!iop.endsBasicBlock() && (!iop.isCall() || i.isDead())) continue;
            valueMap = new HashMap();
            simplificationMap = new HashMap();
            versionMap = new HashMap();
        }
    }

    private static void addMethodGuard(IRMethod m, Label deoptLabel, Map<String, CodeVersion> versionMap, ListIterator instrs) {
        String fullName = m.getFullyQualifiedName();
        CodeVersion knownVersion = versionMap.get(fullName);
        CodeVersion mVersion = m.getVersion();
        if (knownVersion == null || knownVersion._version != mVersion._version) {
            instrs.add(new METHOD_VERSION_GUARD_Instr(m, m.getVersion(), deoptLabel));
            versionMap.put(fullName, mVersion);
        }
    }
}

