/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.compiler_pass;

import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class InlineTest
implements CompilerPass {
    public final String methodToInline;

    public InlineTest(String m) {
        this.methodToInline = m;
    }

    public boolean isPreOrder() {
        return true;
    }

    public void run(IRScope s) {
        if (s instanceof IRMethod) {
            CFG c = ((IRMethod)s).getCFG();
            IRModule m = s.getNearestModule();
            IRMethod mi = m.getInstanceMethod(this.methodToInline);
            for (BasicBlock b : c.getNodes()) {
                for (Instr i : b.getInstrs()) {
                    CallInstr call2;
                    Operand addr2;
                    if (!(i instanceof CallInstr) || !((addr2 = (call2 = (CallInstr)i).getMethodAddr()) instanceof MethAddr) || !this.methodToInline.equals(((MethAddr)addr2).getName())) continue;
                    System.out.println("Will be inlining method " + this.methodToInline + " at callsite: " + call2);
                    c.inlineMethod(mi, b, call2);
                    return;
                }
            }
        }
    }
}

