/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.ReceiveArgumentInstruction;
import org.jruby.compiler.ir.instructions.ReceiveSelfInstruction;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;

public class IRMethod
extends IRExecutionScope {
    public final boolean isInstanceMethod;
    public final Label startLabel;
    public final Label endLabel;
    private CodeVersion version;
    private List<Operand> callArgs;
    private int nextLocalVariableSlot;
    private Map<String, LocalVariable> localVariables;
    private int nextAvailableBindingSlot;
    private Map<String, Integer> bindingSlotMap;

    public IRMethod(IRScope lexicalParent, Operand container, String name2, boolean isInstanceMethod, StaticScope staticScope) {
        super(lexicalParent, container, name2, staticScope);
        this.isInstanceMethod = isInstanceMethod;
        this.startLabel = this.getNewLabel("_METH_START");
        this.endLabel = this.getNewLabel("_METH_END");
        this.callArgs = new ArrayList<Operand>();
        this.bindingSlotMap = new HashMap<String, Integer>();
        this.nextAvailableBindingSlot = 0;
        this.localVariables = new HashMap<String, LocalVariable>();
        this.nextLocalVariableSlot = 0;
        this.updateVersion();
    }

    public void updateVersion() {
        this.version = CodeVersion.getClassVersionToken();
    }

    public String getScopeName() {
        return "Method";
    }

    public CodeVersion getVersion() {
        return this.version;
    }

    public void addInstr(Instr i) {
        if (i instanceof ReceiveArgumentInstruction || i instanceof ReceiveSelfInstruction) {
            this.callArgs.add(i.result);
        }
        super.addInstr(i);
    }

    public Operand[] getCallArgs() {
        return this.callArgs.toArray(new Operand[this.callArgs.size()]);
    }

    public void setConstantValue(String constRef, Operand val) {
        if (!this.isAClassRootMethod()) {
            throw new NotCompilableException("Unexpected: Encountered set constant value in a method!");
        }
        ((MetaObject)this.container).scope.setConstantValue(constRef, val);
    }

    public boolean isAClassRootMethod() {
        return IRModule.isAClassRootMethod(this);
    }

    public String getFullyQualifiedName() {
        IRModule m = this.getDefiningIRModule();
        return m == null ? null : m.getName() + ":" + this.getName();
    }

    public IRModule getDefiningIRModule() {
        if (!(this.container instanceof MetaObject)) {
            return null;
        }
        IRScope scope = ((MetaObject)this.container).scope;
        if (scope instanceof IRMethod) {
            scope = ((MetaObject)((IRMethod)scope).container).scope;
        }
        return (IRModule)scope;
    }

    protected StaticScope constructStaticScope(StaticScope unused2) {
        LocalStaticScope newScope = new LocalStaticScope(null);
        this.requiredArgs = 0;
        this.optionalArgs = 0;
        this.restArg = -1;
        return newScope;
    }

    public LocalVariable getLocalVariable(String name2) {
        LocalVariable variable = this.localVariables.get(name2);
        if (variable == null) {
            variable = new LocalVariable(name2, this.nextLocalVariableSlot);
            this.localVariables.put(name2, variable);
            ++this.nextLocalVariableSlot;
        }
        return variable;
    }

    public int assignBindingSlot(String varName) {
        Integer slot = this.bindingSlotMap.get(varName);
        if (slot == null) {
            slot = this.nextAvailableBindingSlot;
            this.bindingSlotMap.put(varName, this.nextAvailableBindingSlot);
            ++this.nextAvailableBindingSlot;
        }
        return slot;
    }

    public Integer getBindingSlot(String varName) {
        return this.bindingSlotMap.get(varName);
    }

    public int getBindingSlotsCount() {
        return this.nextAvailableBindingSlot;
    }

    public int getLocalVariablesCount() {
        return this.nextLocalVariableSlot;
    }
}

