/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import java.math.BigInteger;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.ByteList;

public class RuntimeCache {
    private static final int SCOPE = 0;
    private static final int SYMBOL = 1;
    private static final int FIXNUM = 2;
    private static final int CONSTANT = 3;
    private static final int REGEXP = 4;
    private static final int BIGINTEGER = 5;
    private static final int VARIABLEREADER = 6;
    private static final int VARIABLEWRITER = 7;
    private static final int BLOCKBODY = 8;
    private static final int BLOCKCALLBACK = 9;
    private static final int METHOD = 10;
    private static final int STRING = 11;
    private static final int ENCODING = 12;
    private static final StaticScope[] EMPTY_SCOPES = new StaticScope[0];
    public StaticScope[] scopes = EMPTY_SCOPES;
    private static final CallSite[] EMPTY_CALLSITES = new CallSite[0];
    public CallSite[] callSites = EMPTY_CALLSITES;
    private static final CacheEntry[] EMPTY_CACHEENTRIES = new CacheEntry[0];
    public CacheEntry[] methodCache = EMPTY_CACHEENTRIES;
    private static final BlockBody[] EMPTY_BLOCKBODIES = new BlockBody[0];
    public BlockBody[] blockBodies = EMPTY_BLOCKBODIES;
    private static final CompiledBlockCallback[] EMPTY_COMPILEDBLOCKCALLBACKS = new CompiledBlockCallback[0];
    public CompiledBlockCallback[] blockCallbacks = EMPTY_COMPILEDBLOCKCALLBACKS;
    private static final RubySymbol[] EMPTY_RUBYSYMBOLS = new RubySymbol[0];
    public RubySymbol[] symbols = EMPTY_RUBYSYMBOLS;
    private static final ByteList[] EMPTY_BYTELISTS = new ByteList[0];
    public ByteList[] byteLists = EMPTY_BYTELISTS;
    private static final Encoding[] EMPTY_ENCODINGS = new Encoding[0];
    public Encoding[] encodings = EMPTY_ENCODINGS;
    private static final RubyFixnum[] EMPTY_FIXNUMS = new RubyFixnum[0];
    public RubyFixnum[] fixnums = EMPTY_FIXNUMS;
    private static final RubyRegexp[] EMPTY_RUBYREGEXPS = new RubyRegexp[0];
    public RubyRegexp[] regexps = EMPTY_RUBYREGEXPS;
    private static final BigInteger[] EMPTY_BIGINTEGERS = new BigInteger[0];
    public BigInteger[] bigIntegers = EMPTY_BIGINTEGERS;
    private static final RubyClass.VariableAccessor[] EMPTY_VARIABLE_ACCESSORS = new RubyClass.VariableAccessor[0];
    public RubyClass.VariableAccessor[] variableReaders = EMPTY_VARIABLE_ACCESSORS;
    public RubyClass.VariableAccessor[] variableWriters = EMPTY_VARIABLE_ACCESSORS;
    public IRubyObject[] constants = IRubyObject.NULL_ARRAY;
    private static final int[] EMPTY_INTS = new int[0];
    public int[] constantGenerations = EMPTY_INTS;
    public int[] constantTargetHashes = EMPTY_INTS;

    public final StaticScope getScope(ThreadContext context, String varNamesDescriptor, int index2) {
        StaticScope scope = this.scopes[index2];
        if (scope == null) {
            String[] scopeData = varNamesDescriptor.split(",");
            String[] varNames = scopeData[0].split(";");
            for (int i = 0; i < varNames.length; ++i) {
                varNames[i] = varNames[i].intern();
            }
            scope = this.scopes[index2] = new LocalStaticScope(context.getCurrentScope().getStaticScope(), varNames);
        }
        return scope;
    }

    public final CallSite getCallSite(int index2) {
        return this.callSites[index2];
    }

    public final BlockBody getBlockBody(Object scriptObject, ThreadContext context, int index2, String descriptor) {
        BlockBody body = this.blockBodies[index2];
        if (body == null) {
            return this.createBlockBody(scriptObject, context, index2, descriptor);
        }
        return body;
    }

    public final BlockBody getBlockBody19(Object scriptObject, ThreadContext context, int index2, String descriptor) {
        BlockBody body = this.blockBodies[index2];
        if (body == null) {
            return this.createBlockBody19(scriptObject, context, index2, descriptor);
        }
        return body;
    }

    public final CompiledBlockCallback getBlockCallback(Object scriptObject, Ruby runtime2, int index2, String method2) {
        CompiledBlockCallback callback = this.blockCallbacks[index2];
        if (callback == null) {
            return this.createCompiledBlockCallback(scriptObject, runtime2, index2, method2);
        }
        return callback;
    }

    public final RubySymbol getSymbol(Ruby runtime2, int index2, String name2) {
        RubySymbol symbol = this.symbols[index2];
        if (symbol == null) {
            this.symbols[index2] = runtime2.newSymbol(name2);
            return this.symbols[index2];
        }
        return symbol;
    }

    public final RubyString getString(Ruby runtime2, int index2, int codeRange) {
        return RubyString.newStringShared(runtime2, this.getByteList(index2), codeRange);
    }

    public final ByteList getByteList(int index2) {
        return this.byteLists[index2];
    }

    public final Encoding getEncoding(int index2) {
        return this.encodings[index2];
    }

    public final RubyFixnum getFixnum(Ruby runtime2, int index2, int value2) {
        RubyFixnum fixnum = this.fixnums[index2];
        if (fixnum == null) {
            this.fixnums[index2] = RubyFixnum.newFixnum(runtime2, value2);
            return this.fixnums[index2];
        }
        return fixnum;
    }

    public final RubyFixnum getFixnum(Ruby runtime2, int index2, long value2) {
        RubyFixnum fixnum = this.fixnums[index2];
        if (fixnum == null) {
            this.fixnums[index2] = RubyFixnum.newFixnum(runtime2, value2);
            return this.fixnums[index2];
        }
        return fixnum;
    }

    public final RubyRegexp getRegexp(Ruby runtime2, int index2, ByteList pattern, int options2) {
        RubyRegexp regexp2 = this.regexps[index2];
        if (regexp2 == null || runtime2.getKCode() != regexp2.getKCode()) {
            regexp2 = RubyRegexp.newRegexp(runtime2, pattern, options2);
            regexp2.setLiteral();
            this.regexps[index2] = regexp2;
        }
        return regexp2;
    }

    public final RubyRegexp getRegexp(int index2) {
        return this.regexps[index2];
    }

    public final RubyRegexp cacheRegexp(int index2, RubyString pattern, int options2) {
        RubyRegexp regexp2 = this.regexps[index2];
        Ruby runtime2 = pattern.getRuntime();
        if (regexp2 == null || runtime2.getKCode() != regexp2.getKCode()) {
            this.regexps[index2] = regexp2 = RubyRegexp.newRegexp(runtime2, pattern.getByteList(), options2);
        }
        return regexp2;
    }

    public final BigInteger getBigInteger(Ruby runtime2, int index2, String pattern) {
        BigInteger bigint = this.bigIntegers[index2];
        if (bigint == null) {
            this.bigIntegers[index2] = new BigInteger(pattern, 16);
            return this.bigIntegers[index2];
        }
        return bigint;
    }

    public final IRubyObject getVariable(Ruby runtime2, int index2, String name2, IRubyObject object) {
        IRubyObject value2;
        RubyClass.VariableAccessor variableAccessor = this.variableReaders[index2];
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.variableReaders[index2] = variableAccessor = cls.getVariableAccessorForRead(name2);
        }
        if ((value2 = (IRubyObject)variableAccessor.get(object)) != null) {
            return value2;
        }
        if (runtime2.isVerbose()) {
            this.warnAboutUninitializedIvar(runtime2, name2);
        }
        return runtime2.getNil();
    }

    private void warnAboutUninitializedIvar(Ruby runtime2, String name2) {
        runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + name2 + " not initialized", new Object[0]);
    }

    public final IRubyObject setVariable(Ruby runtime2, int index2, String name2, IRubyObject object, IRubyObject value2) {
        RubyClass.VariableAccessor variableAccessor = this.variableWriters[index2];
        RubyClass cls = object.getMetaClass().getRealClass();
        if (variableAccessor.getClassId() != cls.hashCode()) {
            this.variableWriters[index2] = variableAccessor = cls.getVariableAccessorForWrite(name2);
        }
        variableAccessor.set(object, value2);
        return value2;
    }

    public final void initScopes(int size2) {
        this.scopes = new StaticScope[size2];
    }

    public final void initCallSites(int size2) {
        this.callSites = new CallSite[size2];
    }

    public final void initFromDescriptor(String descriptor) {
        String[] pieces = descriptor.split("\uffff");
        CallSite[] sites = new CallSite[pieces.length - 0];
        if (pieces[0].length() != 0) {
            block6: for (int i = 0; i < pieces.length - 1; i += 2) {
                switch (pieces[i + 1].charAt(0)) {
                    case 'N': {
                        sites[i / 2] = MethodIndex.getCallSite(pieces[i]);
                        continue block6;
                    }
                    case 'F': {
                        sites[i / 2] = MethodIndex.getFunctionalCallSite(pieces[i]);
                        continue block6;
                    }
                    case 'V': {
                        sites[i / 2] = MethodIndex.getVariableCallSite(pieces[i]);
                        continue block6;
                    }
                    case 'S': {
                        sites[i / 2] = MethodIndex.getSuperCallSite();
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("Unknown call type: " + pieces[i + 1] + " for method " + pieces[i]);
                    }
                }
            }
            this.callSites = sites;
        }
        this.initOthers(pieces[pieces.length - 1]);
    }

    public final void initOthers(String descriptor) {
        int encodingCount;
        int stringCount;
        int methodCount;
        int blockCallbackCount;
        int blockBodyCount;
        int variableWriterCount;
        int variableReaderCount;
        int bigIntegerCount;
        int regexpCount;
        int constantCount;
        int fixnumCount;
        int symbolCount;
        int scopeCount = RuntimeCache.getDescriptorValue(descriptor, 0);
        if (scopeCount > 0) {
            this.initScopes(scopeCount);
        }
        if ((symbolCount = RuntimeCache.getDescriptorValue(descriptor, 1)) > 0) {
            this.initSymbols(symbolCount);
        }
        if ((fixnumCount = RuntimeCache.getDescriptorValue(descriptor, 2)) > 0) {
            this.initFixnums(fixnumCount);
        }
        if ((constantCount = RuntimeCache.getDescriptorValue(descriptor, 3)) > 0) {
            this.initConstants(constantCount);
        }
        if ((regexpCount = RuntimeCache.getDescriptorValue(descriptor, 4)) > 0) {
            this.initRegexps(regexpCount);
        }
        if ((bigIntegerCount = RuntimeCache.getDescriptorValue(descriptor, 5)) > 0) {
            this.initBigIntegers(bigIntegerCount);
        }
        if ((variableReaderCount = RuntimeCache.getDescriptorValue(descriptor, 6)) > 0) {
            this.initVariableReaders(variableReaderCount);
        }
        if ((variableWriterCount = RuntimeCache.getDescriptorValue(descriptor, 7)) > 0) {
            this.initVariableWriters(variableWriterCount);
        }
        if ((blockBodyCount = RuntimeCache.getDescriptorValue(descriptor, 8)) > 0) {
            this.initBlockBodies(blockBodyCount);
        }
        if ((blockCallbackCount = RuntimeCache.getDescriptorValue(descriptor, 9)) > 0) {
            this.initBlockCallbacks(blockCallbackCount);
        }
        if ((methodCount = RuntimeCache.getDescriptorValue(descriptor, 10)) > 0) {
            this.initMethodCache(methodCount);
        }
        if ((stringCount = RuntimeCache.getDescriptorValue(descriptor, 11)) > 0) {
            this.initStrings(stringCount);
        }
        if ((encodingCount = RuntimeCache.getDescriptorValue(descriptor, 12)) > 0) {
            this.initEncodings(encodingCount);
        }
    }

    private static int getDescriptorValue(String descriptor, int type2) {
        return descriptor.charAt(type2);
    }

    public final void initBlockBodies(int size2) {
        this.blockBodies = new BlockBody[size2];
    }

    public final void initBlockCallbacks(int size2) {
        this.blockCallbacks = new CompiledBlockCallback[size2];
    }

    public final void initSymbols(int size2) {
        this.symbols = new RubySymbol[size2];
    }

    public final ByteList[] initStrings(int size2) {
        this.byteLists = new ByteList[size2];
        return this.byteLists;
    }

    public final Encoding[] initEncodings(int size2) {
        this.encodings = new Encoding[size2];
        return this.encodings;
    }

    public final void initFixnums(int size2) {
        this.fixnums = new RubyFixnum[size2];
    }

    public final void initRegexps(int size2) {
        this.regexps = new RubyRegexp[size2];
    }

    public final void initBigIntegers(int size2) {
        this.bigIntegers = new BigInteger[size2];
    }

    public final void initConstants(int size2) {
        this.constants = new IRubyObject[size2];
        this.constantTargetHashes = new int[size2];
        this.constantGenerations = new int[size2];
        Arrays.fill(this.constantGenerations, -1);
        Arrays.fill(this.constantTargetHashes, -1);
    }

    public final void initVariableReaders(int size2) {
        this.variableReaders = new RubyClass.VariableAccessor[size2];
        Arrays.fill(this.variableReaders, RubyClass.VariableAccessor.DUMMY_ACCESSOR);
    }

    public final void initVariableWriters(int size2) {
        this.variableWriters = new RubyClass.VariableAccessor[size2];
        Arrays.fill(this.variableWriters, RubyClass.VariableAccessor.DUMMY_ACCESSOR);
    }

    public final void initMethodCache(int size2) {
        this.methodCache = new CacheEntry[size2];
        Arrays.fill(this.methodCache, CacheEntry.NULL_CACHE);
    }

    public final IRubyObject getConstant(ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.getValue(context, name2, index2);
        return value2 != null ? value2 : context.getCurrentScope().getStaticScope().getModule().callMethod(context, "const_missing", (IRubyObject)context.getRuntime().fastNewSymbol(name2));
    }

    public IRubyObject getValue(ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.constants[index2];
        return this.isCached(context, value2, index2) ? value2 : this.reCache(context, name2, index2);
    }

    private boolean isCached(ThreadContext context, IRubyObject value2, int index2) {
        return value2 != null && this.constantGenerations[index2] == context.getRuntime().getConstantGeneration();
    }

    public IRubyObject reCache(ThreadContext context, String name2, int index2) {
        IRubyObject value2;
        int newGeneration = context.getRuntime().getConstantGeneration();
        this.constants[index2] = value2 = context.getConstant(name2);
        if (value2 != null) {
            this.constantGenerations[index2] = newGeneration;
        }
        return value2;
    }

    public final IRubyObject getConstantFrom(RubyModule target, ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.getValueFrom(target, context, name2, index2);
        return value2 != null ? value2 : target.fastGetConstantFromConstMissing(name2);
    }

    public IRubyObject getValueFrom(RubyModule target, ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.constants[index2];
        return this.isCachedFrom(target, context, value2, index2) ? value2 : this.reCacheFrom(target, context, name2, index2);
    }

    private boolean isCachedFrom(RubyModule target, ThreadContext context, IRubyObject value2, int index2) {
        return value2 != null && this.constantGenerations[index2] == context.getRuntime().getConstantGeneration() && this.constantTargetHashes[index2] == target.hashCode();
    }

    public IRubyObject reCacheFrom(RubyModule target, ThreadContext context, String name2, int index2) {
        IRubyObject value2;
        int newGeneration = context.getRuntime().getConstantGeneration();
        this.constants[index2] = value2 = target.fastGetConstantFromNoConstMissing(name2);
        if (value2 != null) {
            this.constantGenerations[index2] = newGeneration;
            this.constantTargetHashes[index2] = target.hashCode();
        }
        return value2;
    }

    private BlockBody createBlockBody(Object scriptObject, ThreadContext context, int index2, String descriptor) throws NumberFormatException {
        BlockBody body;
        this.blockBodies[index2] = body = RuntimeHelpers.createCompiledBlockBody(context, scriptObject, descriptor);
        return this.blockBodies[index2];
    }

    private BlockBody createBlockBody19(Object scriptObject, ThreadContext context, int index2, String descriptor) throws NumberFormatException {
        BlockBody body;
        this.blockBodies[index2] = body = RuntimeHelpers.createCompiledBlockBody19(context, scriptObject, descriptor);
        return this.blockBodies[index2];
    }

    private CompiledBlockCallback createCompiledBlockCallback(Object scriptObject, Ruby runtime2, int index2, String method2) {
        CompiledBlockCallback callback;
        this.blockCallbacks[index2] = callback = RuntimeHelpers.createBlockCallback(runtime2, scriptObject, method2, "(internal)", -1);
        return this.blockCallbacks[index2];
    }

    public DynamicMethod getMethod(ThreadContext context, RubyClass selfType, int index2, String methodName) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, selfType)) {
            return myCache.method;
        }
        return this.cacheAndGet(context, selfType, index2, methodName);
    }

    public DynamicMethod getMethod(ThreadContext context, IRubyObject self, int index2, String methodName) {
        return this.getMethod(context, RuntimeCache.pollAndGetClass(context, self), index2, methodName);
    }

    private DynamicMethod cacheAndGet(ThreadContext context, RubyClass selfType, int index2, String methodName) {
        CacheEntry entry = selfType.searchWithCache(methodName);
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return RuntimeHelpers.selectMethodMissing(context, selfType, method2.getVisibility(), methodName, CallType.FUNCTIONAL);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return RuntimeHelpers.selectMethodMissing(clazz, method2.getVisibility(), name1, CallType.FUNCTIONAL);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2, String name3) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2, name3);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2, String name3, String name4) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2, name3, name4);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2, String name3, String name4, String name5) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2, name3, name4, name5);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2, String name3, String name4, String name5, String name6) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2, name3, name4, name5, name6);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2, name3, name4, name5, name6, name7);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(RubyClass clazz, int index2, String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        CacheEntry entry = clazz.searchWithCache(name1);
        DynamicMethod method2 = entry.method;
        if (entry.method == UndefinedMethod.INSTANCE) {
            return this.searchWithCache(clazz, index2, name2, name3, name4, name5, name6, name7, name8);
        }
        this.methodCache[index2] = entry;
        return method2;
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2, String name3) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2, name3);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2, String name3, String name4) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2, name3, name4);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2, String name3, String name4, String name5) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2, name3, name4, name5);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2, String name3, String name4, String name5, String name6) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2, name3, name4, name5, name6);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2, name3, name4, name5, name6, name7);
    }

    public DynamicMethod searchWithCache(IRubyObject obj, int index2, String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        CacheEntry myCache = this.getCacheEntry(index2);
        if (CacheEntry.typeOk(myCache, obj.getMetaClass())) {
            return myCache.method;
        }
        return this.searchWithCache(obj.getMetaClass(), index2, name1, name2, name3, name4, name5, name6, name7, name8);
    }

    private static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private CacheEntry getCacheEntry(int index2) {
        return this.methodCache[index2];
    }
}

