/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.permutation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.jgrapht.experimental.permutation.IntegerPermutationIter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPermutationIter<E> {
    private ArrayPermutationsIter permOrder;
    private List<E> sourceArray;
    private int[] currPermutationArray;

    public CollectionPermutationIter(Set<E> set) {
        this(new ArrayList<E>(set), new IntegerPermutationIter(set.size()));
    }

    public CollectionPermutationIter(List<E> list2) {
        this(list2, new IntegerPermutationIter(list2.size()));
    }

    public CollectionPermutationIter(List<E> list2, ArrayPermutationsIter arrayPermutationsIter) {
        this.permOrder = arrayPermutationsIter;
        this.sourceArray = list2;
    }

    public boolean hasNext() {
        return this.permOrder.hasNextPermutaions();
    }

    public List<E> getNextArray() {
        List<E> list2;
        if (this.permOrder.hasNextPermutaions()) {
            this.currPermutationArray = this.permOrder.nextPermutation();
            list2 = this.applyPermutation();
        } else {
            list2 = null;
        }
        return list2;
    }

    private List<E> applyPermutation() {
        ArrayList<E> arrayList = new ArrayList<E>(this.sourceArray);
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.set(i, this.sourceArray.get(this.currPermutationArray[i]));
        }
        return arrayList;
    }

    public Set<E> getNextSet() {
        List<E> list2 = this.getNextArray();
        if (list2 == null) {
            return null;
        }
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>(list2);
        return linkedHashSet;
    }

    public int[] getCurrentPermutationArray() {
        return this.currPermutationArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Permutation int[]=");
        stringBuffer.append(Arrays.toString(this.getCurrentPermutationArray()));
        List<E> list2 = this.applyPermutation();
        stringBuffer.append("\nPermutationSet Source Object[]=");
        stringBuffer.append(this.sourceArray.toString());
        stringBuffer.append("\nPermutationSet Result Object[]=");
        stringBuffer.append(list2.toString());
        return stringBuffer.toString();
    }
}

