/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.Platform;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static final void putString(ByteBuffer buf, Charset charset, String value2) {
        BufferUtil.putCharSequence(buf, charset, (CharSequence)value2);
    }

    public static final String getString(ByteBuffer buf, Charset charset) {
        return ((Object)BufferUtil.getCharSequence(buf, charset)).toString();
    }

    public static final void putCharSequence(ByteBuffer buf, Charset charset, CharSequence value2) {
        BufferUtil.putCharSequence(buf, charset.newEncoder(), value2);
    }

    public static final void putCharSequence(ByteBuffer buf, CharsetEncoder encoder, CharSequence value2) {
        encoder.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(CharBuffer.wrap(value2), buf, true);
        encoder.flush(buf);
        int nulSize = Math.round(encoder.maxBytesPerChar());
        if (nulSize == 4) {
            buf.putInt(0);
        } else if (nulSize == 2) {
            buf.putShort((short)0);
        } else if (nulSize == 1) {
            buf.put((byte)0);
        }
    }

    public static final CharSequence getCharSequence(ByteBuffer buf, Charset charset) {
        return BufferUtil.getCharSequence(buf, charset.newDecoder());
    }

    public static final CharSequence getCharSequence(ByteBuffer buf, CharsetDecoder decoder) {
        ByteBuffer buffer = buf.slice();
        int end2 = BufferUtil.indexOf(buffer, (byte)0);
        if (end2 < 0) {
            end2 = buffer.limit();
        }
        buffer.position(0).limit(end2);
        try {
            return decoder.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(buffer);
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
    }

    public static final int positionOf(ByteBuffer buf, byte value2) {
        if (buf.hasArray()) {
            byte[] array = buf.array();
            int offset2 = buf.arrayOffset();
            int limit2 = buf.limit();
            for (int pos2 = buf.position(); pos2 < limit2; ++pos2) {
                if (array[offset2 + pos2] != value2) continue;
                return pos2;
            }
        } else {
            int limit3 = buf.limit();
            for (int pos3 = buf.position(); pos3 < limit3; ++pos3) {
                if (buf.get(pos3) != value2) continue;
                return pos3;
            }
        }
        return -1;
    }

    public static final int indexOf(ByteBuffer buf, byte value2) {
        if (buf.hasArray()) {
            byte[] array = buf.array();
            int begin2 = buf.arrayOffset() + buf.position();
            int end2 = begin2 + buf.limit();
            for (int offset2 = 0; offset2 < end2 && offset2 > -1; ++offset2) {
                if (array[begin2 + offset2] != value2) continue;
                return offset2;
            }
        } else {
            int begin3 = buf.position();
            for (int offset3 = 0; offset3 < buf.limit(); ++offset3) {
                if (buf.get(begin3 + offset3) != value2) continue;
                return offset3;
            }
        }
        return -1;
    }

    public static final long getAddress(ByteBuffer buf, int position) {
        return AddressIO.INSTANCE.getAddress(buf, position);
    }

    public static final void putAddress(ByteBuffer buf, int position, long address2) {
        AddressIO.INSTANCE.putAddress(buf, position, address2);
    }

    public static ByteBuffer slice(ByteBuffer buffer, int position) {
        ByteBuffer tmp = buffer.duplicate();
        tmp.position(position);
        return tmp.slice();
    }

    public static ByteBuffer slice(ByteBuffer buffer, int position, int size2) {
        ByteBuffer tmp = buffer.duplicate();
        tmp.position(position).limit(position + size2);
        return tmp.slice();
    }

    private static interface AddressIO {
        public static final AddressIO INSTANCE = Platform.getPlatform().addressSize() == 32 ? AddressIO32.IMPL : AddressIO64.IMPL;

        public long getAddress(ByteBuffer var1, int var2);

        public void putAddress(ByteBuffer var1, int var2, long var3);

        public static class AddressIO64
        implements AddressIO {
            public static final AddressIO IMPL = new AddressIO64();

            public long getAddress(ByteBuffer io2, int offset2) {
                return io2.getLong(offset2);
            }

            public void putAddress(ByteBuffer io2, int offset2, long address2) {
                io2.putLong(offset2, address2);
            }
        }

        public static class AddressIO32
        implements AddressIO {
            public static final AddressIO IMPL = new AddressIO32();

            public long getAddress(ByteBuffer io2, int offset2) {
                return io2.getInt(offset2);
            }

            public void putAddress(ByteBuffer io2, int offset2, long address2) {
                io2.putInt(offset2, (int)address2);
            }
        }
    }
}

