/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.unsafe.UnsafeFactory;

public class KernelJavaAddons {
    @JRubyMethod(name={"raise"}, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbRaise(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 1 && args2[0] instanceof ConcreteJavaProxy) {
            Object maybeThrowable = ((JavaObject)args2[0].dataGetStruct()).getValue();
            if (maybeThrowable instanceof Throwable) {
                UnsafeFactory.getUnsafe().throwException((Throwable)maybeThrowable);
                return recv2;
            }
            throw context.getRuntime().newTypeError("can't raise a non-Throwable Java object");
        }
        return RubyKernel.raise(context, recv2, args2, block);
    }

    @JRubyMethod(backtrace=true)
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject) {
        if (fromObject instanceof RubyArray) {
            return context.getRuntime().getJavaSupport().getObjectJavaClass().javaArrayFromRubyArray(context, fromObject);
        }
        return Java.getInstance(context.getRuntime(), fromObject.toJava(Object.class));
    }

    @JRubyMethod(backtrace=true)
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject, IRubyObject type2) {
        if (type2.isNil()) {
            return KernelJavaAddons.to_java(context, fromObject);
        }
        Ruby runtime2 = context.getRuntime();
        JavaClass targetType = KernelJavaAddons.getTargetType(context, runtime2, type2);
        if (fromObject instanceof RubyArray) {
            return targetType.javaArrayFromRubyArray(context, fromObject);
        }
        return Java.getInstance(runtime2, fromObject.toJava(targetType.javaClass()));
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_signature(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_name(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_implements(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_annotation(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_require(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_package(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    private static JavaClass getTargetType(ThreadContext context, Ruby runtime2, IRubyObject type2) {
        JavaClass targetType;
        if (type2 instanceof RubyString || type2 instanceof RubySymbol) {
            targetType = runtime2.getJavaSupport().getNameClassMap().get(type2.asJavaString());
            if (targetType == null) {
                targetType = JavaClass.forNameVerbose(runtime2, type2.asJavaString());
            }
        } else if (type2 instanceof RubyModule && type2.respondsTo("java_class")) {
            targetType = (JavaClass)RuntimeHelpers.invoke(context, type2, "java_class");
        } else {
            throw runtime2.newTypeError("unable to convert array to type: " + type2);
        }
        return targetType;
    }
}

