/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalGlobalVariable
extends GlobalVariable {
    private static String pattern = "([a-zA-Z]|(_([a-zA-Z]|_|\\d)))([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new LocalGlobalVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    private LocalGlobalVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    LocalGlobalVariable(String name2, IRubyObject irubyObject) {
        super(name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            BiVariable var;
            if (LocalGlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            String javaName = name2.substring(1);
            if (vars.containsKey(javaName)) {
                var = vars.getVariable(javaName);
                var.setRubyObject(value2);
                continue;
            }
            var = new LocalGlobalVariable(javaName, value2);
            vars.update(javaName, var);
        }
    }

    private static void updateMap(BiVariableMap vars, String name2, IRubyObject value2) {
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable(name2);
            var.setRubyObject(value2);
        } else {
            LocalGlobalVariable var = new LocalGlobalVariable(name2, value2);
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(Ruby runtime2, BiVariableMap vars, String key2) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        IRubyObject value2 = gvars.get("$" + key2);
        LocalGlobalVariable.updateMap(vars, key2, value2);
    }

    public static boolean isValidName(Object name2) {
        return LocalGlobalVariable.isValidName(pattern, name2);
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        runtime2.getGlobalVariables().set("$" + this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        this.setJavaObject(runtime2, null);
        runtime2.getGlobalVariables().set("$" + this.name, this.irubyObject);
    }
}

