/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.joni.BitStatus;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.StackEntry;
import org.joni.constants.StackType;

abstract class StackMachine
extends Matcher
implements StackType {
    protected static final int INVALID_INDEX = -1;
    protected StackEntry[] stack;
    protected int stk;
    protected final int[] repeatStk;
    protected final int memStartStk;
    protected final int memEndStk;
    protected byte[] stateCheckBuff;
    int stateCheckBuffSize;
    static final ThreadLocal<WeakReference<StackEntry[]>> stacks = new ThreadLocal<WeakReference<StackEntry[]>>(){

        @Override
        protected WeakReference<StackEntry[]> initialValue() {
            return new WeakReference<StackEntry[]>(StackMachine.allocateStack());
        }
    };
    private static final int STATE_CHECK_BUFF_MALLOC_THRESHOLD_SIZE = 16;

    protected StackMachine(Regex regex, byte[] byArray, int n, int n2) {
        super(regex, byArray, n, n2);
        this.stack = regex.stackNeeded ? StackMachine.fetchStack() : null;
        int n3 = regex.numRepeat + (regex.numMem << 1);
        this.repeatStk = n3 > 0 ? new int[n3] : null;
        this.memStartStk = regex.numRepeat - 1;
        this.memEndStk = this.memStartStk + regex.numMem;
    }

    private static StackEntry[] allocateStack() {
        StackEntry[] stackEntryArray = new StackEntry[64];
        stackEntryArray[0] = new StackEntry();
        return stackEntryArray;
    }

    private void doubleStack() {
        StackEntry[] stackEntryArray = new StackEntry[this.stack.length << 1];
        System.arraycopy(this.stack, 0, stackEntryArray, 0, this.stack.length);
        this.stack = stackEntryArray;
    }

    private static StackEntry[] fetchStack() {
        WeakReference<StackEntry[]> weakReference = stacks.get();
        StackEntry[] stackEntryArray = (StackEntry[])weakReference.get();
        if (stackEntryArray == null) {
            stackEntryArray = StackMachine.allocateStack();
            weakReference = new WeakReference<StackEntry[]>(stackEntryArray);
            stacks.set(weakReference);
        }
        return stackEntryArray;
    }

    protected final void init() {
        if (this.stack != null) {
            this.pushEnsured(1, this.regex.codeLength - 1);
        }
        if (this.repeatStk != null) {
            for (int i = 1; i <= this.regex.numMem; ++i) {
                this.repeatStk[i + this.memEndStk] = -1;
                this.repeatStk[i + this.memStartStk] = -1;
            }
        }
    }

    protected final StackEntry ensure1() {
        StackEntry stackEntry;
        if (this.stk >= this.stack.length) {
            this.doubleStack();
        }
        if ((stackEntry = this.stack[this.stk]) == null) {
            this.stack[this.stk] = stackEntry = new StackEntry();
        }
        return stackEntry;
    }

    protected final void pushType(int n) {
        this.ensure1().type = n;
        ++this.stk;
    }

    private int stateCheckPos(int n, int n2) {
        return (n - this.str) * this.regex.numCombExpCheck + (n2 - 1);
    }

    protected final boolean stateCheckVal(int n, int n2) {
        if (this.stateCheckBuff != null) {
            int n3 = this.stateCheckPos(n, n2);
            return (this.stateCheckBuff[n3 / 8] & 1 << n3 % 8) != 0;
        }
        return false;
    }

    private void stateCheckMark() {
        StackEntry stackEntry = this.stack[this.stk];
        int n = this.stateCheckPos(stackEntry.getStatePStr(), stackEntry.getStateCheck());
        int n2 = n / 8;
        this.stateCheckBuff[n2] = (byte)(this.stateCheckBuff[n2] | 1 << n % 8);
    }

    protected final void stateCheckBuffInit(int n, int n2, int n3) {
        if (n3 > 0 && n >= 7) {
            int n4 = (n + 1) * n3 + 7 >>> 3;
            n2 = n2 * n3 >>> 3;
            if (n4 > 0 && n2 < n4 && n4 < 16384) {
                this.stateCheckBuff = n4 >= 16 ? new byte[n4] : new byte[n4];
                Arrays.fill(this.stateCheckBuff, n2, n4 - n2, (byte)0);
                this.stateCheckBuffSize = n4;
            } else {
                this.stateCheckBuff = null;
                this.stateCheckBuffSize = 0;
            }
        } else {
            this.stateCheckBuff = null;
            this.stateCheckBuffSize = 0;
        }
    }

    protected final void stateCheckBuffClear() {
        this.stateCheckBuff = null;
        this.stateCheckBuffSize = 0;
    }

    private void push(int n, int n2, int n3, int n4) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = n;
        stackEntry.setStatePCode(n2);
        stackEntry.setStatePStr(n3);
        stackEntry.setStatePStrPrev(n4);
        ++this.stk;
    }

    protected final void pushEnsured(int n, int n2) {
        StackEntry stackEntry = this.stack[this.stk];
        stackEntry.type = n;
        stackEntry.setStatePCode(n2);
        ++this.stk;
    }

    protected final void pushAltWithStateCheck(int n, int n2, int n3, int n4) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 1;
        stackEntry.setStatePCode(n);
        stackEntry.setStatePStr(n2);
        stackEntry.setStatePStrPrev(n3);
        ++this.stk;
    }

    protected final void pushStateCheck(int n, int n2) {
        if (this.stateCheckBuff != null) {
            StackEntry stackEntry = this.ensure1();
            stackEntry.type = 4096;
            stackEntry.setStatePStr(n);
            stackEntry.setStateCheck(n2);
            ++this.stk;
        }
    }

    protected final void pushAlt(int n, int n2, int n3) {
        this.push(1, n, n2, n3);
    }

    protected final void pushPos(int n, int n2) {
        this.push(1280, -1, n, n2);
    }

    protected final void pushPosNot(int n, int n2, int n3) {
        this.push(3, n, n2, n3);
    }

    protected final void pushStopBT() {
        this.pushType(1536);
    }

    protected final void pushLookBehindNot(int n, int n2, int n3) {
        this.push(2, n, n2, n3);
    }

    protected final void pushRepeat(int n, int n2) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 1792;
        stackEntry.setRepeatNum(n);
        stackEntry.setRepeatPCode(n2);
        stackEntry.setRepeatCount(0);
        ++this.stk;
    }

    protected final void pushRepeatInc(int n) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 768;
        stackEntry.setSi(n);
        ++this.stk;
    }

    protected final void pushMemStart(int n, int n2) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 256;
        stackEntry.setMemNum(n);
        stackEntry.setMemPstr(n2);
        stackEntry.setMemStart(this.repeatStk[this.memStartStk + n]);
        stackEntry.setMemEnd(this.repeatStk[this.memEndStk + n]);
        this.repeatStk[this.memStartStk + n] = this.stk++;
        this.repeatStk[this.memEndStk + n] = -1;
    }

    protected final void pushMemEnd(int n, int n2) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 33280;
        stackEntry.setMemNum(n);
        stackEntry.setMemPstr(n2);
        stackEntry.setMemStart(this.repeatStk[this.memStartStk + n]);
        stackEntry.setMemEnd(this.repeatStk[this.memEndStk + n]);
        this.repeatStk[this.memEndStk + n] = this.stk++;
    }

    protected final void pushMemEndMark(int n) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 33792;
        stackEntry.setMemNum(n);
        ++this.stk;
    }

    protected final int getMemStart(int n) {
        int n2 = 0;
        int n3 = this.stk;
        while (n3 > 0) {
            StackEntry stackEntry = this.stack[--n3];
            if ((stackEntry.type & 0x8000) != 0 && stackEntry.getMemNum() == n) {
                ++n2;
                continue;
            }
            if (stackEntry.type != 256 || stackEntry.getMemNum() != n) continue;
            if (n2 == 0) break;
            --n2;
        }
        return n3;
    }

    protected final void pushNullCheckStart(int n, int n2) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 12288;
        stackEntry.setNullCheckNum(n);
        stackEntry.setNullCheckPStr(n2);
        ++this.stk;
    }

    protected final void pushNullCheckEnd(int n) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 20480;
        stackEntry.setNullCheckNum(n);
        ++this.stk;
    }

    protected final void pushCallFrame(int n) {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 2048;
        stackEntry.setCallFrameRetAddr(n);
        ++this.stk;
    }

    protected final void pushReturn() {
        StackEntry stackEntry = this.ensure1();
        stackEntry.type = 2304;
        ++this.stk;
    }

    protected final void popOne() {
        --this.stk;
    }

    protected final StackEntry pop() {
        switch (this.regex.stackPopLevel) {
            case 0: {
                return this.popFree();
            }
            case 1: {
                return this.popMemStart();
            }
        }
        return this.popDefault();
    }

    private StackEntry popFree() {
        StackEntry stackEntry;
        do {
            stackEntry = this.stack[--this.stk];
        } while ((stackEntry.type & 0xFF) == 0);
        return stackEntry;
    }

    private StackEntry popMemStart() {
        while (true) {
            StackEntry stackEntry = this.stack[--this.stk];
            if ((stackEntry.type & 0xFF) != 0) {
                return stackEntry;
            }
            if (stackEntry.type != 256) continue;
            this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
            this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemEnd();
        }
    }

    private StackEntry popDefault() {
        while (true) {
            StackEntry stackEntry = this.stack[--this.stk];
            if ((stackEntry.type & 0xFF) != 0) {
                return stackEntry;
            }
            if (stackEntry.type == 256) {
                this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
                this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemEnd();
                continue;
            }
            if (stackEntry.type == 768) {
                this.stack[stackEntry.getSi()].decreaseRepeatCount();
                continue;
            }
            if (stackEntry.type != 33280) continue;
            this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
            this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemEnd();
        }
    }

    protected final void popTilPosNot() {
        while (true) {
            --this.stk;
            StackEntry stackEntry = this.stack[this.stk];
            if (stackEntry.type == 3) break;
            if (stackEntry.type == 256) {
                this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
                this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
                continue;
            }
            if (stackEntry.type == 768) {
                this.stack[stackEntry.getSi()].decreaseRepeatCount();
                continue;
            }
            if (stackEntry.type != 33280) continue;
            this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
            this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
        }
    }

    protected final void popTilLookBehindNot() {
        while (true) {
            --this.stk;
            StackEntry stackEntry = this.stack[this.stk];
            if (stackEntry.type == 2) break;
            if (stackEntry.type == 256) {
                this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
                this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemEnd();
                continue;
            }
            if (stackEntry.type == 768) {
                this.stack[stackEntry.getSi()].decreaseRepeatCount();
                continue;
            }
            if (stackEntry.type != 33280) continue;
            this.repeatStk[this.memStartStk + stackEntry.getMemNum()] = stackEntry.getMemStart();
            this.repeatStk[this.memEndStk + stackEntry.getMemNum()] = stackEntry.getMemEnd();
        }
    }

    protected final int posEnd() {
        int n = this.stk;
        while (true) {
            StackEntry stackEntry = this.stack[--n];
            if ((stackEntry.type & 0x10FF) != 0) {
                stackEntry.type = 2560;
                continue;
            }
            if (stackEntry.type == 1280) break;
        }
        stackEntry.type = 2560;
        return n;
    }

    protected final void stopBtEnd() {
        int n = this.stk;
        while (true) {
            StackEntry stackEntry = this.stack[--n];
            if ((stackEntry.type & 0x10FF) != 0) {
                stackEntry.type = 2560;
                continue;
            }
            if (stackEntry.type == 1536) break;
        }
        stackEntry.type = 2560;
    }

    protected final int nullCheck(int n, int n2) {
        StackEntry stackEntry;
        int n3 = this.stk;
        do {
            stackEntry = this.stack[--n3];
        } while (stackEntry.type != 12288 || stackEntry.getNullCheckNum() != n);
        return stackEntry.getNullCheckPStr() == n2 ? 1 : 0;
    }

    protected final int nullCheckRec(int n, int n2) {
        int n3 = 0;
        int n4 = this.stk;
        while (true) {
            StackEntry stackEntry = this.stack[--n4];
            if (stackEntry.type == 12288) {
                if (stackEntry.getNullCheckNum() != n) continue;
                if (n3 == 0) {
                    return stackEntry.getNullCheckPStr() == n2 ? 1 : 0;
                }
                --n3;
                continue;
            }
            if (stackEntry.type != 20480) continue;
            ++n3;
        }
    }

    protected final int nullCheckMemSt(int n, int n2) {
        int n3;
        StackEntry stackEntry;
        int n4 = this.stk;
        do {
            stackEntry = this.stack[--n4];
        } while (stackEntry.type != 12288 || stackEntry.getNullCheckNum() != n);
        if (stackEntry.getNullCheckPStr() != n2) {
            n3 = 0;
        } else {
            n3 = 1;
            while (n4 < this.stk) {
                if (stackEntry.type == 256) {
                    if (stackEntry.getMemEnd() == -1) {
                        n3 = 0;
                        break;
                    }
                    int n5 = BitStatus.bsAt(this.regex.btMemEnd, stackEntry.getMemNum()) ? this.stack[stackEntry.getMemEnd()].getMemPStr() : stackEntry.getMemEnd();
                    if (this.stack[stackEntry.getMemStart()].getMemPStr() != n5) {
                        n3 = 0;
                        break;
                    }
                    if (n5 != n2) {
                        n3 = -1;
                    }
                }
                stackEntry = this.stack[++n4];
            }
        }
        return n3;
    }

    protected final int nullCheckMemStRec(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = this.stk;
        block0: while (true) {
            StackEntry stackEntry = this.stack[--n5];
            if (stackEntry.type == 12288) {
                if (stackEntry.getNullCheckNum() != n) continue;
                if (n4 == 0) {
                    if (stackEntry.getNullCheckPStr() != n2) {
                        n3 = 0;
                        break;
                    }
                    n3 = 1;
                    while (n5 < this.stk) {
                        if (stackEntry.type == 256) {
                            if (stackEntry.getMemEnd() == -1) {
                                n3 = 0;
                                break block0;
                            }
                            int n6 = BitStatus.bsAt(this.regex.btMemEnd, stackEntry.getMemNum()) ? this.stack[stackEntry.getMemEnd()].getMemPStr() : stackEntry.getMemEnd();
                            if (this.stack[stackEntry.getMemStart()].getMemPStr() != n6) {
                                n3 = 0;
                                break block0;
                            }
                            if (n6 != n2) {
                                n3 = -1;
                            }
                        }
                        stackEntry = this.stack[++n5];
                    }
                    break;
                }
                --n4;
                continue;
            }
            if (stackEntry.type != 20480 || stackEntry.getNullCheckNum() != n) continue;
            ++n4;
        }
        return n3;
    }

    protected final int getRepeat(int n) {
        int n2 = 0;
        int n3 = this.stk;
        while (true) {
            StackEntry stackEntry = this.stack[--n3];
            if (stackEntry.type == 1792) {
                if (n2 != 0 || stackEntry.getRepeatNum() != n) continue;
                return n3;
            }
            if (stackEntry.type == 2048) {
                --n2;
                continue;
            }
            if (stackEntry.type != 2304) continue;
            ++n2;
        }
    }

    protected final int sreturn() {
        int n = 0;
        int n2 = this.stk;
        while (true) {
            StackEntry stackEntry = this.stack[--n2];
            if (stackEntry.type == 2048) {
                if (n == 0) {
                    return stackEntry.getCallFrameRetAddr();
                }
                --n;
                continue;
            }
            if (stackEntry.type != 2304) continue;
            ++n;
        }
    }
}

