/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.exception.ErrorMessages;
import org.joni.exception.InternalException;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;

abstract class ScannerSupport
extends IntHolder
implements ErrorMessages {
    protected final Encoding enc;
    protected final byte[] bytes;
    protected int p;
    protected int stop;
    private int lastFetched;
    protected int c;
    private final int begin;
    private final int end;
    protected int _p;
    private final int INT_SIGN_BIT = Integer.MIN_VALUE;

    protected ScannerSupport(Encoding encoding2, byte[] byArray, int n, int n2) {
        this.enc = encoding2;
        this.bytes = byArray;
        this.begin = n;
        this.end = n2;
        this.reset();
    }

    protected int getBegin() {
        return this.begin;
    }

    protected int getEnd() {
        return this.end;
    }

    protected final int scanUnsignedNumber() {
        int n = 0;
        while (this.left()) {
            this.fetch();
            if (this.enc.isDigit(this.c)) {
                int n2 = n;
                if (((n2 ^ (n = n * 10 + Encoding.digitVal(this.c))) & Integer.MIN_VALUE) == 0) continue;
                return -1;
            }
            this.unfetch();
            break;
        }
        return n;
    }

    protected final int scanUnsignedHexadecimalNumber(int n) {
        int n2 = 0;
        while (this.left() && n-- != 0) {
            this.fetch();
            if (this.enc.isXDigit(this.c)) {
                int n3 = n2;
                int n4 = this.enc.xdigitVal(this.c);
                if (((n3 ^ (n2 = (n2 << 4) + n4)) & Integer.MIN_VALUE) == 0) continue;
                return -1;
            }
            this.unfetch();
            break;
        }
        return n2;
    }

    protected final int scanUnsignedOctalNumber(int n) {
        int n2 = 0;
        while (this.left() && n-- != 0) {
            this.fetch();
            if (this.enc.isDigit(this.c) && this.c < 56) {
                int n3 = n2;
                int n4 = Encoding.odigitVal(this.c);
                if (((n3 ^ (n2 = (n2 << 3) + n4)) & Integer.MIN_VALUE) == 0) continue;
                return -1;
            }
            this.unfetch();
            break;
        }
        return n2;
    }

    protected final void reset() {
        this.p = this.begin;
        this.stop = this.end;
    }

    protected final void mark() {
        this._p = this.p;
    }

    protected final void restore() {
        this.p = this._p;
    }

    protected final void inc() {
        this.lastFetched = this.p;
        this.p += this.enc.length(this.bytes, this.p, this.stop);
    }

    protected final void fetch() {
        this.c = this.enc.mbcToCode(this.bytes, this.p, this.stop);
        this.lastFetched = this.p;
        this.p += this.enc.length(this.bytes, this.p, this.stop);
    }

    protected int fetchTo() {
        int n = this.enc.mbcToCode(this.bytes, this.p, this.stop);
        this.lastFetched = this.p;
        this.p += this.enc.length(this.bytes, this.p, this.stop);
        return n;
    }

    protected final void unfetch() {
        this.p = this.lastFetched;
    }

    protected final int peek() {
        return this.p < this.stop ? this.enc.mbcToCode(this.bytes, this.p, this.stop) : 0;
    }

    protected final boolean peekIs(int n) {
        return this.peek() == n;
    }

    protected final boolean left() {
        return this.p < this.stop;
    }

    protected void newSyntaxException(String string2) {
        throw new SyntaxException(string2);
    }

    protected void newValueException(String string2) {
        throw new ValueException(string2);
    }

    protected void newValueException(String string2, String string3) {
        throw new ValueException(string2, string3);
    }

    protected void newValueException(String string2, int n, int n2) {
        throw new ValueException(string2, new String(this.bytes, n, n2 - n));
    }

    protected void newInternalException(String string2) {
        throw new InternalException(string2);
    }
}

