/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import jruby.objectweb.asm.ClassReader;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassCache;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.SafePropertyAccessor;

public class JITCompiler
implements JITCompilerMBean {
    public static final boolean USE_CACHE = true;
    public static final boolean DEBUG = SafePropertyAccessor.getBoolean("jruby.jit.debug", false);
    private AtomicLong compiledCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong failCount = new AtomicLong(0L);
    private AtomicLong abandonCount = new AtomicLong(0L);
    private AtomicLong compileTime = new AtomicLong(0L);
    private AtomicLong averageCompileTime = new AtomicLong(0L);
    private AtomicLong codeSize = new AtomicLong(0L);
    private AtomicLong averageCodeSize = new AtomicLong(0L);
    private AtomicLong largestCodeSize = new AtomicLong(0L);

    public JITCompiler(Ruby ruby2) {
        ruby2.getBeanManager().register(this);
    }

    public DynamicMethod tryJIT(DefaultMethod method2, ThreadContext context, String name2) {
        if (context.getRuntime().getInstanceConfig().getCompileMode().shouldJIT()) {
            return this.jitIsEnabled(method2, context, name2);
        }
        return null;
    }

    @Deprecated
    public void runJIT(DefaultMethod method2, ThreadContext context, String name2) {
        if (method2.getCallCount() < 0) {
            return;
        }
        this.jitIsEnabled(method2, context, name2);
    }

    private DynamicMethod jitIsEnabled(DefaultMethod method2, ThreadContext context, String name2) {
        RubyInstanceConfig instanceConfig = context.getRuntime().getInstanceConfig();
        if (method2.incrementCallCount() >= instanceConfig.getJitThreshold()) {
            return this.jitThresholdReached(method2, instanceConfig, context, name2);
        }
        return null;
    }

    private DynamicMethod jitThresholdReached(DefaultMethod method2, RubyInstanceConfig instanceConfig, ThreadContext context, String name2) {
        try {
            int methodCount;
            ClassCache classCache = instanceConfig.getClassCache();
            if (classCache.isFull()) {
                this.abandonCount.incrementAndGet();
                method2.setCallCount(-1);
                return null;
            }
            String moduleName = method2.getImplementationClass().getName();
            if (instanceConfig.getExcludedMethods().size() > 0) {
                IRubyObject possibleRealClass;
                String excludeModuleName = moduleName;
                if (method2.getImplementationClass().isSingleton() && (possibleRealClass = ((MetaClass)method2.getImplementationClass()).getAttached()) instanceof RubyModule) {
                    excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                }
                if (instanceConfig.getExcludedMethods().contains(excludeModuleName) || instanceConfig.getExcludedMethods().contains(excludeModuleName + "#" + name2) || instanceConfig.getExcludedMethods().contains(name2)) {
                    method2.setCallCount(-1);
                    return null;
                }
            }
            String key2 = SexpMaker.create(name2, method2.getArgsNode(), method2.getBodyNode());
            JITClassGenerator generator = new JITClassGenerator(name2, key2, context.getRuntime(), method2, context);
            Class sourceClass = instanceConfig.getClassCache().cacheClassByKey(key2, generator);
            if (sourceClass == null) {
                this.failCount.incrementAndGet();
                method2.setCallCount(-1);
                return null;
            }
            this.successCount.incrementAndGet();
            Script jitCompiledScript = (Script)sourceClass.newInstance();
            Set<Script> jittedMethods = context.getRuntime().getJittedMethods();
            jittedMethods.add(jitCompiledScript);
            if (instanceConfig.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % instanceConfig.getJitLogEvery() == 0) {
                JITCompiler.log(method2, name2, "live compiled methods: " + methodCount, new String[0]);
            }
            if (instanceConfig.isJitLogging()) {
                JITCompiler.log(method2, name2, "done jitting", new String[0]);
            }
            method2.switchToJitted(jitCompiledScript, generator.callConfig());
            return null;
        }
        catch (Throwable t) {
            if (context.getRuntime().getDebug().isTrue()) {
                t.printStackTrace();
            }
            if (instanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(method2, name2, "could not compile", t.getMessage());
            }
            this.failCount.incrementAndGet();
            method2.setCallCount(-1);
            return null;
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            byte[] digest2 = sha1.digest();
            char[] digestChars = new char[digest2.length * 2];
            for (int i = 0; i < digest2.length; ++i) {
                digestChars[i * 2] = Character.forDigit(digest2[i] & 0xF, 16);
                digestChars[i * 2 + 1] = Character.forDigit((digest2[i] & 0xF0) >> 4, 16);
            }
            return new String(digestChars).toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToCodeCache(Ruby ruby2, byte[] bytecode, String packageName, File cachedClassFile) {
        String codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
        File codeCacheDir = new File(codeCache);
        if (!codeCacheDir.exists()) {
            ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " does not exist");
        } else if (!codeCacheDir.isDirectory()) {
            ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not a directory");
        } else if (!codeCacheDir.canWrite()) {
            ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not writable");
        } else {
            boolean createdDirs;
            if (!new File(codeCache, packageName).isDirectory() && !(createdDirs = new File(codeCache, packageName).mkdirs())) {
                ruby2.getWarnings().warn("could not create JIT cache dir: " + new File(codeCache, packageName));
            }
            FileOutputStream fos = null;
            try {
                if (DEBUG) {
                    System.err.println("writing jitted code to to " + cachedClassFile);
                }
                fos = new FileOutputStream(cachedClassFile);
                fos.write(bytecode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod method2, String name2, String message2, String ... reason2) {
        String className = method2.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        System.err.print(message2 + ":" + className + "." + name2 + " at " + method2.getPosition());
        if (reason2.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < reason2.length; ++i) {
                System.err.print(reason2[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getCompileCount() {
        return this.compiledCount.get();
    }

    public long getFailCount() {
        return this.failCount.get();
    }

    public long getCompileTime() {
        return this.compileTime.get() / 1000L;
    }

    public long getAbandonCount() {
        return this.abandonCount.get();
    }

    public long getCodeSize() {
        return this.codeSize.get();
    }

    public long getAverageCodeSize() {
        return this.averageCodeSize.get();
    }

    public long getAverageCompileTime() {
        return this.averageCompileTime.get() / 1000L;
    }

    public long getLargestCodeSize() {
        return this.largestCodeSize.get();
    }

    public class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private StandardASMCompiler asmCompiler;
        private StaticScope staticScope;
        private Node bodyNode;
        private ArgsNode argsNode;
        private CallConfiguration jitCallConfig;
        private String digestString;
        private byte[] bytecode;
        private String name;
        private Ruby ruby;
        private String packageName = "ruby/jit";
        private String className;
        private String filename;
        private String methodName;

        public JITClassGenerator(String name2, String key2, Ruby ruby2, DefaultMethod method2, ThreadContext context) {
            this.digestString = JITCompiler.getHashForString(key2);
            this.className = this.packageName + "/" + JavaNameMangler.mangleStringForCleanJavaIdentifier(name2) + "_" + this.digestString;
            this.name = this.className.replaceAll("/", ".");
            this.bodyNode = method2.getBodyNode();
            this.argsNode = method2.getArgsNode();
            this.methodName = name2;
            this.filename = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method2.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(this.className, this.filename);
            this.ruby = ruby2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compile() {
            BodyCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            String codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
            File cachedClassFile = new File(codeCache + "/" + this.className + ".class");
            if (codeCache != null && cachedClassFile.exists()) {
                FileInputStream fis = null;
                try {
                    if (DEBUG) {
                        System.err.println("loading cached code from: " + cachedClassFile);
                    }
                    fis = new FileInputStream(cachedClassFile);
                    this.bytecode = new byte[(int)fis.getChannel().size()];
                    fis.read(this.bytecode);
                    this.name = new ClassReader(this.bytecode).getClassName();
                    return;
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {}
                }
            }
            long start2 = System.nanoTime();
            this.asmCompiler = new StandardASMCompiler(this.className, this.filename);
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler compiler = this.ruby.getInstanceConfig().newCompiler();
            CompilerCallback args2 = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context, true);
                }
            };
            ASTInspector inspector = new ASTInspector();
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startFileMethod(args2, this.staticScope, inspector);
                compiler.compile(this.bodyNode, methodCompiler, true);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startFileMethod(args2, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startFileMethod(null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.FrameNoneScopeNone;
            }
            methodCompiler.endBody();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.getCallConfig();
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            if (this.bytecode.length > this.ruby.getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + this.ruby.getInstanceConfig().getJitMaxSize());
            }
            if (codeCache != null) {
                JITCompiler.saveToCodeCache(this.ruby, this.bytecode, this.packageName, cachedClassFile);
            }
            JITCompiler.this.compiledCount.incrementAndGet();
            JITCompiler.this.compileTime.addAndGet(System.nanoTime() - start2);
            JITCompiler.this.codeSize.addAndGet(this.bytecode.length);
            JITCompiler.this.averageCompileTime.set(JITCompiler.this.compileTime.get() / JITCompiler.this.compiledCount.get());
            JITCompiler.this.averageCodeSize.set(JITCompiler.this.codeSize.get() / JITCompiler.this.compiledCount.get());
            AtomicLong atomicLong = JITCompiler.this.largestCodeSize;
            synchronized (atomicLong) {
                if (JITCompiler.this.largestCodeSize.get() < (long)this.bytecode.length) {
                    JITCompiler.this.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        public void generate() {
            this.compile();
        }

        public byte[] bytecode() {
            return this.bytecode;
        }

        public String name() {
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }

        public String toString() {
            return this.methodName + "() at " + this.bodyNode.getPosition().getFile() + ":" + this.bodyNode.getPosition().getLine();
        }
    }
}

