/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.Regex;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.exception.InternalException;

public final class UnsetAddrList {
    int num;
    Node[] targets;
    int[] offsets;

    public UnsetAddrList(int n) {
        this.targets = new Node[n];
        this.offsets = new int[n];
    }

    public void add(int n, Node node) {
        if (this.num >= this.offsets.length) {
            Node[] nodeArray = new Node[this.targets.length << 1];
            System.arraycopy(this.targets, 0, nodeArray, 0, this.num);
            this.targets = nodeArray;
            int[] nArray = new int[this.offsets.length << 1];
            System.arraycopy(this.offsets, 0, nArray, 0, this.num);
            this.offsets = nArray;
        }
        this.targets[this.num] = node;
        this.offsets[this.num] = n;
        ++this.num;
    }

    public void fix(Regex regex) {
        for (int i = 0; i < this.num; ++i) {
            EncloseNode encloseNode = (EncloseNode)this.targets[i];
            if (!encloseNode.isAddrFixed()) {
                new InternalException("internal parser error (bug)");
            }
            regex.code[this.offsets[i]] = encloseNode.callAddr;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.num > 0) {
            for (int i = 0; i < this.num; ++i) {
                stringBuilder.append("offset + " + this.offsets[i] + " target: " + this.targets[i].getAddressName());
            }
        }
        return stringBuilder.toString();
    }
}

