/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyMethods {
    public static RubyModule createJavaProxyMethods(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyModule javaProxyMethods = runtime2.defineModule("JavaProxyMethods");
        javaProxyMethods.defineAnnotatedMethods(JavaProxyMethods.class);
        return javaProxyMethods;
    }

    @JRubyMethod
    public static IRubyObject java_class(ThreadContext context, IRubyObject recv2) {
        return recv2.getMetaClass().getRealClass().fastGetInstanceVariable("@java_class");
    }

    @JRubyMethod
    public static IRubyObject java_object(ThreadContext context, IRubyObject recv2) {
        return (IRubyObject)recv2.dataGetStruct();
    }

    @JRubyMethod(name={"java_object="})
    public static IRubyObject java_object_set(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        recv2.dataWrapStruct(obj);
        return obj;
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(IRubyObject recv2, IRubyObject rhs) {
        return ((JavaObject)recv2.dataGetStruct()).op_equal(rhs);
    }

    @JRubyMethod
    public static IRubyObject to_s(IRubyObject recv2) {
        if (recv2.dataGetStruct() != null) {
            return ((JavaObject)recv2.dataGetStruct()).to_s();
        }
        return ((RubyObject)recv2).to_s();
    }

    @JRubyMethod(name={"eql?"})
    public static IRubyObject op_eql(IRubyObject recv2, IRubyObject rhs) {
        return ((JavaObject)recv2.dataGetStruct()).op_equal(rhs);
    }

    @JRubyMethod
    public static IRubyObject hash(IRubyObject recv2) {
        return ((JavaObject)recv2.dataGetStruct()).hash();
    }

    @JRubyMethod
    public static IRubyObject to_java_object(IRubyObject recv2) {
        return (JavaObject)recv2.dataGetStruct();
    }

    @JRubyMethod(name={"synchronized"})
    public static IRubyObject rbSynchronized(ThreadContext context, IRubyObject recv2, Block block) {
        return ((JavaObject)recv2.dataGetStruct()).ruby_synchronized(context, block);
    }
}

