/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.util.ClassCache;

public class LocalContext {
    private List loadPaths;
    private RubyInstanceConfig config;
    private LocalVariableBehavior behavior;
    private Ruby runtime = null;
    private BiVariableMap varMap = null;
    private HashMap attribute;

    public LocalContext() {
        String loadPath = System.getProperty("org.jruby.embed.class.path");
        if (loadPath == null) {
            loadPath = System.getProperty("java.class.path");
        }
        List<String> list2 = Arrays.asList(loadPath.split(File.pathSeparator));
        this.initialize(list2, new RubyInstanceConfig(), LocalVariableBehavior.TRANSIENT);
    }

    public LocalContext(List loadPaths) {
        this.initialize(loadPaths, new RubyInstanceConfig(), LocalVariableBehavior.TRANSIENT);
    }

    public LocalContext(List loadPaths, ClassCache classCache) {
        this.config = new RubyInstanceConfig();
        this.config.setClassCache(classCache);
        this.initialize(loadPaths, this.config, LocalVariableBehavior.TRANSIENT);
    }

    public LocalContext(List loadPaths, RubyInstanceConfig config, LocalVariableBehavior behavior) {
        this.initialize(loadPaths, config, behavior);
    }

    private void initialize(List loadPaths, RubyInstanceConfig config, LocalVariableBehavior behavior) {
        this.loadPaths = loadPaths;
        this.config = config;
        this.behavior = behavior;
        this.attribute = new HashMap();
        this.attribute.put(AttributeName.READER, new InputStreamReader(System.in));
        this.attribute.put(AttributeName.WRITER, new PrintWriter(System.out, true));
        this.attribute.put(AttributeName.ERROR_WRITER, new PrintWriter(System.err, true));
    }

    public Ruby getRuntime() {
        if (this.runtime == null) {
            this.runtime = JavaEmbedUtils.initialize(this.loadPaths, this.config);
        }
        return this.runtime;
    }

    public BiVariableMap getVarMap() {
        if (this.varMap == null) {
            this.varMap = new BiVariableMap(this.getRuntime(), this.behavior);
        }
        return this.varMap;
    }

    public HashMap getAttributeMap() {
        return this.attribute;
    }
}

