/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.jruby.Ruby;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;

public class ExternalScript
implements Library {
    private final LoadServiceResource resource;

    public ExternalScript(LoadServiceResource resource2, String name2) {
        this.resource = resource2;
    }

    public void load(Ruby runtime2, boolean wrap2) {
        InputStream in = null;
        try {
            in = this.resource.getInputStream();
            String name2 = JRubyFile.normalizeSeps(this.resource.getName());
            try {
                name2 = URLDecoder.decode(name2, "ISO-8859-1");
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (runtime2.getInstanceConfig().getCompileMode().shouldPrecompileAll()) {
                runtime2.compileAndLoadFile(name2, in, wrap2);
            } else {
                File path2 = this.resource.getPath();
                if (path2 != null && !this.resource.isAbsolute()) {
                    name2 = JRubyFile.normalizeSeps(path2.getCanonicalPath());
                }
                runtime2.loadFile(name2, in, wrap2);
            }
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {}
        }
    }

    public String toString() {
        return "ExternalScript: " + this.resource.getName();
    }
}

