/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.HashMap;
import java.util.Map;
import org.jruby.compiler.ir.IR_Method;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.operands.Operand;

public class IR_Class
extends IR_Module {
    private static final String ROOT_METHOD_PREFIX = ":_ROOT_:";
    private static Map<String, IR_Class> _coreClasses;
    public final Operand _superClass;
    public final boolean _isSingleton;
    private IR_Method _rootMethod;

    private static IR_Class addCoreClass(String name2, IR_Scope parent, String[] coreMethods) {
        IR_Class c = new IR_Class(parent, (IR_Scope)null, null, name2, false);
        _coreClasses.put(c._name, c);
        if (coreMethods != null) {
            for (String m : coreMethods) {
                IR_Method meth = new IR_Method(c, null, m, true);
                meth.setCodeModificationFlag(false);
                c.addMethod(meth);
            }
        }
        return c;
    }

    public static void bootStrap() {
        _coreClasses = new HashMap<String, IR_Class>();
        IR_Class obj = IR_Class.addCoreClass("Object", null, null);
        IR_Class.addCoreClass("Class", IR_Class.addCoreClass("Module", obj, null), null);
        IR_Class.addCoreClass("Fixnum", obj, new String[]{"+", "-", "/", "*"});
        IR_Class.addCoreClass("Float", obj, new String[]{"+", "-", "/", "*"});
        IR_Class.addCoreClass("Array", obj, new String[]{"[]"});
        IR_Class.addCoreClass("String", obj, null);
        IR_Class.addCoreClass("Range", obj, null);
        IR_Class.addCoreClass("Hash", obj, null);
    }

    public static boolean isAClassRootMethod(IR_Method m) {
        return m._name.startsWith(ROOT_METHOD_PREFIX);
    }

    public static IR_Class getCoreClass(String n) {
        return _coreClasses.get(n);
    }

    private void addRootMethod() {
        String n = ROOT_METHOD_PREFIX + this._name;
        this._rootMethod = new IR_Method(this, this, n, n, false);
        this.addMethod(this._rootMethod);
    }

    public IR_Class(IR_Scope parent, IR_Scope lexicalParent, Operand superClass, String className, boolean isSingleton) {
        super(parent, lexicalParent, className);
        this._superClass = superClass;
        this._isSingleton = isSingleton;
        this.addRootMethod();
    }

    public IR_Class(Operand parent, IR_Scope lexicalParent, Operand superClass, String className, boolean isSingleton) {
        super(parent, lexicalParent, className);
        this._superClass = superClass;
        this._isSingleton = isSingleton;
        this.addRootMethod();
    }

    public IR_Method getRootMethod() {
        return this._rootMethod;
    }

    public String toString() {
        return "Class: " + this._name + super.toString();
    }

    static {
        IR_Class.bootStrap();
    }
}

