/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class NoVarsDynamicScope
extends DynamicScope {
    private static final int SIZE = 0;
    private static final String SIZE_ERROR = "NoVarsDynamicScope only supports scopes with one variable";
    private static final String GROW_ERROR = "NoVarsDynamicScope cannot be grown; use ManyVarsDynamicScope";

    public NoVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public NoVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        this.growIfNeeded(0, GROW_ERROR);
    }

    protected void growIfNeeded(int size2, String message2) {
        if (this.staticScope.getNumberOfVariables() != size2) {
            throw new RuntimeException(message2);
        }
    }

    public DynamicScope cloneScope() {
        return new NoVarsDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return IRubyObject.NULL_ARRAY;
    }

    public IRubyObject getValue(int offset2, int depth) {
        assert (depth != 0) : "NoVarsDynamicScope only supports scopes with one variable";
        return this.parent.getValue(offset2, depth - 1);
    }

    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        return this.parent.getValueOrNil(offset2, depth - 1, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with any variables");
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with one or more variables");
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with two or more variables");
    }

    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with three or more variables");
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with four or more variables");
    }

    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        return this.parent.setValue(offset2, value2, depth - 1);
    }

    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with any variables");
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject value2) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with one or more variables");
    }

    public IRubyObject setValueOneDepthZero(IRubyObject value2) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with two or more variables");
    }

    public IRubyObject setValueTwoDepthZero(IRubyObject value2) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with three or more variables");
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject value2) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with four or more variables");
    }

    public void setArgValues(IRubyObject[] values, int size2) {
        assert (size2 <= 0) : this.getClass().getSimpleName() + " does not support scopes with " + size2 + " variables";
    }

    public void setArgValues(IRubyObject arg0) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with 1 variable");
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with 2 variables");
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        throw new RuntimeException(this.getClass().getSimpleName() + " does not support scopes with 3 variables");
    }

    public void setEndArgValues(IRubyObject[] values, int index2, int size2) {
        assert (false) : "NoVarsDynamicScope does not support any variables";
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs == 0) : "NoVarsDynamicScope only supports scopes with no variables";
        return IRubyObject.NULL_ARRAY;
    }
}

